/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzG4;
import com.aspose.words.internal.zzHx;
import com.aspose.words.internal.zzQs;
import com.aspose.words.internal.zzTe;
import com.aspose.words.internal.zzUs;
import com.aspose.words.internal.zzVYP;
import com.aspose.words.internal.zzVZy;
import com.aspose.words.internal.zzW9t;
import java.security.InvalidAlgorithmParameterException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

final class zzXJq
extends CertPathValidatorSpi {
    private final Provider zzxt;

    zzXJq(Provider provider) {
        this.zzxt = provider;
    }

    @Override
    public final CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters params) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        HashSet hashSet;
        int n;
        PublicKey publicKey;
        X500Principal x500Principal;
        TrustAnchor trustAnchor;
        zzTe zzTe2;
        if (params instanceof zzTe) {
            zzTe2 = (zzTe)params;
        } else if (params instanceof zzQs) {
            zzTe2 = ((zzQs)params).zzYBv();
        } else if (params instanceof PKIXParameters) {
            zzTe2 = new zzTe.zzXSC((PKIXParameters)params).zzX4h();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be " + PKIXParameters.class.getName() + " or " + zzTe.class.getName() + " instance.");
        }
        if (zzTe2.zzYLx() == null) {
            throw new InvalidAlgorithmParameterException("trustAnchors is null, this is not allowed for certification path validation.");
        }
        List<? extends Certificate> list = certPath.getCertificates();
        int n2 = list.size();
        if (list.isEmpty()) {
            throw new CertPathValidatorException("Certification path is empty.", null, certPath, -1);
        }
        Set set = zzTe2.zzY3k();
        try {
            List<? extends Certificate> list2 = list;
            trustAnchor = zzVZy.zzXSC((X509Certificate)list2.get(list2.size() - 1), zzTe2.zzYLx(), zzTe2.zzZ9S());
        }
        catch (zzVYP zzVYP2) {
            throw new CertPathValidatorException(zzVYP2.getMessage(), (Throwable)zzVYP2, certPath, list.size() - 1);
        }
        if (trustAnchor == null) {
            throw new CertPathValidatorException("Trust anchor for certification path not found.", null, certPath, -1);
        }
        zzTe2 = new zzTe.zzXSC(zzTe2).zzXSC(trustAnchor).zzX4h();
        List[] listArray = new ArrayList[n2 + 1];
        for (int i = 0; i < listArray.length; ++i) {
            listArray[i] = new ArrayList();
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add("2.5.29.32.0");
        zzHx zzHx2 = new zzHx(new ArrayList(), 0, hashSet2, null, new HashSet(), "2.5.29.32.0", false);
        listArray[0].add(zzHx2);
        zzG4 zzG42 = new zzG4();
        HashSet hashSet3 = new HashSet();
        int n3 = zzTe2.zzB2() ? 0 : n2 + 1;
        int n4 = zzTe2.zzWyT() ? 0 : n2 + 1;
        int n5 = zzTe2.zzVRk() ? 0 : n2 + 1;
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        try {
            if (x509Certificate != null) {
                x500Principal = zzVZy.zzY5s(x509Certificate);
                publicKey = x509Certificate.getPublicKey();
            } else {
                x500Principal = new X500Principal(trustAnchor.getCAName());
                publicKey = trustAnchor.getCAPublicKey();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertPathValidatorException("Subject of trust anchor could not be (re)encoded.", (Throwable)illegalArgumentException, certPath, -1);
        }
        try {
            zzVZy.zzXSC(publicKey);
        }
        catch (CertPathValidatorException certPathValidatorException) {
            throw new CertPathValidatorException("Algorithm identifier of public key of trust anchor could not be read.", (Throwable)certPathValidatorException, certPath, -1);
        }
        int n6 = n2;
        if (zzTe2.zzVQv() != null && !zzTe2.zzVQv().match((X509Certificate)list.get(0))) {
            throw new CertPathValidatorException("Target certificate in certification path does not match targetConstraints.", null, certPath, 0);
        }
        List list3 = zzTe2.zzXCf();
        Iterator iterator = list3.iterator();
        while (iterator.hasNext()) {
            ((PKIXCertPathChecker)iterator.next()).init(false);
        }
        X509Certificate x509Certificate2 = null;
        for (n = list.size() - 1; n >= 0; --n) {
            boolean bl;
            int n7 = n2 - n;
            x509Certificate2 = (X509Certificate)list.get(n);
            boolean bl2 = bl = n == list.size() - 1;
            if (x509Certificate2 == null) {
                throw new CertPathValidatorException("NULL certificate found", null, certPath, n);
            }
            zzW9t.zzXSC(certPath, zzTe2, n, publicKey, bl, x500Principal, x509Certificate, this.zzxt);
            zzW9t.zzXSC(certPath, n, zzG42);
            zzHx2 = zzW9t.zzXSC(certPath, n, hashSet3, zzHx2, listArray, n4);
            zzHx2 = zzW9t.zzXSC(certPath, n, zzHx2);
            zzW9t.zzXSC(certPath, n, zzHx2, n3);
            if (n7 == n2) continue;
            if (x509Certificate2.getVersion() == 1) {
                throw new CertPathValidatorException("Version 1 certificates can't be used as CA ones.", null, certPath, n);
            }
            zzW9t.zzXSC(certPath, n);
            zzHx2 = zzW9t.zzXSC(certPath, n, listArray, zzHx2, n5);
            zzW9t.zzY5s(certPath, n, zzG42);
            n3 = zzW9t.zzGr(certPath, n, n3);
            n5 = zzW9t.zz6A(certPath, n, n5);
            n4 = zzW9t.zzWmO(certPath, n, n4);
            n3 = zzW9t.zzXSC(certPath, n, n3);
            n5 = zzW9t.zzY5s(certPath, n, n5);
            n4 = zzW9t.zzXl6(certPath, n, n4);
            zzW9t.zzY5s(certPath, n);
            n6 = zzW9t.zzVV9(certPath, n, n6);
            n6 = zzW9t.zzMp(certPath, n, n6);
            zzW9t.zzXl6(certPath, n);
            hashSet = x509Certificate2.getCriticalExtensionOIDs();
            if (hashSet != null) {
                hashSet = new HashSet(hashSet);
                hashSet.removeAll(zzW9t.zzZPD);
            } else {
                hashSet = new HashSet();
            }
            zzW9t.zzXSC(certPath, n, hashSet, list3);
            x509Certificate = x509Certificate2;
            x500Principal = zzVZy.zzY5s(x509Certificate);
            try {
                publicKey = zzVZy.zzXSC(certPath.getCertificates(), n, this.zzxt);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new CertPathValidatorException("Next working key could not be retrieved.", (Throwable)certPathValidatorException, certPath, n);
            }
            zzVZy.zzXSC(publicKey);
        }
        n3 = zzW9t.zzXSC(n3, x509Certificate2);
        n3 = zzW9t.zzW3w(certPath, n + 1, n3);
        Set<String> set2 = x509Certificate2.getCriticalExtensionOIDs();
        if (set2 != null) {
            set2 = new HashSet<String>(set2);
            set2.removeAll(zzW9t.zzZPD);
            set2.remove(zzUs.zzYZ.getId());
        } else {
            set2 = new HashSet<String>();
        }
        zzW9t.zzXSC(certPath, n + 1, list3, set2);
        hashSet = zzW9t.zzXSC(certPath, zzTe2, set, n + 1, listArray, zzHx2, hashSet3);
        if (n3 > 0 || hashSet != null) {
            return new PKIXCertPathValidatorResult(trustAnchor, (PolicyNode)((Object)hashSet), x509Certificate2.getPublicKey());
        }
        throw new CertPathValidatorException("Path processing failed on policy.", null, certPath, n);
    }
}

