/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzBI;
import com.aspose.words.internal.zzQs;
import com.aspose.words.internal.zzUs;
import com.aspose.words.internal.zzVYP;
import com.aspose.words.internal.zzVZy;
import com.aspose.words.internal.zzWy6;
import com.aspose.words.internal.zzXJq;
import com.aspose.words.internal.zzjR;
import com.aspose.words.internal.zztw;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzZ5g
extends CertPathBuilderSpi {
    private final zzBI zzYEe;
    private zzVYP zzYQT;

    zzZ5g(zzBI zzBI2) {
        this.zzYEe = zzBI2;
    }

    @Override
    public final CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        zzQs pkixParams;
        if (params instanceof zzQs) {
            pkixParams = (zzQs)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new zzQs.zzXSC((PKIXBuilderParameters)params).zzZck();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + zzQs.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        zzWy6 zzWy62 = pkixParams.zzYBv().zzVQv();
        try {
            collection = zzVZy.zzXSC(zzWy62, pkixParams.zzYBv().zzWci());
            collection.addAll(zzVZy.zzXSC(zzWy62, pkixParams.zzYBv().zzZJL()));
        }
        catch (zzVYP zzVYP2) {
            throw new CertPathBuilderException("Error finding target certificate.", zzVYP2);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.zzXSC(x509Certificate, pkixParams, arrayList);
        }
        if (certPathBuilderResult == null && this.zzYQT != null) {
            throw new CertPathBuilderException(this.zzYQT.getMessage(), this.zzYQT.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult zzXSC(X509Certificate x509Certificate, zzQs zzQs2, List list) throws CertPathBuilderException {
        zzXJq zzXJq2;
        zzjR zzjR2;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (zzQs2.zzXOm().contains(x509Certificate)) {
            return null;
        }
        if (zzQs2.zzEZ() != -1 && list.size() - 1 > zzQs2.zzEZ()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            zzjR2 = new zzjR(this.zzYEe);
            zzXJq2 = new zzXJq(this.zzYEe);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (zzVZy.zzXSC(x509Certificate, zzQs2.zzYBv().zzYLx(), zzQs2.zzYBv().zzZ9S()) != null) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = zzjR2.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new zzVYP("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)zzXJq2.engineValidate(certPath, zzQs2);
                }
                catch (Exception exception) {
                    throw new zzVYP("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<zztw> arrayList = new ArrayList<zztw>();
            arrayList.addAll(zzQs2.zzYBv().zzWci());
            try {
                arrayList.addAll(zzVZy.zzXSC(x509Certificate.getExtensionValue(zzUs.zzVZ9.getId()), zzQs2.zzYBv().zzZhh()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new zzVYP("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(zzVZy.zzXSC(x509Certificate, zzQs2.zzYBv().zzZJL(), arrayList));
            }
            catch (zzVYP zzVYP2) {
                throw new zzVYP("Cannot find issuer certificate for certificate in certification path.", zzVYP2);
            }
            if (hashSet.isEmpty()) {
                throw new zzVYP("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.zzXSC(x509Certificate2, zzQs2, list);
            }
        }
        catch (zzVYP zzVYP3) {
            this.zzYQT = zzVYP3;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

