/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzXfq;
import com.aspose.words.net.System.Data.Constraint;
import com.aspose.words.net.System.Data.ConstraintException;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.ForeignKeyConstraint;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzGr;
import com.aspose.words.net.System.Data.zzVV9;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ConstraintCollection
implements Iterable<Constraint> {
    private final List<Constraint> zzYEa;
    private final DataTable zzZda;
    private final AtomicInteger zzWuc;

    ConstraintCollection(DataTable table) {
        this.zzZda = table;
        this.zzWuc = new AtomicInteger(1);
        this.zzYEa = new ArrayList<Constraint>();
    }

    public Constraint get(String constraintName) {
        if (zzXfq.zzcs(constraintName)) {
            return null;
        }
        for (Constraint constraint : this.zzYEa) {
            if (!constraint.getConstraintName().equals(constraintName)) continue;
            return constraint;
        }
        return null;
    }

    public Constraint get(int idx) {
        return this.zzYEa.get(idx);
    }

    public void add(Constraint constraint) throws DataException, InvalidConstraintException {
        if (constraint == null) {
            return;
        }
        if (this == constraint.zzY8n()) {
            throw new IllegalArgumentException("Constraint already belongs to this collection.");
        }
        if (null != constraint.zzY8n()) {
            throw new IllegalArgumentException("Constraint already belongs to another collection.");
        }
        for (Constraint constraint2 : this) {
            if (!constraint2.equals(constraint)) continue;
            throw new DataException("Constraint matches contraint named '" + constraint2.getConstraintName() + "' already in collection");
        }
        if (this.zzXSC(constraint.getConstraintName(), null)) {
            throw new DataException("Constraint name already exists.");
        }
        constraint.addToConstraintCollectionSetup(this);
        if (constraint.getConstraintName() == null || "".equals(constraint.getConstraintName())) {
            constraint.setConstraintName(this.zzZVf());
        }
        constraint.zzXSC(this);
        this.zzYEa.add(constraint);
        if (constraint instanceof UniqueConstraint && ((UniqueConstraint)constraint).isPrimaryKey()) {
            this.zzZda.setPrimaryKey(((UniqueConstraint)constraint).getColumns());
        }
    }

    public void remove(Constraint constraint) {
        if (constraint == null) {
            return;
        }
        this.zzYEa.remove(constraint);
    }

    public boolean contains(Constraint cc) {
        if (cc != null) {
            return false;
        }
        return this.zzYEa.contains(cc);
    }

    public int getCount() {
        return this.zzYEa.size();
    }

    @Override
    public Iterator<Constraint> iterator() {
        return this.zzYEa.iterator();
    }

    final DataTable getTable() {
        return this.zzZda;
    }

    final List<ForeignKeyConstraint> zzX2p() {
        ArrayList<ForeignKeyConstraint> arrayList = new ArrayList<ForeignKeyConstraint>();
        for (Constraint constraint : this.zzYEa) {
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            arrayList.add((ForeignKeyConstraint)constraint);
        }
        return arrayList;
    }

    final void zzXSC(DataRow dataRow) throws ConstraintException, InvalidConstraintException {
        for (Constraint constraint : this.zzYEa) {
            if (constraint instanceof UniqueConstraint) {
                this.zzXSC((UniqueConstraint)constraint, dataRow);
            }
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            this.zzXSC((ForeignKeyConstraint)constraint, dataRow);
        }
    }

    private boolean zzXSC(String string, Constraint constraint) {
        for (Constraint constraint2 : this.zzYEa) {
            if (constraint2.equals(null) || zzXfq.zz6A(string, constraint2.getConstraintName(), false) != 0) continue;
            return true;
        }
        return false;
    }

    private String zzZVf() {
        return "Constraint" + this.zzWuc.getAndIncrement();
    }

    private void zzXSC(UniqueConstraint uniqueConstraint, DataRow dataRow) throws ConstraintException {
        zzGr zzGr2 = this.zzZda.zzXVr().zzVV9(uniqueConstraint.getColumns());
        Map<String, Object> map = zzGr2.zzMp(dataRow);
        if (map != null && !map.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                stringBuilder.append(zzXfq.zzY5s("Column '{0}' is constrained to be unique.  Value '{1}' is already present.", entry.getKey(), entry.getValue()));
            }
            throw new ConstraintException(stringBuilder.toString());
        }
    }

    private void zzXSC(ForeignKeyConstraint foreignKeyConstraint, DataRow dataRow) throws InvalidConstraintException {
        if (this.zzZda.getDataSet() == null) {
            return;
        }
        DataRelationCollection dataRelationCollection = this.zzZda.getDataSet().getRelations();
        if (dataRelationCollection.getCount() == 0) {
            return;
        }
        Object object = this;
        if (foreignKeyConstraint.getRelatedTable().getTableName().equals(((ConstraintCollection)object).zzZda.getTableName())) {
            return;
        }
        object = this;
        if (!foreignKeyConstraint.getTable().getTableName().equals(((ConstraintCollection)object).zzZda.getTableName())) {
            return;
        }
        DataTable dataTable = foreignKeyConstraint.getRelatedTable();
        DataRow dataRow2 = dataRow;
        DataColumn[] dataColumnArray = foreignKeyConstraint.getColumns();
        DataColumn[] dataColumnArray2 = foreignKeyConstraint.getRelatedColumns();
        object = dataTable;
        if (!zzVV9.zzXSC(dataTable, dataColumnArray2, dataColumnArray, dataRow2)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (DataColumn dataColumn : foreignKeyConstraint.getColumns()) {
                stringBuilder.append(zzXfq.zzY5s("ForeignKeyConstraint '{0}' requires the child key values ('{1}') to exist in the parent table.", foreignKeyConstraint.getConstraintName(), dataRow.get(dataColumn)));
            }
            throw new InvalidConstraintException(stringBuilder.toString());
        }
    }
}

