/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzXfq;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzXDl = new ArrayList();
    private final Map<String, DataColumn> zzXMU = new HashMap<String, DataColumn>();
    private DataTable zzZda;

    DataColumnCollection(DataTable table) {
        this.zzZda = table;
    }

    public void add(DataColumn column) {
        if (zzXfq.zzcs(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzW2m(column.getColumnName());
        if (this.zzXMU.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzY5s(this.zzZda);
        column.setOrdinal(this.zzXDl.size());
        this.zzXDl.add(column);
        this.zzXMU.put(string, column);
        this.zzZda.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzZda);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzXfq.zzcs(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzW2m(columnName);
        DataColumn dataColumn = this.zzXMU.get(string);
        if (dataColumn != null) {
            int n = this.zzXDl.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzXDl.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzXDl.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzXDl.remove(n);
            this.zzXMU.remove(DataColumnCollection.zzW2m(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzZda.getRows()) {
                dataRow.remove(n);
            }
            this.zzZda.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzXDl.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzXDl.iterator();
    }

    public void clear() {
        this.zzXMU.clear();
        this.zzXDl.clear();
    }

    final DataColumn[] zzJ() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzXDl);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzXSC(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzXDl.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzXDl.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzW2m(string);
            String string3 = DataColumnCollection.zzW2m(dataColumn.getColumnName());
            this.zzXMU.remove(string3);
            this.zzXMU.put(string2, dataColumn);
            return;
        }
    }

    private static String zzW2m(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

