/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzLJ;
import com.aspose.words.internal.zzXfq;
import com.aspose.words.internal.zzZDw;
import com.aspose.words.internal.zzZfg;
import com.aspose.words.net.System.Data.DBNull;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.zzVV9;
import com.aspose.words.net.System.Data.zzY5s;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DataRow {
    private final DataTable zzZda;
    private Object[] zzWef;
    private int zzWOe = 1;
    private int zzXbO;
    private String zzWos;
    private Map<String, Object> zzYmg = new HashMap<String, Object>();
    private Map<String, String> zzXc3 = new HashMap<String, String>();

    protected DataRow(DataTable table) {
        this.zzZda = table;
        this.zzWef = new Object[table.getColumns().getCount()];
    }

    public boolean readFrom(ResultSet resultSet) throws SQLException {
        Object[] objectArray = zzY5s.zzXl6(resultSet, this.getTable());
        if (objectArray != null) {
            int n = this.getTable().getColumns().getCount();
            for (int i = 0; i < n; ++i) {
                this.set(i, objectArray[i]);
            }
            return true;
        }
        return false;
    }

    public Object get(int index) {
        return this.getValue(index);
    }

    public Object get(String columnName) {
        DataRow dataRow = this;
        return dataRow.getValue(dataRow.zzZda.getColumns().indexOf(columnName));
    }

    public Object get(DataColumn column) {
        DataRow dataRow = this;
        return dataRow.getValue(dataRow.zzZda.getColumns().indexOf(column));
    }

    public DataTable getTable() {
        return this.zzZda;
    }

    public DataRow[] getChildRows(DataRelation relation) {
        if (this.zzZda.getDataSet() == null) {
            return new DataRow[0];
        }
        if (!relation.getParentTable().getTableName().equalsIgnoreCase(this.zzZda.getTableName())) {
            return new DataRow[0];
        }
        String[] stringArray = relation.getParentColumnNames();
        String[] stringArray2 = relation.getChildColumnNames();
        if (stringArray == null || stringArray2 == null || stringArray.length != stringArray2.length) {
            return new DataRow[0];
        }
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = this.get(stringArray[i]);
        }
        DataTable dataTable = this.zzZda.getDataSet().getTables().get(relation.getChildTable().getTableName());
        ArrayList<DataRow> arrayList = new ArrayList<DataRow>();
        for (int i = 0; i < dataTable.getRows().getCount(); ++i) {
            DataRow dataRow = dataTable.getRows().get(i);
            boolean bl = false;
            for (int j = 0; j < stringArray2.length; ++j) {
                Object object = objectArray[j];
                Object object2 = dataRow.get(stringArray2[j]);
                if (object == null || !object.equals(object2)) {
                    bl = false;
                    break;
                }
                bl = true;
            }
            if (!bl) continue;
            arrayList.add(dataRow);
        }
        DataRow[] dataRowArray = new DataRow[arrayList.size()];
        return arrayList.toArray(dataRowArray);
    }

    public DataRow getParentRow(DataRelation relation) {
        if (this.zzZda.getDataSet() == null) {
            return null;
        }
        String[] stringArray = relation.getParentColumnNames();
        String[] stringArray2 = relation.getChildColumnNames();
        if (stringArray.length == 0 || stringArray2.length == 0) {
            return null;
        }
        String string = stringArray[0];
        String string2 = stringArray2[0];
        Object object = this.get(string2);
        for (DataRow dataRow : relation.getParentTable().getRows()) {
            Object object2 = dataRow.get(string);
            if (object == null && object2 == null) {
                return dataRow;
            }
            if (!object.equals(object2)) continue;
            return dataRow;
        }
        return null;
    }

    public DataRow[] getParentRows(DataRelation relation) {
        if (this.zzZda.getDataSet() == null) {
            return new DataRow[0];
        }
        String[] stringArray = relation.getParentColumnNames();
        String[] stringArray2 = relation.getChildColumnNames();
        if (stringArray.length == 0 || stringArray2.length == 0) {
            return new DataRow[0];
        }
        ArrayList<DataRow> arrayList = new ArrayList<DataRow>();
        for (DataRow dataRow : relation.getParentTable().getRows()) {
            arrayList.add(dataRow);
        }
        DataRow[] dataRowArray = new DataRow[arrayList.size()];
        return arrayList.toArray(dataRowArray);
    }

    public void set(int columnIndex, Object value) {
        this.zzWho(columnIndex, value);
        this.zzZda.onDataRowChanged(this);
    }

    public void set(String columnName, Object value) {
        DataRow dataRow = this;
        dataRow.set(dataRow.zzZda.getColumns().indexOf(columnName), value);
    }

    public void set(DataColumn column, Object value) {
        this.set(column.getColumnName(), value);
    }

    public int getRowState() {
        return this.zzWOe;
    }

    public void setRowState(int state) {
        this.zzWOe = state;
    }

    public void delete() {
        zzVV9.zzY5s(this.getTable(), this);
    }

    public void setOriginalValue(String columnName, Object data) {
        this.zzYmg.put(columnName, data);
    }

    public Object getOriginalValue(String columnName) {
        if (columnName == null) {
            return null;
        }
        return this.zzYmg.get(columnName);
    }

    public Object[] getItemArray() {
        Object[] objectArray = new Object[this.zzWef.length];
        System.arraycopy(this.zzWef, 0, objectArray, 0, this.zzWef.length);
        return objectArray;
    }

    public void setItemArray(Object[] array) {
        if (array == null) {
            return;
        }
        if (array.length != this.zzWef.length) {
            throw new IllegalArgumentException("The array must have the same size (" + this.zzWef.length + ") and ordering as the column collection.");
        }
        for (int i = 0; i < array.length; ++i) {
            this.zzWho(i, array[i]);
        }
        this.zzZda.onDataRowChanged(this);
    }

    final int zzYgI() {
        return this.zzXbO;
    }

    final void zzY69(String string, String string2) {
        this.zzXc3.put(string, string2);
    }

    final void zzZeK(String string, String string2) {
        this.zzWos = zzXfq.zzY5s(string, string2);
    }

    final String zzYCK() {
        return this.zzWos;
    }

    final void zzZUH(int n) {
        this.zzXbO = n;
    }

    final Object[] zzIT() {
        return this.zzWef;
    }

    static boolean zzXSC(DataColumn[] dataColumnArray) {
        int n;
        for (n = 0; n < dataColumnArray.length; ++n) {
            DataColumn dataColumn = dataColumnArray[n];
            if (dataColumn != null || dataColumn != DBNull.Value) continue;
            return true;
        }
        return n == dataColumnArray.length;
    }

    private Object getValue(int index) {
        if (!this.zz9Q(index)) {
            return null;
        }
        return this.zzWef[index];
    }

    private void zzWho(int n, Object object) {
        if (!this.zz9Q(n)) {
            return;
        }
        Class clazz = this.getTable().getColumns().get(n).getDataType();
        Object object2 = object == null ? (clazz == String.class ? "" : null) : (object instanceof DBNull ? object : (object instanceof Clob ? DataRow.zzXSC((Clob)object) : (object instanceof Blob ? (Object)DataRow.zzXSC((Blob)object) : (clazz.isAssignableFrom(object.getClass()) ? object : DataRow.zzXSC(clazz, object)))));
        this.zzWef[n] = object2;
    }

    private static Object zzXSC(Class clazz, Object object) {
        if (object == null) {
            return null;
        }
        String string = object.toString().trim();
        if (string.isEmpty()) {
            return object;
        }
        if (clazz == String.class) {
            return string;
        }
        try {
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                return (byte)Integer.parseInt(string);
            }
            if (clazz == Short.TYPE || clazz == Short.class) {
                return (short)Integer.parseInt(string);
            }
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                return (int)Long.parseLong(string);
            }
            if (clazz == Long.TYPE || clazz == Long.class) {
                return Long.parseLong(string);
            }
            if (clazz == Float.TYPE || clazz == Float.class) {
                return Float.valueOf(Float.parseFloat(string));
            }
            if (clazz == Double.TYPE || clazz == Double.class) {
                return Double.parseDouble(string);
            }
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                return Boolean.parseBoolean(string);
            }
            if (clazz == Character.TYPE || clazz == Character.class) {
                return Character.valueOf(string.charAt(0));
            }
            if (clazz == Date.class || clazz == zzLJ.class) {
                return zzLJ.zzXSC(string, zzZfg.zzYNk(), 128).zzXB7();
            }
            if (clazz == BigDecimal.class) {
                return new BigDecimal(string).doubleValue();
            }
        }
        catch (Exception exception) {}
        return object;
    }

    private boolean zz9Q(int n) {
        this.zzYmB();
        return this.zzWef != null && n >= 0 && n < this.zzWef.length;
    }

    public void remove(int index) {
        int n = this.zzZda.getColumns().getCount();
        if (this.zzWef.length == n) {
            return;
        }
        Object[] objectArray = new Object[this.zzWef.length - index];
        System.arraycopy(this.zzWef, index, objectArray, 0, this.zzWef.length - index);
        System.arraycopy(objectArray, 1, this.zzWef, index, objectArray.length - 1);
    }

    private void zzYmB() {
        if (this.zzZda == null || this.zzZda.getColumns() == null || this.zzWef == null) {
            return;
        }
        int n = this.zzZda.getColumns().getCount();
        if (this.zzWef.length == n) {
            return;
        }
        Object[] objectArray = new Object[this.zzWef.length];
        System.arraycopy(this.zzWef, 0, objectArray, 0, this.zzWef.length);
        this.zzWef = new Object[n];
        System.arraycopy(objectArray, 0, this.zzWef, 0, Math.min(objectArray.length, this.zzWef.length));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] zzXSC(Blob blob) {
        byte[] byArray = null;
        InputStream inputStream = null;
        try {
            if (blob == null) return null;
            if (blob.length() == 0L) {
                return null;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            inputStream = blob.getBinaryStream();
            zzZDw.zzXSC(inputStream, (OutputStream)byteArrayOutputStream);
            byArray = byteArrayOutputStream.toByteArray();
            if (inputStream == null) return byArray;
        }
        catch (Exception exception) {
            if (inputStream == null) return byArray;
            try {
                inputStream.close();
                return byArray;
            }
            catch (IOException iOException) {
                return byArray;
            }
        }
        catch (Throwable throwable) {
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            return byArray;
        }
    }

    private static String zzXSC(Clob clob) {
        StringBuilder stringBuilder;
        block6: {
            stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = null;
            try {
                int n;
                if (clob == null || clob.length() == 0L) {
                    return stringBuilder.toString();
                }
                bufferedReader = new BufferedReader(clob.getCharacterStream());
                char[] cArray = new char[8192];
                while ((n = bufferedReader.read(cArray, 0, 8192)) > 0) {
                    stringBuilder.append(cArray, 0, n);
                }
            }
            catch (Exception exception) {
                if (bufferedReader == null) break block6;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getTable().getTableName());
        stringBuilder.append(": ");
        DataRow dataRow = this;
        Object[] objectArray = dataRow.zzWef;
        int n = dataRow.zzWef.length;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            stringBuilder.append(object).append("; ");
        }
        return stringBuilder.toString();
    }
}

