/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zz6A;
import com.aspose.words.net.System.Data.zzXl6;
import com.aspose.words.net.System.Data.zzY5s;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzZ8W;
    private final DataColumnCollection zzXFY;
    private final ConstraintCollection zzX66;
    private final zz6A zzW2a;
    private ResultSet zz1s;
    private String zzk2;
    private DataSet zzY7b;
    private String zzZmm;
    private UniqueConstraint zzXlN;
    private boolean zzZIv;
    private final List<DataTableEventListener> zzXkn;
    private final Set<DataRow> zzXmZ;

    public DataTable() {
        this.zzZ8W = new DataRowCollection(this);
        this.zzXFY = new DataColumnCollection(this);
        this.zzX66 = new ConstraintCollection(this);
        this.zzW2a = new zz6A(this);
        this.zzZmm = "";
        this.zzZIv = true;
        this.zzXkn = new ArrayList<DataTableEventListener>();
        this.zzXmZ = new HashSet<DataRow>();
    }

    public DataTable(String tableName) {
        this.zzZ8W = new DataRowCollection(this);
        this.zzXFY = new DataColumnCollection(this);
        this.zzX66 = new ConstraintCollection(this);
        this.zzW2a = new zz6A(this);
        this.zzZmm = "";
        this.zzZIv = true;
        this.zzXkn = new ArrayList<DataTableEventListener>();
        this.zzXmZ = new HashSet<DataRow>();
        this.zzk2 = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzY5s.zzXSC(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzZ8W = new DataRowCollection(this);
        this.zzXFY = new DataColumnCollection(this);
        this.zzX66 = new ConstraintCollection(this);
        this.zzW2a = new zz6A(this);
        this.zzZmm = "";
        this.zzZIv = true;
        this.zzXkn = new ArrayList<DataTableEventListener>();
        this.zzXmZ = new HashSet<DataRow>();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zz1s = resultSet;
        this.zzk2 = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zz1s != null) {
            if (this.zz1s.getStatement() != null) {
                this.zz1s.getStatement().getConnection().close();
            }
            this.zz1s = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzk2;
    }

    public void setTableName(String tableName) {
        this.zzk2 = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzXFY.getCount();
    }

    public String getColumnName(int index) {
        return this.zzXFY.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zz1s;
    }

    public DataSet getDataSet() {
        return this.zzY7b;
    }

    final void zzY5s(DataSet dataSet) {
        this.zzY7b = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzY7b.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzY7b.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzZ8W;
    }

    public DataColumnCollection getColumns() {
        return this.zzXFY;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzX66;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzXlN == null) {
            return new DataColumn[0];
        }
        return this.zzXlN.getColumns();
    }

    final void zz6A(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzXlN != null) {
                this.zzXlN.zzx7(false);
                this.getConstraints().remove(this.zzXlN);
                this.zzXlN = null;
            }
            return;
        }
        if (this.zzXlN != null && DataColumn.areColumnSetsTheSame(value, this.zzXlN.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzXSC(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzXlN != null) {
            this.zzXlN.zzx7(false);
            this.getConstraints().remove(this.zzXlN);
            this.zzXlN = null;
        }
        UniqueConstraint.zzXSC(this.getConstraints(), uniqueConstraint);
        this.zzXlN = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzZmm;
    }

    public void setNamespace(String namespace) {
        this.zzZmm = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzZIv;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzZIv = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzXmZ.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzY5s.zzXSC(this.getResultSet(), this);
            zzY5s.zzY5s(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            sQLException.printStackTrace();
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzY5s.zzXl6(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzXkn.contains(listener)) {
            this.zzXkn.add(listener);
        }
    }

    public void removeEventListener(zzXl6 listener) {
        if (this.zzXkn.contains(listener)) {
            this.zzXkn.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzXkn.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzXmZ.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXkn) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzXmZ.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXkn) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzXmZ.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXkn) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzXkn) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzXkn) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zz6A zzXVr() {
        return this.zzW2a;
    }

    final Set<DataRow> zzXA4() {
        return this.zzXmZ;
    }
}

