/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.ref.Ref;
import com.aspose.words.zzX;
import com.aspose.words.zzZF0;
import com.aspose.words.zzZFI;
import com.aspose.words.zzZP3;
import com.aspose.words.zzZP4;
import com.aspose.words.zzZPI;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzZP3,
Iterable<T> {
    private Node zzZRn;
    private Node zzZRm;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        while (this.hasChildNodes()) {
            this.getParentNode().insertAfter(this.getLastChild(), this);
        }
        this.remove();
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzr9() {
        return this.zzr6() != null;
    }

    final boolean zzr8() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzr7() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof zzZPI)) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        return this.zzZRn;
    }

    public Node getLastChild() {
        return this.zzZRm;
    }

    final Node zzr6() {
        return zzX.zzX(this.getFirstChild(), false);
    }

    final Node zzr5() {
        return zzX.zzW(this.getLastChild(), false);
    }

    final CompositeNode zzr4() {
        return (CompositeNode)zzX.zzX(this.getFirstChild(), true);
    }

    final CompositeNode zzr3() {
        return (CompositeNode)zzX.zzW(this.getLastChild(), true);
    }

    final Node zzr2() {
        Node node;
        for (node = this.getFirstChild(); node != null && zzX.zzN(node); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzr1() {
        Node node;
        for (node = this.getLastChild(); node != null && zzX.zzN(node); node = node.getPreviousSibling()) {
        }
        return node;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzZ(boolean bl, zzZP4 zzZP42) {
        CompositeNode compositeNode = (CompositeNode)super.zzZ(bl, zzZP42);
        ((CompositeNode)super.zzZ(bl, zzZP42)).zzZRm = null;
        compositeNode.zzZRn = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zza(node.zzZ(true, zzZP42));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzV(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzV(StringBuilder stringBuilder) {
        this.zzU(stringBuilder);
        com.aspose.words.internal.zzX.zzY(stringBuilder, this.zzr0());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzX.zzTL(nodeType);
            Node node2 = node = bl ? this.zzr6() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzZzc() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzX.zzZ((Node)this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzX.zzY((Node)this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzZFI(this);
    }

    public Node appendChild(Node newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) {
        return this.zzZ(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.zzZ(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        if (oldChild == null) {
            throw new NullPointerException("oldChild");
        }
        if (oldChild.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzZ(oldChild, this, null, 1);
        if (documentBase.zz4j() && zzX.zzv(oldChild)) {
            return oldChild;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzZ(nodeChangingArgs);
        }
        Node node = this.zz9(oldChild);
        if (nodeChangingArgs != null) {
            documentBase.zzY(nodeChangingArgs);
        }
        return node;
    }

    public void removeAllChildren() {
        zzZF0.zzv(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zza(Node node) {
        node.getParentNode();
        if (this.zzZRm == null) {
            node.zzZ6(null);
            node.zzZ7(null);
            this.zzZRn = node;
        } else {
            node.zzZ6(this.zzZRm);
            node.zzZ7(null);
            this.zzZRm.zzZ7(node);
        }
        this.zzZRm = node;
        node.zzZ5(this);
        return node;
    }

    final void zzZ(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            this.insertBefore(node4, node3);
            node4 = node5;
        }
    }

    final void zzY(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzS(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (zzX.zzN(node2)) continue;
            if (zzX.zzY(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzr0().length();
    }

    String zzr0() {
        return "";
    }

    final String zzqZ() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzU(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzU(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzV(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzZ(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zzY(visitor));
    }

    abstract int zzZ(DocumentVisitor var1) throws Exception;

    abstract int zzY(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzg(Node var1);

    final Node zzZ(Node node, Node node2, boolean bl) {
        NodeChangingArgs nodeChangingArgs;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzZ4(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 35 && !this.zzg(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        if (node.getParentNode() != null) {
            node.getParentNode().removeChild(node);
            if (!node.isRemoved()) {
                node.getParentNode().zz9(node);
            }
        }
        if ((nodeChangingArgs = documentBase.zzZ(node, null, this, 0)) != null) {
            documentBase.zzZ(nodeChangingArgs);
        }
        if (this.zzZRm == null) {
            node.zzZ6(null);
            node.zzZ7(null);
            this.zzZRn = node;
            this.zzZRm = node;
        } else if (bl) {
            if (node2 != null) {
                this.zzV(node, node2);
            } else {
                this.zzU(node, this.zzZRn);
            }
        } else if (node2 != null) {
            this.zzU(node, node2);
        } else {
            this.zzV(node, this.zzZRm);
        }
        node.zzZ5(this);
        if (nodeChangingArgs != null) {
            documentBase.zzY(nodeChangingArgs);
        }
        if (documentBase.zz4j()) {
            zzX.zzw(node);
        }
        return node;
    }

    private void zzV(Node node, Node node2) {
        Node node3 = node2.zzZz6();
        node.zzZ6(node2);
        node.zzZ7(node3);
        node2.zzZ7(node);
        if (node3 == null) {
            this.zzZRm = node;
            return;
        }
        node3.zzZ6(node);
    }

    private void zzU(Node node, Node node2) {
        Node node3 = node2.zzZz5();
        node.zzZ6(node3);
        node.zzZ7(node2);
        node2.zzZ6(node);
        if (node3 == null) {
            this.zzZRn = node;
            return;
        }
        node3.zzZ7(node);
    }

    private Node zz9(Node node) {
        if (node == this.zzZRn) {
            if (this.zzZRn == this.zzZRm) {
                this.zzZRn = null;
                this.zzZRm = null;
            } else {
                this.zzZRn = node.zzZz6();
                this.zzZRn.zzZ6(null);
            }
        } else {
            Node node2 = node.zzZz5();
            Node node3 = node.zzZz6();
            node2.zzZ7(node3);
            if (node3 == null) {
                this.zzZRm = node2;
            } else {
                node3.zzZ6(node2);
            }
        }
        node.zzZ7(null);
        node.zzZ6(null);
        node.zzZ5(null);
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Ref<Node> curNode) {
        Node node = curNode.get();
        curNode.set(curNode.get() == this ? this.getFirstChild() : curNode.get().getNextSibling());
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

