/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.BorderCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.ImageSize;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ShapeBase;
import com.aspose.words.internal.zz6R;
import com.aspose.words.internal.zz6T;
import com.aspose.words.internal.zz6U;
import com.aspose.words.internal.zz84;
import com.aspose.words.internal.zzNE;
import com.aspose.words.internal.zzTS;
import com.aspose.words.internal.zzU;
import com.aspose.words.internal.zzX;
import com.aspose.words.internal.zzYC;
import com.aspose.words.zzYXX;
import com.aspose.words.zzZNR;
import com.aspose.words.zzZNS;
import com.aspose.words.zzZO8;
import com.aspose.words.zzZRQ;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.OutputStream;

public class ImageData
implements zzZRQ {
    private ShapeBase zzYTW;
    private BorderCollection zzYTV;
    private static zz84<Integer, Integer> zzYTU = new zz84<Integer, Integer>();
    private zzZNS zzYTT;

    ImageData(ShapeBase parent, Document doc) {
        this.zzYTW = parent;
        this.zzYTT = parent.getMarkupLanguage() == 1 ? new zzZNS(doc, new zzZNR(parent), new zzZO8()) : new zzZNS(doc, new com.aspose.words.zz6U(parent), new zzZO8());
    }

    public void setImage(BufferedImage image) throws Exception {
        BufferedImage bufferedImage = image;
        zzZNS zzZNS2 = this.zzYTT;
        if (bufferedImage == null) {
            throw new NullPointerException("image");
        }
        zz6T zz6T2 = new zz6T();
        try {
            zzYC.zzZ(bufferedImage, zz6T2);
            zzZNS2.zz0(zz6T2);
            return;
        }
        finally {
            zz6T2.close();
        }
    }

    public void setImage(InputStream stream) throws Exception {
        this.zz0(zzU.zzZ(stream));
    }

    final void zz0(zz6R zz6R2) throws Exception {
        this.zzYTT.zz0(zz6R2);
    }

    public void setImage(String fileName) throws Exception {
        this.zzYTT.setImage(fileName);
    }

    public BufferedImage toImage() throws Exception {
        zzZNS zzZNS2 = this.zzYTT;
        return zzYC.zzT(zzZNS2.zzZKM());
    }

    public InputStream toStream() throws Exception {
        ImageData imageData = this;
        return zz6R.zzf(imageData.zzYTT.zzZKM());
    }

    public byte[] toByteArray() throws Exception {
        return this.zzYTT.toByteArray();
    }

    public void save(OutputStream stream) throws Exception {
        zz6T zz6T2;
        zz6T zz6T3 = zz6T2 = new zz6T();
        ImageData imageData = this;
        imageData.zzYTT.zzP(zz6T3);
        zz6T2.zzu(0L);
        zzU.zzZ(zz6T2, stream);
    }

    public void save(String fileName) throws Exception {
        String string = fileName;
        zzZNS zzZNS2 = this.zzYTT;
        zzX.zzZ(string, "fileName");
        zz6U zz6U2 = zzX.zzU(string);
        try {
            zzZNS2.zzP(zz6U2);
            return;
        }
        finally {
            ((zz6R)zz6U2).close();
        }
    }

    public byte[] getImageBytes() throws Exception {
        return this.zzYTT.getImageBytes();
    }

    public void setImageBytes(byte[] value) throws Exception {
        this.zzYTT.setImageBytes(value);
    }

    public boolean hasImage() throws Exception {
        zzZNS zzZNS2 = this.zzYTT;
        return zzZNS2.zzZKO() || zzZNS2.isLink();
    }

    public ImageSize getImageSize() throws Exception {
        return this.zzYTT.getImageSize();
    }

    public int getImageType() throws Exception {
        zzZNS zzZNS2 = this.zzYTT;
        return FileFormatUtil.zzKz(zzZNS2.zzZKN());
    }

    final boolean zzZd(byte[] byArray) throws Exception {
        return this.zzYTT.zzZd(byArray);
    }

    public boolean isLink() throws Exception {
        return this.zzYTT.isLink();
    }

    public boolean isLinkOnly() throws Exception {
        zzZNS zzZNS2 = this.zzYTT;
        return zzZNS2.isLink() && !zzZNS2.zzZKO();
    }

    public String getSourceFullName() throws Exception {
        return this.zzYTT.getSourceFullName();
    }

    public void setSourceFullName(String value) throws Exception {
        this.zzYTT.setSourceFullName(value);
    }

    public String getTitle() {
        return (String)this.zzTz(4103);
    }

    public void setTitle(String value) {
        zzX.zzZ((Object)value, "value");
        this.zzT(4103, value);
    }

    public double getCropTop() {
        return this.zzYTW.zzZgB().getCropTop();
    }

    public void setCropTop(double value) {
        this.zzYTW.zzZgB().setCropTop(value);
    }

    public double getCropBottom() {
        return this.zzYTW.zzZgB().getCropBottom();
    }

    public void setCropBottom(double value) {
        this.zzYTW.zzZgB().setCropBottom(value);
    }

    public double getCropLeft() {
        return this.zzYTW.zzZgB().getCropLeft();
    }

    public void setCropLeft(double value) {
        this.zzYTW.zzZgB().setCropLeft(value);
    }

    public double getCropRight() {
        return this.zzYTW.zzZgB().getCropRight();
    }

    public void setCropRight(double value) {
        this.zzYTW.zzZgB().setCropRight(value);
    }

    final zzNE zzZH() {
        return new zzNE(this.getCropLeft(), this.getCropRight(), this.getCropTop(), this.getCropBottom());
    }

    public BorderCollection getBorders() {
        if (this.zzYTV == null) {
            this.zzYTV = new BorderCollection(this);
        }
        return this.zzYTV;
    }

    public Color getChromaKey() {
        return this.zzZKR().zzUo();
    }

    public void setChromaKey(Color value) {
        zzTS zzTS2 = zzTS.zzZ(value);
        ImageData imageData = this;
        imageData.zzT(263, zzTS2);
    }

    final zzTS zzZKR() {
        return (zzTS)this.zzTz(263);
    }

    public double getBrightness() {
        return this.zzYTW.zzZgB().getBrightness();
    }

    public void setBrightness(double value) {
        if (value < 0.0 || value > 1.0) {
            throw new IllegalArgumentException("Parameter name: value");
        }
        this.zzYTW.zzZgB().setBrightness(value);
    }

    public double getContrast() {
        return this.zzYTW.zzZgB().getContrast();
    }

    public void setContrast(double value) {
        if (value < 0.0 || value > 1.0) {
            throw new IllegalArgumentException("Parameter name: value");
        }
        this.zzYTW.zzZgB().setContrast(value);
    }

    public boolean getBiLevel() {
        return this.zzYTW.zzZgB().getBiLevel();
    }

    public void setBiLevel(boolean value) {
        this.zzYTW.zzZgB().setBiLevel(value);
    }

    public boolean getGrayScale() {
        return this.zzYTW.zzZgB().getGrayScale();
    }

    public void setGrayScale(boolean value) {
        this.zzYTW.zzZgB().setGrayScale(value);
    }

    static double zzYi(double d) {
        if (d < -0.5 || d > 0.5) {
            throw new IllegalArgumentException("Parameter name: escherBrightness");
        }
        return d + 0.5;
    }

    static double zzYh(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Parameter name: percent");
        }
        return d - 0.5;
    }

    static double zzYg(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Parameter name: escherContrast");
        }
        if (d <= 1.0) {
            return d / 2.0;
        }
        return (d - 0.5) / d;
    }

    static double zzYf(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Parameter name: percent");
        }
        if (d <= 0.5) {
            return d * 2.0;
        }
        if (d < 1.0) {
            return 0.5 / (1.0 - d);
        }
        return Double.MAX_VALUE;
    }

    final byte[] zzZKQ() throws Exception {
        return this.zzYTT.zzZKQ();
    }

    final boolean zzZY(byte[] byArray) throws Exception {
        return this.zzYTT.zzZY(byArray);
    }

    final byte[] zzZ(byte[] byArray, zzYXX zzYXX2) throws Exception {
        return this.zzYTT.zzZ(byArray, zzYXX2);
    }

    final boolean zzZKP() {
        return this.zzYTW.getDirectShapeAttr(263) != null;
    }

    final boolean zzZKO() throws Exception {
        return this.getImageBytes() != null && this.getImageBytes().length > 0;
    }

    final int zzZKN() throws Exception {
        return this.zzYTT.zzZKN();
    }

    private Object zzTz(int n) {
        return this.zzYTW.fetchShapeAttr(n);
    }

    private void zzT(int n, Object object) {
        this.zzYTW.setShapeAttr(n, object);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectBorderAttr(int key) {
        return this.zzYTW.getDirectShapeAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedBorderAttr(int key) {
        return this.zzYTW.fetchInheritedShapeAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setBorderAttr(int key, Object value) {
        this.zzT(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zz84<Integer, Integer> getPossibleBorderKeys() {
        return zzYTU;
    }

    static {
        zzYTU.zzO(3, 4106);
        zzYTU.zzO(1, 4107);
        zzYTU.zzO(0, 4108);
        zzYTU.zzO(2, 4109);
    }
}

