/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.Font;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.List;
import com.aspose.words.ListLevel;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.Row;
import com.aspose.words.Run;
import com.aspose.words.Style;
import com.aspose.words.TableStyle;
import com.aspose.words.Theme;
import com.aspose.words.internal.zz27;
import com.aspose.words.internal.zz6R;
import com.aspose.words.internal.zzB7;
import com.aspose.words.internal.zzBO;
import com.aspose.words.internal.zzC1;
import com.aspose.words.internal.zzC3;
import com.aspose.words.internal.zzMN;
import com.aspose.words.internal.zzZF;
import com.aspose.words.zz6;
import com.aspose.words.zzX;
import com.aspose.words.zzYU0;
import com.aspose.words.zzYU3;
import com.aspose.words.zzYVQ;
import com.aspose.words.zzZ09;
import com.aspose.words.zzZ74;
import com.aspose.words.zzZMS;
import com.aspose.words.zzZNH;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class StyleCollection
implements Cloneable,
Iterable<Style> {
    private DocumentBase zzZZZ;
    private zzZ09 zzY0Z = new zzZ09();
    private zzZ74 zzY0Y = new zzZ74();
    private zzC3<Style> zzY0X = new zzC3();
    private zzC1<Style> zzY0W = new zzC1();
    private zzC3<Style> zzY0V = new zzC3();
    private zzZMS zzY0U = new zzZMS();
    private static Document zzY0T;
    private static Object zzY0S;
    private static Document zzY0R;
    private static Object zzY0Q;
    private static Document zzY0P;
    private static Object zzY0O;
    private Font zzY0N;
    private ParagraphFormat zzY0M;
    private HashMap<Style, String> zzY0L;

    StyleCollection(DocumentBase doc) {
        this.zzZZZ = doc;
    }

    public DocumentBase getDocument() {
        return this.zzZZZ;
    }

    public Font getDefaultFont() {
        if (this.zzY0N == null) {
            StyleCollection styleCollection = this;
            this.zzY0N = new Font(styleCollection.zzY0Z, this.zzZZZ);
        }
        return this.zzY0N;
    }

    public ParagraphFormat getDefaultParagraphFormat() {
        if (this.zzY0M == null) {
            StyleCollection styleCollection = this;
            this.zzY0M = new ParagraphFormat(styleCollection.zzY0Y, this);
        }
        return this.zzY0M;
    }

    public int getCount() {
        return this.zzY0X.getCount();
    }

    public Style get(String name) {
        return this.zzb(name, true);
    }

    public Style getByStyleIdentifier(int sti) {
        return this.zzZv(sti, true);
    }

    public Style get(int index) {
        return this.zzY0X.zzX2(index);
    }

    final zzZ09 zzZco() {
        return this.zzY0Z;
    }

    final zzZ74 zzZcn() {
        return this.zzY0Y;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StyleCollection zzZcm() {
        if (zzY0T == null) {
            Object object = zzY0S;
            synchronized (object) {
                if (zzY0T == null) {
                    zzY0T = StyleCollection.zzJH("Aspose.Words.Resources.AllStyles2003.docx");
                }
            }
        }
        return zzY0T.getStyles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StyleCollection zzZcl() {
        if (zzY0R == null) {
            Object object = zzY0Q;
            synchronized (object) {
                if (zzY0R == null) {
                    zzY0R = StyleCollection.zzJH("Aspose.Words.Resources.AllStyles2007.docx");
                }
            }
        }
        return zzY0R.getStyles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StyleCollection zzZck() {
        if (zzY0P == null) {
            Object object = zzY0O;
            synchronized (object) {
                if (zzY0P == null) {
                    zzY0P = StyleCollection.zzJH("Aspose.Words.Resources.AllStyles2013.docx");
                }
            }
        }
        return zzY0P.getStyles();
    }

    final StyleCollection zzZcj() {
        Document document = this.getDocument().getNodeType() == 1 ? (Document)this.getDocument() : ((GlossaryDocument)this.getDocument()).zz5p();
        int n = document.getCompatibilityOptions().getMswVersion();
        if (n != 0) {
            switch (n) {
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    return StyleCollection.zzZcm();
                }
                case 12: 
                case 14: {
                    return StyleCollection.zzZcl();
                }
                case 15: 
                case 16: {
                    return StyleCollection.zzZck();
                }
            }
        }
        StyleCollection styleCollection = this;
        int n2 = styleCollection.zzZZZ.getNodeType() == 29 ? 20 : ((Document)styleCollection.zzZZZ).getOriginalLoadFormat();
        switch (n2) {
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return StyleCollection.zzZcl();
            }
        }
        return StyleCollection.zzZcm();
    }

    private static Document zzJH(String string) {
        Document document;
        block6: {
            String string2 = string;
            zz6R zz6R2 = zzB7.zzY(string2, Document.class);
            try {
                Document document2 = new Document(zz6R2);
                document2.getStyles().zzZce();
                document = document2;
                if (zz6R2 == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (zz6R2 != null) {
                        zz6R2.close();
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new IllegalStateException("Cannot load built in styles from an embedded resource.", exception);
                }
            }
            zz6R2.close();
        }
        return document;
    }

    final zzZMS zzZm0() {
        return this.zzY0U;
    }

    private boolean zzZci() {
        return this.getDocument() == zzY0T || this.getDocument() == zzY0R || this.getDocument() == zzY0P;
    }

    final int zzZch() {
        StyleCollection styleCollection = this;
        int n = Math.max(styleCollection.zzY0X.getCount() > 0 ? styleCollection.zzY0X.zzVn(styleCollection.zzY0X.getCount() - 1) : -1, 14) + 1;
        if (n >= 4095) {
            throw new IllegalStateException("There are too many styles in the document.");
        }
        return n;
    }

    @Override
    public Iterator<Style> iterator() {
        ArrayList arrayList = new ArrayList();
        for (Map.Entry entry : this.zzY0W) {
            String string = (String)entry.getKey();
            Style style = (Style)entry.getValue();
            if (!zz27.equals(style.getName(), string)) continue;
            com.aspose.words.internal.zzX.zzZ(arrayList, style);
        }
        return arrayList.iterator();
    }

    public Style add(int type, String name) {
        if (type == 3) {
            throw new IllegalArgumentException("Cannot create table styles.\r\nParameter name: type");
        }
        com.aspose.words.internal.zzX.zzZ(name, "name");
        Style style = Style.zzY(type, this.zzZch(), 4094, name);
        if (type == 4) {
            List list = zzX.zzZ(this.getDocument().getLists(), 6);
            list.zzZGn().zzHN(style.zzZSf());
            style.zzZQH().zzI5(list.getListId());
        }
        this.zzH(style);
        return style;
    }

    final void remove(String styleName) {
        while (true) {
            Style style;
            if ((style = this.zzb(styleName, false)) == null) {
                throw new IllegalArgumentException("Style not found.");
            }
            for (Style style2 : this) {
                if (style2.zzZcH() == style.zzZSf()) {
                    Style style3 = style;
                    Style style4 = style2;
                    switch (style3.getType()) {
                        case 2: {
                            style4.zzR(style4.zzzg(0));
                            break;
                        }
                        case 1: {
                            style4.zzR(style4.zzzg(0));
                            style4.zzV(style4.zzD2(1));
                            break;
                        }
                        case 3: {
                            TableStyle tableStyle = (TableStyle)style4;
                            tableStyle.zzM(tableStyle.zzZ8O());
                            tableStyle.zzY(tableStyle.zzvT());
                            tableStyle.zzQ(tableStyle.zzZ8P());
                            style4.zzR(style4.zzzg(0));
                            style4.zzV(style4.zzD2(1));
                            break;
                        }
                        case 4: {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unexpected style type.");
                        }
                    }
                    style2.zzzl(StyleCollection.zzzf(style2.getType()));
                    if (style2.getType() != 1 || style2.zzZcG() != style.zzZSf()) continue;
                    style2.zzzk(style2.zzZSf());
                    continue;
                }
                if (style2.getType() != 1 || style2.zzZcG() != style.zzZSf()) continue;
                style2.zzzk(0);
            }
            this.zzX(style, style.zzZSf(), -1);
            if (style.hasRevisions() && style.getDocument() instanceof Document) {
                ((Document)style.getDocument()).getRevisions().zzR(style);
            }
            this.zzJ(style);
            Style style5 = style.getLinkedStyle();
            if (style5 == null) break;
            style5.zzzj(4095);
            styleName = style5.getName();
        }
    }

    final void zzJ(Style style) {
        if (this.zzZcj().zzb(style.getName(), false) != null) {
            this.zzY0V.remove(style.getStyleIdentifier());
        }
        this.zzY0X.remove(style.zzZSf());
        this.zzI(style);
        this.zzY0L = null;
    }

    final void zzW(StyleCollection styleCollection) {
        StyleCollection styleCollection2 = styleCollection;
        this.zzY0Z = (zzZ09)styleCollection2.zzY0Z.zzy3();
        styleCollection2 = styleCollection;
        this.zzY0Y = (zzZ74)styleCollection2.zzY0Y.zzy3();
        zzZNH zzZNH2 = new zzZNH(styleCollection, this);
        StyleCollection styleCollection3 = styleCollection;
        StyleCollection styleCollection4 = this;
        for (Style style : styleCollection3) {
            styleCollection4.zzZ(style, zzZNH2);
        }
    }

    private void zzI(Style style) {
        for (int i = this.zzY0W.getCount() - 1; i >= 0; --i) {
            if (this.zzY0W.zzX2(i) != style) continue;
            this.zzY0W.removeAt(i);
        }
    }

    private static int zzzf(int n) {
        switch (n) {
            case 2: {
                return 10;
            }
            case 1: {
                return 0;
            }
            case 3: {
                return 11;
            }
        }
        return 4095;
    }

    private static void zzZ(zzZ09 zzZ092, int n, int n2) {
        if (zzZ092.zzZSf() == n) {
            if (n2 == -1) {
                zzZ092.remove(50);
                return;
            }
            zzZ092.set(50, n2);
        }
    }

    final void zzH(Style style) {
        if (style == null) {
            throw new NullPointerException("style");
        }
        if (style.getStyles() != null) {
            throw new IllegalArgumentException("Style already belongs to another collection of styles.");
        }
        if (this.zzY0W.containsKey(style.getName())) {
            throw new IllegalArgumentException("Cannot add a style because a style with the same name already exists.");
        }
        if (style.getBuiltIn() && this.zzY0V.contains(style.getStyleIdentifier())) {
            throw new IllegalArgumentException("Cannot add a style because a style with this identifier already exists.");
        }
        this.zzY0X.add(style.zzZSf(), style);
        this.zzY0W.zzO(style.getName(), style);
        if (style.getBuiltIn()) {
            this.zzY0V.add(style.getStyleIdentifier(), style);
        }
        style.zzX(this);
        this.zzY0L = null;
    }

    final void zzZ(Style style, String string, String string2) {
        this.zzY0W.remove(string);
        if (!this.zzY0W.containsKey(string2)) {
            this.zzY0W.zzO(string2, style);
        } else {
            Style style2 = (Style)this.zzY0W.get(string2);
            this.zzY0W.set(string2, style);
            if (style2 != style && zz27.equals(style2.getName(), string2)) {
                this.zzI(style2);
            }
        }
        this.zzY0L = null;
    }

    final void zzZ(Style style, int n, int n2) {
        if (style.getBuiltIn()) {
            this.zzY0V.remove(n);
        }
        if (n2 != 4094) {
            if (this.zzY0V.contains(n2)) {
                this.zzY0V.set(n2, style);
                return;
            }
            this.zzY0V.add(n2, style);
        }
    }

    final void zzY(Style style, int n, int n2) {
        this.zzY0X.remove(n);
        if (this.zzY0X.contains(n2)) {
            this.zzY0X.set(n2, style);
        } else {
            this.zzY0X.add(n2, style);
        }
        int n3 = n2;
        int n4 = n;
        Style style2 = style;
        StyleCollection styleCollection = this;
        int n5 = n3;
        int n6 = n4;
        StyleCollection styleCollection2 = styleCollection;
        for (Style style3 : styleCollection) {
            if (style3.zzZcH() == n6) {
                style3.zzzl(n5);
            }
            if (style3.zzZcG() == n6) {
                style3.zzzk(n5);
            }
            if (style3.zzZcF() != n6) continue;
            style3.zzzj(n5);
        }
        styleCollection.zzX(style2, n4, n3);
    }

    private void zzX(Style style, int n, int n2) {
        switch (style.getType()) {
            case 2: {
                int n3 = n2;
                int n4 = n;
                StyleCollection styleCollection = this;
                for (Paragraph paragraph : styleCollection.getDocument().getChildNodes(8, true)) {
                    StyleCollection.zzZ(paragraph.zzZqv(), n4, n3);
                    for (Run run : paragraph.getRuns()) {
                        StyleCollection.zzZ(run.zzZWn(), n4, n3);
                    }
                }
                return;
            }
            case 1: {
                int n5 = n2;
                int n6 = n;
                StyleCollection styleCollection = this;
                for (Paragraph paragraph : styleCollection.getDocument().getChildNodes(8, true)) {
                    zzZ74 zzZ742 = paragraph.zzZQH();
                    if (zzZ742.zzZSf() != n6) continue;
                    if (n5 == -1) {
                        zzZ742.remove(1000);
                        continue;
                    }
                    zzZ742.set(1000, n5);
                }
                return;
            }
            case 4: {
                int n7 = n2;
                int n8 = n;
                Style style2 = style;
                StyleCollection styleCollection = this;
                for (Paragraph paragraph : styleCollection.getDocument().getChildNodes(8, true)) {
                    zzZ74 zzZ743 = paragraph.zzZQH();
                    if (zzZ743.getListId() == 0 || paragraph.getListFormat().getList().getStyle() == null || paragraph.getListFormat().getList().getStyle().zzZSf() != n8) continue;
                    if (n7 == -1) {
                        zzZ743.remove(1120);
                        zzZ743.remove(1110);
                        continue;
                    }
                    zzZ743.set(1120, style2.getList().getListId());
                }
                return;
            }
            case 3: {
                int n9 = n2;
                int n10 = n;
                StyleCollection styleCollection = this;
                for (Row row : styleCollection.getDocument().getChildNodes(6, true)) {
                    zzYU3 zzYU32 = row.zz3I();
                    if (zzYU32.zzZSf() != n10) continue;
                    if (n9 == -1) {
                        zzYU32.remove(4005);
                        continue;
                    }
                    zzYU32.set(4005, n9);
                }
                return;
            }
        }
        throw new IllegalStateException("Unknown style type.");
    }

    final void zzZ(Style style, String[] stringArray) {
        boolean bl;
        Style style2 = style;
        switch (style2.getStyleIdentifier()) {
            case 65: {
                if (style2.getType() == 2) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 0: {
                if (style2.getType() == 1) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 105: {
                if (style2.getType() == 3) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        if (!bl) {
            this.zzZv(style.getStyleIdentifier(), true);
            return;
        }
        if (this.zzY0W.containsKey(style.getName())) {
            style.zzJI(this.zzJG(style.getName()));
        }
        if (style.getBuiltIn() && this.zzY0V.contains(style.getStyleIdentifier())) {
            style.setStyleIdentifier(4094);
        }
        this.zzH(style);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.zzY0W.zzO(this.zzJG(stringArray[i]), style);
            }
            this.zzY0L = null;
        }
    }

    final String zzJG(String string) {
        String string2 = string;
        int n = 0;
        while (this.zzY0W.containsKey(string2)) {
            string2 = zz27.format("{0}_{1}", string, n);
            ++n;
        }
        return string2;
    }

    public Style addCopy(Style style) {
        if (style == null) {
            throw new IllegalArgumentException("Style can not be null.");
        }
        Style style2 = this.zzG(style);
        if (style.zzZcF() != 4095) {
            Style style3 = style.getStyles().zzZw(style.zzZcF(), false);
            if (style3 != null) {
                Style style4 = this.zzG(style3);
                style2.zzzj(style4.zzZSf());
                style4.zzzj(style2.zzZSf());
            } else {
                style2.zzzj(4095);
            }
        }
        return style2;
    }

    private Style zzG(Style style) {
        Style style2 = style.zzZcx();
        style2.zzJI(this.zzY0W.containsKey(style.getName()) ? this.zzJG(style.getName()) : style.getName());
        int n = zzYVQ.zzJq(style2.getName());
        boolean bl = false;
        if (n != 4094) {
            bl = zzYVQ.zzZ(style2, n, null, false);
        } else {
            style2.setStyleIdentifier(4094);
        }
        if (!bl) {
            style2.zzK8(this.zzZch());
        }
        style2.zzzk(zzYVQ.zzyZ(style.zzZcG()) ? style.zzZcG() : style2.zzZSf());
        style2.zzzl(zzYVQ.zzyZ(style.zzZcH()) ? style.zzZcH() : 4095);
        this.zzH(style2);
        Document document = com.aspose.words.internal.zzX.zzZ((Object)style.getDocument(), Document.class);
        if (document != null && !document.getStyles().zzZci()) {
            StyleCollection.zzZ(style, style2);
        }
        int n2 = (Integer)style.fetchParaAttr(1120);
        if (style.getType() != 2 && n2 > 0) {
            List list = style.getDocument().getLists().zzHY(n2);
            List list2 = this.getDocument().getLists().zzZ(list, false);
            style2.zzZQH().zzI5(list2.getListId());
            for (ListLevel listLevel : list2.getListLevels()) {
                if (listLevel.zzZFL() != style.zzZSf()) continue;
                listLevel.zzHJ(style2.zzZSf());
            }
        }
        if (style2.hasRevisions() && style2.getDocument() instanceof Document) {
            ((Document)style2.getDocument()).getRevisions().zzQ(style2);
        }
        return style2;
    }

    private static void zzZ(Style style, Style style2) {
        switch (style.getType()) {
            case 1: {
                StyleCollection.zzX(style, style2);
                StyleCollection.zzY(style, style2);
                return;
            }
            case 2: {
                StyleCollection.zzX(style, style2);
                return;
            }
            case 4: {
                return;
            }
            case 3: {
                TableStyle tableStyle = (TableStyle)style2;
                TableStyle tableStyle2 = (TableStyle)style;
                StyleCollection.zzX(tableStyle2, tableStyle);
                StyleCollection.zzY(tableStyle2, tableStyle);
                tableStyle.zzM(tableStyle2.zzZ8O());
                tableStyle.zzY(tableStyle2.zzvT());
                tableStyle.zzQ(tableStyle2.zzZ8P());
                TableStyle tableStyle3 = com.aspose.words.internal.zzX.zzZ((Object)tableStyle.zzZcw(), TableStyle.class);
                if (tableStyle3 != null) {
                    tableStyle.zzZ8N().zzX(tableStyle3.zzZ8O());
                    tableStyle.zzvU().zzX(tableStyle3.zzvT());
                    tableStyle.zz3I().zzX(tableStyle3.zzZ8P());
                }
                return;
            }
        }
        throw new IllegalArgumentException("Unknown style type");
    }

    private static void zzY(Style style, Style style2) {
        zzZ74 zzZ742 = style.zzD2(65);
        zzZ74 zzZ743 = style2.zzD2(193);
        zzZ742.zzX(zzZ743);
        style2.zzZQH().zzZ((zz6)zzZ742, new int[]{1000, 1120, 1580});
        style2.zzV(zzZ742);
    }

    private static void zzX(Style style, Style style2) {
        boolean bl;
        int n;
        boolean bl2;
        Theme theme;
        Theme theme2 = style.getDocument().zz4G();
        boolean bl3 = !Theme.zzZ(theme2, theme = style2.getDocument().zz4G()) && !(style.getDocument() instanceof GlossaryDocument) && !(style2.getDocument() instanceof GlossaryDocument);
        boolean bl4 = bl2 = style.getType() == 2 && style.zzZcF() != 4095;
        Style style3 = style2;
        int n2 = 33;
        if (style3.getType() != 2 || style3.zzZcF() != 4095) {
            n = 33;
        } else {
            if (!bl4) {
                n2 = 0;
            }
            n = n2;
        }
        int n3 = n;
        zzZ09 zzZ092 = style.zzzg(n3);
        if (bl3) {
            Theme.zzZ(theme2, zzZ092);
        }
        if (!(bl = style2.getType() == 2 && style2.zzZcF() == 4095 && !bl2)) {
            zzZ09 zzZ093 = style2.zzzg(n3 | 0x80);
            zzZ092.zzX(zzZ093);
        }
        style2.zzZWn().zzZ((zz6)zzZ092, new int[]{50, 40, 30});
        style2.zzR(zzZ092);
    }

    final StyleCollection zzF(DocumentBase documentBase) {
        StyleCollection styleCollection = (StyleCollection)this.memberwiseClone();
        ((StyleCollection)this.memberwiseClone()).zzZZZ = documentBase;
        styleCollection.zzY0Z = (zzZ09)this.zzY0Z.zzy3();
        styleCollection.zzY0Y = (zzZ74)this.zzY0Y.zzy3();
        styleCollection.zzY0X = new zzC3();
        styleCollection.zzY0W = new zzC1();
        styleCollection.zzY0V = new zzC3();
        for (int i = 0; i < this.zzY0X.getCount(); ++i) {
            Style object = this.zzY0X.zzX2(i);
            styleCollection.zzH(object.zzZcx());
        }
        for (Map.Entry entry : this.zzY0W) {
            Style style;
            String string = (String)entry.getKey();
            if (zz27.equals(string, (style = (Style)entry.getValue()).getName())) continue;
            Style style2 = styleCollection.zzb(style.getName(), false);
            styleCollection.zzY0W.zzO(string, style2);
        }
        styleCollection.zzY0U = this.zzY0U.zzZJP();
        styleCollection.zzY0L = null;
        styleCollection.zzY0N = null;
        styleCollection.zzY0M = null;
        return styleCollection;
    }

    final String zzY(Style style, boolean bl) {
        String string;
        if (this.zzY0L == null) {
            StyleCollection styleCollection = this;
            this.zzY0L = new HashMap(styleCollection.zzY0W.getCount());
            for (int i = 0; i < styleCollection.zzY0W.getCount(); ++i) {
                Style style2 = styleCollection.zzY0W.zzX2(i);
                String string2 = styleCollection.zzY0W.getKey(i);
                if (zz27.equals(style2.getName(), string2)) continue;
                String string3 = com.aspose.words.internal.zzX.zzZ(styleCollection.zzY0L, style2);
                styleCollection.zzY0L.put(style2, zzBO.zzB(string3, string2));
            }
        }
        if (!zzBO.zzYI(string = com.aspose.words.internal.zzX.zzZ(this.zzY0L, style))) {
            string = "";
        }
        if (bl) {
            return zzBO.zzB(style.getName(), string);
        }
        return string;
    }

    final Style zzZw(int n, boolean bl) {
        Style style;
        Style style2 = this.zzY0X.get(n);
        if (style2 == null && bl && (style = this.zzZcj().zzZw(n, false)) != null) {
            style2 = this.zzF(style);
        }
        return style2;
    }

    final Style zzb(String string, boolean bl) {
        com.aspose.words.internal.zzX.zzZ((Object)string, "name");
        Style style = com.aspose.words.internal.zzX.zzZ(this.zzY0W, string);
        if (style == null && bl) {
            Style style2 = this.zzZcj().zzb(string, false);
            if (style2 == null) {
                style2 = StyleCollection.zzZck().zzb(string, false);
                if (style2 == null) {
                    style2 = StyleCollection.zzZcl().zzb(string, false);
                }
                if (style2 == null) {
                    style2 = StyleCollection.zzZcm().zzb(string, false);
                }
            }
            if (style2 != null && style2.getBuiltIn()) {
                style = this.zzF(style2);
            }
        }
        return style;
    }

    final Style zzZv(int n, boolean bl) {
        if (n == 4094) {
            throw new IllegalArgumentException("Cannot return user defined styles by style identifier.");
        }
        Style style = this.zzY0V.get(n);
        if (style == null && bl) {
            Style style2 = this.zzZcj().zzZv(n, false);
            if (style2 == null) {
                style2 = StyleCollection.zzZck().zzZv(n, false);
                if (style2 == null) {
                    style2 = StyleCollection.zzZcl().zzZv(n, false);
                }
                if (style2 == null) {
                    style2 = StyleCollection.zzZcm().zzZv(n, false);
                }
            }
            if (style2 != null) {
                style = this.zzF(style2);
            }
        }
        return style;
    }

    final boolean contains(int styleIdentifier) {
        return this.zzY0V.zzWT(styleIdentifier);
    }

    final Style zzXG(int n, int n2) {
        Style style = this.zzZw(n, n <= 14);
        if (style != null) {
            return style;
        }
        style = this.zzZw(n2, n2 <= 14);
        if (style != null) {
            return style;
        }
        throw new IllegalStateException("Cannot find a style with this istd.");
    }

    final Style zzJF(String string) {
        Style style = this.get(string);
        if (style == null) {
            throw new IllegalStateException(zz27.format("Cannot find style '{0}'.", string));
        }
        return style;
    }

    final Style zzze(int n) {
        Style style = this.getByStyleIdentifier(n);
        if (style == null) {
            throw new IllegalStateException("Cannot find a style with this style identifier.");
        }
        return style;
    }

    final Style zzF(Style style) {
        zzZNH zzZNH2 = new zzZNH(style.getDocument(), this.getDocument(), 0);
        return this.zzZ(zzZNH2, style);
    }

    final Style zzZ(zzZNH zzZNH2, Style style) {
        try {
            Style style2;
            int n;
            if (style == null) {
                throw new NullPointerException("srcStyle");
            }
            if (style.getStyles() == this) {
                return style;
            }
            if (style.zzZcH() != 4095 && (n = this.zzY(style, zzZNH2)) == 4095) {
                this.zzZ(zzZNH2, style.zzZcw());
            }
            if (!zzMN.zzXf(n = zzZNH2.zzZKw().get(style.zzZSf()))) {
                return this.zzZw(n, false);
            }
            switch (zzZNH2.zz2t()) {
                case 0: 
                case 2: {
                    Style style3;
                    Style style4 = style;
                    zzZNH zzZNH3 = zzZNH2;
                    StyleCollection styleCollection = this;
                    Style style5 = styleCollection.zzE(style4);
                    if (style5 != null) {
                        if (zzZNH3.zz2t() == 0) {
                            style3 = style5;
                        } else {
                            Style style6 = styleCollection.zzY(zzZNH3, style4);
                            style5 = styleCollection.zzD(style6);
                            if (style5 == null) {
                                style3 = style6;
                            } else {
                                style6.remove();
                                zzZNH3.zzZKw().set(style4.zzZSf(), style5.zzZSf());
                                if (style4.zzZcF() != 4095) {
                                    zzZNH3.zzZKw().set(style4.zzZcF(), style5.zzZcF());
                                }
                                style3 = style5;
                            }
                        }
                    } else {
                        style3 = styleCollection.zzY(zzZNH3, style4);
                    }
                    style2 = style3;
                    break;
                }
                case 1: {
                    style2 = this.zzY(zzZNH2, style);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown import format action.");
                }
            }
            return style2;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    final Style zzE(Style style) {
        Style style2;
        if (style.getBuiltIn() && (style2 = this.zzZv(style.getStyleIdentifier(), false)) != null) {
            return style2;
        }
        return this.zzb(style.getName(), false);
    }

    private Style zzY(zzZNH zzZNH2, Style style) {
        int n;
        Style style2;
        if (zzYVQ.zzB(style) && (style2 = this.zzZv(style.getStyleIdentifier(), false)) != null) {
            return style2;
        }
        style2 = style.zzZcx();
        if (zzZNH2.zzZKr()) {
            Theme.zzZ(zzZNH2.zzZKC().zz4G(), style2.zzZWn());
        }
        if (this.zzE(style) == null) {
            if (style.zzZSf() > 14) {
                style2.zzK8(this.zzZch());
            }
        } else {
            style2.zzJI(this.zzJG(style.getName()));
            style2.zzK8(this.zzZch());
            style2.setStyleIdentifier(4094);
        }
        Style style3 = style2;
        Object object = zzZNH2;
        Style style4 = style;
        StyleCollection styleCollection = this;
        styleCollection.zzH(style3);
        ((zzZNH)object).zzZKw().add(style4.zzZSf(), style3.zzZSf());
        if (style4.zzZcH() != 4095) {
            n = styleCollection.zzY(style4, (zzZNH)object);
            zz27.format("The base style for '{0}' must be already imported.", style3.getName());
            style3.zzzl(n);
        }
        if (style4.getType() == 4 || style4.getType() == 1) {
            Style style5 = style3;
            Style style6 = style4;
            zzZNH zzZNH3 = object;
            if (style6.getType() != 1) {
                style6.getType();
            }
            if (style6.zzZQH().getListId() != 0) {
                int n2 = style6.zzZQH().getListId();
                int n3 = zzZNH3.zzZKx().zzZ(zzZNH3, n2);
                style5.zzZQH().zzI5(n3);
                if (style5.getType() == 4) {
                    style5.getList().zzZGn().zzHN(style5.zzZSf());
                }
            }
        }
        if (style4.zzZcG() != 4095) {
            style3.zzzk(styleCollection.zzZ((zzZNH)object, style4.zzZcv()).zzZSf());
        }
        if (style4.zzZcF() != 4095) {
            n = ((zzZNH)object).zzZKw().get(style4.zzZcF());
            if (zzMN.zzXf(n)) {
                style3.zzzj(styleCollection.zzZ((zzZNH)object, style4.getLinkedStyle()).zzZSf());
                if (style3.zzZcF() != 4095) {
                    Style style7 = styleCollection.zzZw(style3.zzZcF(), false);
                    style7.zzzj(style3.zzZSf());
                }
            } else {
                style3.zzzj(4095);
            }
        }
        if (!zzZNH2.zzZKA().zzZci()) {
            object = style2;
            style4 = style;
            styleCollection = this;
            if (((Style)object).getStyleIdentifier() != 65 && ((Style)object).getStyleIdentifier() != 0 && ((Style)object).getStyleIdentifier() != 105) {
                style3 = style4.zzZcw();
                if (style3 != null) {
                    Style style8 = styleCollection.zzE(style3);
                    ((Style)object).zzzl(style8 != null ? style8.zzZSf() : StyleCollection.zzzf(((Style)object).getType()));
                }
                StyleCollection.zzZ(style4, (Style)object);
            }
        }
        return style2;
    }

    final void ensureMinimum() {
        this.zzw(0, "Normal");
        this.zzw(65, "Default Paragraph Font");
    }

    final void zzZcg() {
        Style style = this.zzZv(153, false);
        if (style == null) {
            return;
        }
        StyleCollection.zzV(style.zzZWn(), 190);
        StyleCollection.zzV(style.zzZWn(), 350);
        style = this.zzZw(style.zzZcF(), false);
        if (style == null) {
            return;
        }
        StyleCollection.zzV(style.zzZWn(), 190);
        StyleCollection.zzV(style.zzZWn(), 350);
    }

    final void zzZcf() {
        ArrayList arrayList = new ArrayList();
        for (Style style : this) {
            com.aspose.words.internal.zzX.zzZ(arrayList, style);
        }
        for (Style style : arrayList) {
            style.zzZcs();
        }
        for (Style style : arrayList) {
            style.zzZcr();
        }
    }

    final void zzZce() {
        for (Style style : this) {
            zzZ09 zzZ092 = style.zzZWn();
            zzZ092.remove(380);
            zzZ092.remove(340);
            zzZ092.remove(390);
        }
    }

    final void zzA(Document document) {
        zzZNH zzZNH2 = new zzZNH(document, this.getDocument(), 0);
        boolean bl = Theme.zzZ(this.zzZZZ.zz4G(), document.zz4G());
        for (Style style : this.getDocument().getStyles()) {
            StyleCollection styleCollection = document.getStyles();
            Style style2 = styleCollection.zzE(style);
            if (style2 == null) continue;
            if (style.getStyleIdentifier() == 0) {
                StyleCollection styleCollection2 = styleCollection;
                style.zzR((zzZ09)styleCollection2.zzY0Z.zzy3());
                styleCollection2 = styleCollection;
                style.zzV((zzZ74)styleCollection2.zzY0Y.zzy3());
                style2.zzZWn().zzY(style.zzZWn());
                style2.zzZQH().zzY(style.zzZQH());
            } else {
                style.zzR((zzZ09)style2.zzZWn().zzy3());
                style.zzV((zzZ74)style2.zzZQH().zzy3());
                if (style.zzZQH().getListId() != 0) {
                    style.zzZQH().zzI5(zzZNH2.zzZKx().zzZ(zzZNH2, style2.zzZQH().getListId()));
                }
                TableStyle tableStyle = com.aspose.words.internal.zzX.zzZ((Object)style, TableStyle.class);
                TableStyle tableStyle2 = com.aspose.words.internal.zzX.zzZ((Object)style2, TableStyle.class);
                if (tableStyle != null && tableStyle2 != null) {
                    tableStyle.zzQ((zzYU3)tableStyle2.zz3I().zzy3());
                    tableStyle.zzZ8Q();
                    for (zzYU0 zzYU02 : tableStyle2.zzZ8M()) {
                        tableStyle.zzZ(zzYU02.zzZ8L());
                    }
                }
            }
            if (bl) continue;
            Theme.zzZ(document.zz4G(), style.zzZWn());
        }
    }

    final int zzZ(Style style, zzZNH zzZNH2) {
        int n;
        Style style2;
        Style style3;
        block17: {
            Cloneable cloneable;
            Style style4;
            int n2 = zzZNH2.zzZKw().get(style.zzZSf());
            if (!zzMN.zzXf(n2)) {
                return n2;
            }
            zzZNH zzZNH3 = zzZNH2;
            Style style5 = style;
            StyleCollection styleCollection = this;
            Style style6 = styleCollection.zzE(style5);
            while (style6 != null && style6.getType() != style5.getType()) {
                Style style7;
                Style style8;
                block16: {
                    Style style9;
                    style4 = style6;
                    cloneable = style5.getStyles();
                    if (style4.getBuiltIn() && (style9 = ((StyleCollection)cloneable).zzZv(style4.getStyleIdentifier(), false)) != null && style9.getType() == style4.getType()) {
                        style8 = style9;
                    } else {
                        Style style10 = style4;
                        Cloneable cloneable2 = cloneable;
                        for (int i = 0; i < ((StyleCollection)cloneable2).zzY0W.getCount(); ++i) {
                            Style style11;
                            String string = ((StyleCollection)cloneable2).zzY0W.getKey(i);
                            if (!zz27.equals(string, style10.getName()) && !zzZF.zzY(style10.getAliases(), string) || (style11 = ((StyleCollection)cloneable2).zzY0W.zzX2(i)).getType() != style10.getType()) continue;
                            style8 = style11;
                            break block16;
                        }
                        style8 = style7 = null;
                    }
                }
                if (style8 == null) {
                    zzX.zzY(styleCollection.getDocument().getWarningCallback(), 0, "Cannot copy style {0} because it matches a style of a different type.", style5.getName());
                    zzZNH3.zzZKw().set(style5.zzZSf(), 4095);
                    style3 = null;
                    break block17;
                }
                StyleCollection.zzW(style6, style7);
                style6 = styleCollection.zzE(style5);
            }
            if (style6 != null) {
                style4 = style6;
                cloneable = style5;
                ((Style)cloneable).getType();
                style4.getType();
                style4.clearCaches();
                StyleCollection.zzW((Style)cloneable, style4);
                style4.zzK((Style)cloneable);
                style4.zzR((zzZ09)((Style)cloneable).zzZWn().zzy3());
                if (style4.getType() != 2) {
                    style4.zzV((zzZ74)((Style)cloneable).zzZQH().zzy3());
                    if (style4.getType() == 3) {
                        TableStyle.zzZ((TableStyle)cloneable, (TableStyle)style4);
                    }
                }
            } else {
                style6 = style5.zzZcx();
                if (styleCollection.zzY0X.contains(style6.zzZSf())) {
                    style6.zzK8(styleCollection.zzZch());
                }
                styleCollection.zzH(style6);
            }
            zzZNH3.zzZKw().set(style5.zzZSf(), style6.zzZSf());
            style3 = style2 = style6;
        }
        if (style3 == null) {
            return 4095;
        }
        if (style.zzZcH() != 4095) {
            style2.zzzl(this.zzZ(style.zzZcw(), zzZNH2));
        }
        if (style.zzZcF() != 4095) {
            style2.zzzj(this.zzZ(style.getLinkedStyle(), zzZNH2));
        }
        if (style.zzZcG() != 4095) {
            style2.zzzk(this.zzZ(style.zzZcv(), zzZNH2));
        }
        if ((style.getType() == 4 || style.getType() == 1) && (n = style.zzZQH().getListId()) != 0) {
            style2.zzZQH().set(1120, this.getDocument().getLists().zzZ(n, zzZNH2));
        }
        return style2.zzZSf();
    }

    private void zzw(int n, String string) {
        int n2;
        Style style = this.zzb(string, false);
        if (style != null && style.getStyleIdentifier() != n) {
            String string2 = this.zzJG(string);
            style.zzc(string2, true);
        }
        if ((style = this.zzZw(n2 = zzYVQ.zzz0(n), true)).getStyleIdentifier() != n) {
            style.zzZA(this.zzZch(), true);
            this.zzZv(n, true);
        }
    }

    private static void zzV(zzZ09 zzZ092, int n) {
        int n2;
        if (zzZ092.contains(n) && (n2 = ((Integer)zzZ092.get(n)).intValue()) == 0) {
            zzZ092.remove(n);
        }
    }

    private Style zzD(Style style) {
        for (Style style2 : this) {
            if (com.aspose.words.internal.zzX.zzV(style2, style) || !style.zzL(style2)) continue;
            return style2;
        }
        return null;
    }

    private int zzY(Style style, zzZNH zzZNH2) {
        style.zzZcH();
        Style style2 = style.zzZcw();
        int n = zzZNH2.zzZKw().get(style2.zzZSf());
        if (zzMN.zzXf(n)) {
            Style style3;
            if (zzYVQ.zzB(style2)) {
                style3 = this.zzZv(style2.getStyleIdentifier(), false);
            } else {
                style3 = this.zzE(style2);
                if (style3 == null && zzZNH2.zz2t() == 2) {
                    style3 = this.zzD(style2);
                }
            }
            if (style3 != null) {
                n = style3.zzZSf();
            }
        }
        if (zzMN.zzXf(n)) {
            return 4095;
        }
        return n;
    }

    private static void zzW(Style style, Style style2) {
        if (style.getAliases().length == 0 && style2.getAliases().length == 0) {
            return;
        }
        StyleCollection styleCollection = style2.getStyles();
        styleCollection.zzI(style2);
        styleCollection.zzY0W.set(style.getName(), style2);
        for (String string : style.getAliases()) {
            styleCollection.zzY0W.set(string, style2);
        }
        if (style.getStyles().zzY0L.containsKey(style)) {
            styleCollection.zzY0L.put(style2, style.getStyles().zzY0L.get(style));
            return;
        }
        com.aspose.words.internal.zzX.zzY(styleCollection.zzY0L, style2);
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    static {
        zzY0S = new Object();
        zzY0Q = new Object();
        zzY0O = new Object();
    }
}

