/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzT;
import com.aspose.words.net.System.Data.zzU;
import com.aspose.words.net.System.Data.zzV;
import com.aspose.words.net.System.Data.zzX;
import com.aspose.words.net.System.Data.zzY;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzXMe = new DataRowCollection(this);
    private final DataColumnCollection zzXMd = new DataColumnCollection(this);
    private final ConstraintCollection zzXMc = new ConstraintCollection(this);
    private final zzT zzXMb = new zzT(this);
    private ResultSet zzXMa;
    private String zzZaH;
    private DataSet zz3G;
    private String zzZ0m = "";
    private UniqueConstraint zzXM9;
    private boolean zzXMp = true;
    private final List<DataTableEventListener> zzXM8 = new ArrayList<DataTableEventListener>();
    private final Set<DataRow> zzXM7 = new HashSet<DataRow>();

    public DataTable() {
    }

    public DataTable(String tableName) {
        this.zzZaH = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        this(resultSet, zzY.zzZ(resultSet));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzXMa = resultSet;
        this.zzZaH = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzXMa != null) {
            if (this.zzXMa.getStatement() != null) {
                this.zzXMa.getStatement().getConnection().close();
            }
            this.zzXMa = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzZaH;
    }

    public void setTableName(String tableName) {
        this.zzZaH = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzXMd.getCount();
    }

    public String getColumnName(int index) {
        return this.zzXMd.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzXMa;
    }

    public DataSet getDataSet() {
        return this.zz3G;
    }

    final void zzZ(DataSet dataSet) {
        this.zz3G = dataSet;
    }

    public DataRowCollection getRows() {
        return this.zzXMe;
    }

    public DataColumnCollection getColumns() {
        return this.zzXMd;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzXMc;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzXM9 == null) {
            return new DataColumn[0];
        }
        return this.zzXM9.getColumns();
    }

    final void zzT(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzXM9 != null) {
                this.zzXM9.zzQL(false);
                this.getConstraints().remove(this.zzXM9);
                this.zzXM9 = null;
            }
            return;
        }
        if (this.zzXM9 != null && DataColumn.areColumnSetsTheSame(value, this.zzXM9.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzZ(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzXM9 != null) {
            this.zzXM9.zzQL(false);
            this.getConstraints().remove(this.zzXM9);
            this.zzXM9 = null;
        }
        UniqueConstraint.zzZ(this.getConstraints(), uniqueConstraint);
        this.zzXM9 = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzZ0m;
    }

    public void setNamespace(String namespace) {
        this.zzZ0m = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzXMp;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzXMp = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzXM7.clear();
            this.getRows().clear();
            this.getColumns().clear();
            DataTable dataTable = this;
            ResultSet resultSet = this.getResultSet();
            for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                String string = resultSetMetaData.getColumnName(i);
                DataColumn dataColumn = new DataColumn(string, dataTable, i);
                dataColumn.setAllowDBNull(resultSetMetaData.isNullable(i) == 1);
                dataColumn.setAutoIncrement(resultSetMetaData.isAutoIncrement(i));
                dataColumn.setReadOnly(resultSetMetaData.isReadOnly(i));
                try {
                    dataColumn.setDataType(Class.forName(resultSetMetaData.getColumnClassName(i)));
                }
                catch (ClassNotFoundException classNotFoundException) {}
                dataTable.getColumns().add(dataColumn);
            }
            zzY.zzZ(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            sQLException.printStackTrace();
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzY.zzY(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzXM8.contains(listener)) {
            this.zzXM8.add(listener);
        }
    }

    public void removeEventListener(zzX listener) {
        if (this.zzXM8.contains(listener)) {
            this.zzXM8.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzXM8.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzXM7.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXM8) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzXM7.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXM8) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzXM7.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXM8) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzXM8) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzXM8) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final boolean zzZ(DataColumn[] dataColumnArray, DataColumn[] dataColumnArray2, DataRow dataRow) {
        DataTable dataTable;
        DataRow dataRow2 = dataRow;
        DataColumn[] dataColumnArray3 = dataColumnArray2;
        DataColumn[] dataColumnArray4 = dataColumnArray;
        DataTable dataTable2 = dataTable = this;
        zzU zzU10 = dataTable.zzXMb.zzX(dataColumnArray4);
        return zzU10.zzwL(zzV.zzZ(dataColumnArray3, dataRow2));
    }

    final zzT zzZ5l() {
        return this.zzXMb;
    }

    final Set<DataRow> zzZ5k() {
        return this.zzXM7;
    }
}

