/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzZYb;
import com.aspose.words.internal.zzZlt;
import com.aspose.words.zzLv;
import com.aspose.words.zzVPE;
import com.aspose.words.zzVVL;
import com.aspose.words.zzW1R;
import com.aspose.words.zzWZf;
import com.aspose.words.zzWeg;
import com.aspose.words.zzXh7;
import com.aspose.words.zzYN1;
import com.aspose.words.zzZWa;
import com.aspose.words.zzl3;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzWZf zzJp;

    ChartSeriesCollection(zzWZf dmlChart) {
        this.zzJp = dmlChart;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzJp.zzZzf().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzJp.zzZzf().iterator();
    }

    public void removeAt(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzJp.zzZzf().remove(index);
    }

    public void clear() {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzJp.zzZzf().clear();
        this.zznC(false);
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        if (categories == null || values == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (categories.length <= 0 || values.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (categories.length != values.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzkO(seriesName, values);
        chartSeries.zzZeO().zzkO(ChartSeriesCollection.zzZfk(categories));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzkO(seriesName, yValues);
        chartSeries.zzZeO().zzkO(ChartSeriesCollection.zzqD(xValues));
        return chartSeries;
    }

    private ChartSeries zzkO(String string, zzZYb[] zzZYbArray, double[] dArray) {
        if (zzZYbArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzZYbArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzZYbArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzkO(string, dArray);
        chartSeries.zzZeO().zzkO(ChartSeriesCollection.zzkO(zzZYbArray));
        if (!this.zzJp.zzVYW()) {
            this.zznC(true);
        }
        return chartSeries;
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzkO(seriesName, zzZYb.zzkO(dates), values);
    }

    private void zznC(boolean bl) {
        zzLv zzLv2 = zzZlt.zzkO((Object)this.zzJp, zzLv.class);
        if (zzLv2 != null && zzLv2.zzYxv().zzWnv()) {
            zzLv2.zzYxv().zzZZh().zzXlA(2, bl);
        }
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (this.zzJp.zzY2T() != 15) {
            this.zzJp.zzM5(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzkO(seriesName, yValues);
        chartSeries.zzXvV().zzXb2().zzXlA(3, this.zzJp.zzYQY());
        chartSeries.zzZeO().zzkO(ChartSeriesCollection.zzqD(xValues));
        if (bubbleSizes != null) {
            chartSeries.zzYC9().zzkO(ChartSeriesCollection.zzqD(bubbleSizes));
        }
        return chartSeries;
    }

    private ChartSeries zzkO(String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(this.zzJp);
        chartSeries.setName(string);
        this.zzXnp(chartSeries);
        chartSeries.zz4w(this.zzJp.zzZzf().size());
        ChartSeries chartSeries2 = chartSeries;
        chartSeries2.zzXlT(chartSeries2.getIndex());
        chartSeries.zzam().zzkO(ChartSeriesCollection.zzqD(dArray));
        chartSeries.zzVU2().zzkO(chartSeries.zzam().zzZ9q());
        this.zzJp.zzYl7(chartSeries);
        return chartSeries;
    }

    private void zzXnp(ChartSeries chartSeries) {
        chartSeries.zzXvV().zzXb2().zzXlA(5, new zzl3());
        switch (this.zzJp.zzY2T()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzkO(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzkO(chartSeries, 5);
                ChartSeriesCollection.zzZNa(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzkO(chartSeries, 1);
                ChartSeriesCollection.zzZNa(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzM5(chartSeries);
            }
        }
    }

    private static void zzM5(ChartSeries chartSeries) {
        zzl3 zzl32 = new zzl3();
        zzl32.zzXsR(new zzZWa());
        zzXh7 zzXh72 = new zzXh7();
        zzXh72.zzZH7(1);
        zzl32.zzX3R().zzXsR(new zzYN1(zzXh72));
        zzl32.zzX3R().zzXfp(19050.0);
        chartSeries.zzXvV().zzXb2().zzXlA(5, zzl32);
    }

    private static void zzZNa(ChartSeries chartSeries) {
        zzl3 zzl32 = new zzl3();
        zzl32.zzXsR(new zzZWa());
        zzl32.zzX3R().zzXsR(new zzWeg());
        zzl32.zzX3R().setEndCap(0);
        zzl32.zzX3R().zzXfp(19050.0);
        chartSeries.zzXvV().zzXb2().zzXlA(5, zzl32);
    }

    private static void zzkO(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker();
        chartMarker.zzXKU().zzXlA(0, n);
        chartSeries.zzXvV().zzXb2().zzXlA(4, chartMarker);
    }

    private static zzVPE zzqD(double[] dArray) {
        int n = 0;
        zzVPE zzVPE2 = new zzVPE(2, false);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzVPE2.zzZyE(new zzW1R(n, d, "General"));
            }
            ++n;
        }
        zzVPE2.zzWQS(dArray.length);
        zzVPE2.zzXLD();
        return zzVPE2;
    }

    private static zzVPE zzkO(zzZYb[] zzZYbArray) {
        int n = 0;
        zzVPE zzVPE2 = new zzVPE(2, false);
        zzZYb[] zzZYbArray2 = zzZYbArray;
        int n2 = zzZYbArray.length;
        for (int i = 0; i < n2; ++i) {
            zzZYb zzZYb2 = zzZYbArray2[i];
            zzVPE2.zzZyE(new zzW1R(n++, zzZYb2.zzZ0r(), "m/d/yyyy"));
        }
        zzVPE2.zzWQS(zzZYbArray.length);
        zzVPE2.zzXLD();
        return zzVPE2;
    }

    private static zzVPE zzZfk(String[] stringArray) {
        int n = 0;
        zzVPE zzVPE2 = new zzVPE(1, false);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzVPE2.zzZyE(new zzVVL(n++, string));
        }
        zzVPE2.zzWQS(stringArray.length);
        zzVPE2.zzXLD();
        return zzVPE2;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzJp.zzZzf().size();
    }
}

