/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzZlt;
import com.aspose.words.ref.Ref;
import com.aspose.words.zzVWB;
import com.aspose.words.zzWg0;
import com.aspose.words.zzWhW;
import com.aspose.words.zzWv;
import com.aspose.words.zzXm7;
import com.aspose.words.zzYHa;
import com.aspose.words.zzyJ;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzWhW,
Iterable<T> {
    private Node zzZoI;
    private Node zzZns;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        while (this.hasChildNodes()) {
            this.getParentNode().insertAfter(this.getLastChild(), this);
        }
        this.remove();
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzWcO() {
        return this.zzny() != null;
    }

    final boolean zzVR5() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzW1L() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzWv) {
                return true;
            }
            CompositeNode compositeNode = zzZlt.zzkO((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzW1L()) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        return this.zzZoI;
    }

    public Node getLastChild() {
        return this.zzZns;
    }

    final Node zzny() {
        return zzWg0.zzZNa(this.getFirstChild(), false);
    }

    final Node zzYhv() {
        return zzWg0.zzYl7(this.getLastChild(), false);
    }

    final CompositeNode zzWP7() {
        return (CompositeNode)zzWg0.zzZNa(this.getFirstChild(), true);
    }

    final CompositeNode zzWHO() {
        return (CompositeNode)zzWg0.zzYl7(this.getLastChild(), true);
    }

    final Node zzXxB() {
        Node node;
        for (node = this.getFirstChild(); node != null && zzWg0.zzXiN(node); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzgr() {
        Node node;
        for (node = this.getLastChild(); node != null && zzWg0.zzXiN(node); node = node.getPreviousSibling()) {
        }
        return node;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzkO(boolean bl, zzYHa zzYHa2) {
        CompositeNode compositeNode = (CompositeNode)super.zzkO(bl, zzYHa2);
        ((CompositeNode)super.zzkO(bl, zzYHa2)).zzZns = null;
        compositeNode.zzZoI = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzvB(node.zzkO(true, zzYHa2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzW57(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzW57(StringBuilder stringBuilder) {
        this.zzZiT(stringBuilder);
        zzZlt.zzXsR(stringBuilder, this.zzWIM());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzXsR(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, true);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzWg0.zzZOD(nodeType);
            Node node2 = node = bl ? this.zzny() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzYCa() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzXm7.zzm6(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzXm7.zzqD(this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzVWB(this);
    }

    public Node appendChild(Node newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) {
        return this.zzkO(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.zzkO(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        if (oldChild == null) {
            throw new NullPointerException("oldChild");
        }
        if (oldChild.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzkO(oldChild, this, null, 1);
        if (documentBase.zzpY() && zzWg0.zzYok(oldChild)) {
            return oldChild;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzkO(nodeChangingArgs);
        }
        Node node = this.zzZ0B(oldChild);
        if (nodeChangingArgs != null) {
            documentBase.zzXsR(nodeChangingArgs);
        }
        return node;
    }

    public void removeAllChildren() {
        zzyJ.zzXiN(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzvB(Node node) {
        node.getParentNode();
        if (this.zzZns == null) {
            node.zznC(null);
            node.zzeF(null);
            this.zzZoI = node;
        } else {
            node.zznC(this.zzZns);
            node.zzeF(null);
            this.zzZns.zzeF(node);
        }
        this.zzZns = node;
        node.zzZxJ(this);
        return node;
    }

    final void zzkO(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            this.insertBefore(node4, node3);
            node4 = node5;
        }
    }

    final void zzXsR(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzXsR(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (zzWg0.zzXiN(node2)) continue;
            if (zzWg0.zzYkO(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzWIM().length();
    }

    String zzWIM() {
        return "";
    }

    final String zzXYE() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzZiT(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzZiT(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzW57(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzkO(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zzXsR(visitor));
    }

    abstract int zzkO(DocumentVisitor var1) throws Exception;

    abstract int zzXsR(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzZiT(Node var1);

    final Node zzkO(Node node, Node node2, boolean bl) {
        NodeChangingArgs nodeChangingArgs;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzON(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 35 && !this.zzZiT(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        if (node.getParentNode() != null) {
            node.getParentNode().removeChild(node);
            if (!node.zzXtA()) {
                node.getParentNode().zzZ0B(node);
            }
        }
        if ((nodeChangingArgs = documentBase.zzkO(node, null, this, 0)) != null) {
            documentBase.zzkO(nodeChangingArgs);
        }
        if (this.zzZns == null) {
            node.zznC(null);
            node.zzeF(null);
            this.zzZoI = node;
            this.zzZns = node;
        } else if (bl) {
            if (node2 != null) {
                this.zzXsR(node, node2);
            } else {
                this.zzm6(node, this.zzZoI);
            }
        } else if (node2 != null) {
            this.zzm6(node, node2);
        } else {
            this.zzXsR(node, this.zzZns);
        }
        node.zzZxJ(this);
        if (nodeChangingArgs != null) {
            documentBase.zzXsR(nodeChangingArgs);
        }
        if (documentBase.zzpY()) {
            zzWg0.zzZH9(node);
        }
        return node;
    }

    private void zzXsR(Node node, Node node2) {
        Node node3 = node2.zzKI();
        node.zznC(node2);
        node.zzeF(node3);
        node2.zzeF(node);
        if (node3 == null) {
            this.zzZns = node;
            return;
        }
        node3.zznC(node);
    }

    private void zzm6(Node node, Node node2) {
        Node node3 = node2.zzX5M();
        node.zznC(node3);
        node.zzeF(node2);
        node2.zznC(node);
        if (node3 == null) {
            this.zzZoI = node;
            return;
        }
        node3.zzeF(node);
    }

    private Node zzZ0B(Node node) {
        if (node == this.zzZoI) {
            if (this.zzZoI == this.zzZns) {
                this.zzZoI = null;
                this.zzZns = null;
            } else {
                this.zzZoI = node.zzKI();
                this.zzZoI.zznC(null);
            }
        } else {
            Node node2 = node.zzX5M();
            Node node3 = node.zzKI();
            node2.zzeF(node3);
            if (node3 == null) {
                this.zzZns = node2;
            } else {
                node3.zznC(node2);
            }
        }
        node.zzeF(null);
        node.zznC(null);
        node.zzZxJ(null);
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Ref<Node> curNode) {
        Node node = curNode.get();
        Ref<Node> ref = curNode;
        ref.set(ref.get() == this ? this.getFirstChild() : curNode.get().getNextSibling());
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

