/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Table;
import com.aspose.words.internal.zzA8;
import com.aspose.words.internal.zzGa;
import com.aspose.words.internal.zzGt;
import com.aspose.words.internal.zzPo;
import com.aspose.words.internal.zzWfe;
import com.aspose.words.internal.zzX0N;
import com.aspose.words.internal.zzX7n;
import com.aspose.words.internal.zzXWm;
import com.aspose.words.internal.zzXnK;
import com.aspose.words.internal.zzZ0t;
import com.aspose.words.internal.zzZII;
import com.aspose.words.internal.zzZlt;
import com.aspose.words.internal.zzh6;
import com.aspose.words.internal.zzvE;
import com.aspose.words.zzJi;
import com.aspose.words.zzMD;
import com.aspose.words.zzUT;
import com.aspose.words.zzVPg;
import com.aspose.words.zzVSQ;
import com.aspose.words.zzVWg;
import com.aspose.words.zzW0U;
import com.aspose.words.zzW4Q;
import com.aspose.words.zzWAX;
import com.aspose.words.zzWBF;
import com.aspose.words.zzWVd;
import com.aspose.words.zzWg0;
import com.aspose.words.zzWgg;
import com.aspose.words.zzWrM;
import com.aspose.words.zzX34;
import com.aspose.words.zzX5U;
import com.aspose.words.zzXFe;
import com.aspose.words.zzXwE;
import com.aspose.words.zzY0A;
import com.aspose.words.zzY3v;
import com.aspose.words.zzY8R;
import com.aspose.words.zzYKJ;
import com.aspose.words.zzYk7;
import com.aspose.words.zzYwM;
import com.aspose.words.zzZ1v;
import com.aspose.words.zzZ3M;
import com.aspose.words.zzZ7V;
import com.aspose.words.zzZJ2;
import com.aspose.words.zzZS7;
import com.aspose.words.zzZV3;
import com.aspose.words.zzZcy;
import com.aspose.words.zzeX;
import com.aspose.words.zzho;
import com.aspose.words.zzkc;
import com.aspose.words.zzqw;
import com.aspose.words.zzto;
import com.aspose.words.zzyp;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzUT,
zzVWg,
zzZ3M {
    private Document zzZBA;
    private Node zzXJu;
    private Node zzZ9n;
    private zzZ1v zzQb;
    private Font zzYSP;
    private zzX0N<zzZ1v> zzXh3;
    private zzX0N<zzkO> zzWbU;
    private zzho zzXiM = zzho.zzZ3X();
    private zzWgg zzYBh = new zzWgg();
    private RowFormat zz2f;
    private CellFormat zzuD;
    private zzX0N<zzY3v> zzZaQ;
    private int zzYAO = 0;
    private int zzZ9I = -1;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzX80(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzX80(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzX80(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzkO(documentBuilder.getCurrentSection(), zzVSQ.zzYWs(headerFooterType), 0, 0);
    }

    private void zzX80(int n, int n2, int n3, int n4) {
        this.zzZBA.ensureMinimum();
        Section section = (Section)this.zzZBA.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzkO(section, 1, n3, n4);
    }

    private void zzkO(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzVSQ.zzYVJ(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzZBA, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzZBA));
            }
        }
        this.zzkO(story, n2, n3);
    }

    private void zzkO(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        this.zzm6(paragraph, n2);
    }

    final void zzm6(Paragraph paragraph, int n) {
        if (n == 0) {
            Paragraph paragraph2 = paragraph;
            this.zzXsR(paragraph2, paragraph2.getFirstChild());
            return;
        }
        if (n == -1) {
            this.zzXsR(paragraph, null);
        }
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        FieldMergeField fieldMergeField = this.zzWFh().zzXtA() ? zzW0U.zzZNa(this.zzZBA, fieldName) : zzW0U.zzYl7(this.zzWFh(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzkO(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzkO(field, isAfter, false);
    }

    private boolean zzkO(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzZV3 zzZV32 = field.getFormat().zzXjN();
        Inline inline = zzZV32.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzkO(inline.zzQg(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("bookmarkName");
        }
        Node node = isStart ? zzto.zzkO(this.zzZBA, bookmarkName) : zzto.zzXsR(this.zzZBA, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzWhe() == 6) {
            this.zzXsR((Paragraph)node.zzZm4(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzWg0.zzzY(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzXsR(paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzkO(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        if (characterIndex != 0 && characterIndex != -1) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: characterIndex");
        }
        Row row = this.zzZMI(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        if (characterIndex == 0) {
            this.zzm6(cell.getFirstParagraph(), 0);
            return;
        }
        if (characterIndex == -1) {
            this.zzm6(cell.getLastParagraph(), -1);
        }
    }

    private void zzXsR(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(paragraph);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzWhe() == 6) {
            this.zzYQf(node);
        } else if (zzWg0.zzXiN(node)) {
            Paragraph paragraph = zzWg0.zzzY(node);
            if (paragraph == null) {
                throw new IllegalStateException("There is no paragraph next to the specified node.");
            }
            this.zzYQf(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
        } else if (node.isComposite() && node.zzWhe() == 3) {
            Node node2 = ((CompositeNode)node).getChild(8, 0, true);
            if (node2 == null) {
                throw new IllegalStateException("The block level node doesn't contain paragraph.");
            }
            this.zzYQf(node2);
        } else {
            throw new IllegalStateException("The node must be a block or an inline.");
        }
        if (this.isAtEndOfParagraph()) {
            this.zzXpr();
            return;
        }
        if (!this.zzW2o()) {
            this.zzXpr();
        }
    }

    private boolean zzW2o() {
        Node node = this.zzWFh();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
        }
        if (node == null) {
            for (node = this.zzWFh(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzkO(inline.zzQg(), true);
            return true;
        }
        return false;
    }

    private void zzXpr() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzkO(documentBuilder.getCurrentParagraph().zzwb(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzZMI(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzXJb() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzWFh().zzON(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzVQk();
                this.zzm6(paragraph, 0);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzVPg(text, false);
    }

    public void writeln(String text) {
        this.zzVPg(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        Paragraph paragraph = this.getCurrentParagraph();
        zzYKJ zzYKJ2 = new zzYKJ(this.getDocument());
        try {
            Paragraph paragraph2 = new Paragraph(this.zzZBA, this.zzrp(), this.zzX2r());
            this.getCurrentParagraph().getParentNode().insertAfter(paragraph2, this.getCurrentParagraph());
            if (this.isAtEndOfParagraph()) {
                this.moveTo(paragraph2);
            } else {
                paragraph2.zzXsR(this.zzWFh(), null, paragraph2.getLastChild());
            }
        }
        finally {
            zzYKJ2.dispose();
        }
        if (this.getDocument().zzpY()) {
            zzWg0.zzm6((zzYwM)paragraph, this.getDocument().zzYGl());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzk5() {
        Node node = this.zzWFh();
        Paragraph paragraph = this.getCurrentParagraph();
        Run run = this.isAtEndOfParagraph() ? paragraph.zzXnr() : (Run)node.zzX0n(21);
        if (run == null && zzZlt.zzWBZ(node, paragraph.zzVQB())) {
            run = paragraph.zzVQB();
        }
        zzZ1v zzZ1v2 = run != null ? (zzZ1v)run.zzQg().zzs2() : (zzZ1v)paragraph.zzwb().zzs2();
        Paragraph paragraph2 = new Paragraph(this.zzZBA, this.zzrp(), zzZ1v2);
        paragraph.getParentNode().insertBefore(paragraph2, paragraph);
        zzYKJ zzYKJ2 = new zzYKJ(this.zzZBA);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzXsR(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzYKJ2.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zzY8R.zzXnp(this);
    }

    public void insertBreak(int breakType) {
        this.zzZFz(breakType, true);
    }

    final void zzZFz(int n, boolean bl) {
        switch (n) {
            case 0: {
                this.insertParagraph();
                return;
            }
            case 1: {
                if (this.zz2s(bl)) {
                    this.zzXie(ControlChar.PAGE_BREAK);
                }
                return;
            }
            case 2: {
                if (this.zz2s(bl)) {
                    this.zzXie(ControlChar.COLUMN_BREAK);
                }
                return;
            }
            case 4: {
                if (this.zz2s(bl)) {
                    this.zzWBq(1);
                }
                return;
            }
            case 5: {
                if (this.zz2s(bl)) {
                    this.zzWBq(2);
                }
                return;
            }
            case 3: {
                if (this.zz2s(bl)) {
                    this.zzWBq(0);
                }
                return;
            }
            case 6: {
                if (this.zz2s(bl)) {
                    this.zzWBq(3);
                }
                return;
            }
            case 7: {
                if (this.zz2s(bl)) {
                    this.zzWBq(4);
                }
                return;
            }
            case 8: {
                this.zzXie(ControlChar.LINE_BREAK);
                return;
            }
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzZII.zzZI3(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzX7n.zzXsR("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        return zzWg0.zzkO(fieldType, updateField, this.zzX2r(), this.zzWFh(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode) throws Exception {
        return zzWg0.zzkO(fieldCode, this.zzX2r(), this.zzWFh(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        return zzWg0.zzkO(fieldCode, fieldValue, this.zzX2r(), this.zzWFh(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzZlt.zzXsR((Object)displayText, "displayText");
        zzZlt.zzXsR((Object)urlOrBookmark, "hrefOrBookmark");
        zzyp zzyp2 = this.zzXsR(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zzyp2.zzXsR(documentBuilder.zzXj(88, true));
        return zzWg0.zzkO(zzyp2.getStart(), zzyp2.getSeparator(), zzyp2.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzZhY(70);
        if (zzZII.zzZI3(name)) {
            this.startBookmark(name);
        }
        this.zzXAK(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzSf(70);
        String string = zzZII.zzZI3(fieldValue) ? fieldValue : FormField.zzWeN;
        Run run = new Run(this.zzZBA, string, this.zzX2r());
        this.insertNode(run);
        this.zzXj(70, true);
        if (zzZII.zzZI3(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzW5C(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzZhY(71);
        if (zzZII.zzZI3(name)) {
            this.startBookmark(name);
        }
        this.zzXAK(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzXj(71, false);
        if (zzZII.zzZI3(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzW5C(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (items == null) {
            throw new NullPointerException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzZhY(83);
        if (zzZII.zzZI3(name)) {
            this.startBookmark(name);
        }
        this.zzXAK(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzXj(83, false);
        if (zzZII.zzZI3(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzW5C(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote((DocumentBase)this.zzZBA, footnoteType);
        footnote.getFont().setStyleIdentifier(zzWg0.zzWRy(footnoteType));
        if (zzZII.zzZI3(referenceMark)) {
            footnote.setReferenceMark(referenceMark);
        }
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzZBA);
        paragraph.getParagraphFormat().setStyleIdentifier(zzWg0.zzWVB(footnoteType));
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzZBA, '\u0002', new zzZ1v()) : new Run(this.zzZBA, footnote.getReferenceMark(), new zzZ1v());
        inline.getFont().setStyleIdentifier(zzWg0.zzWRy(footnoteType));
        paragraph.appendChild(inline);
        if (zzZII.zzZI3(footnoteText)) {
            Node node = this.zzWFh();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzYQf(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzWLG(zzGt zzGt2) throws Exception {
        return this.zzkO(zzGt2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzWLG(zzGt.zzXsR(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzkO(zzGt zzGt2, double d, double d2) throws Exception {
        return this.zzkO(zzGt2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzkO(zzGt.zzXsR(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("image");
        }
        try (zzZ0t zzZ0t2 = new zzZ0t();){
            zzWfe.zzkO(image, zzZ0t2);
            Shape shape = this.zzkO(zzZ0t2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzZlt.zzkO(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzh6.zzYMo(fileName);
        try {
            Shape shape = this.zzkO((zzGt)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzGt)object).close();
            }
        }
    }

    private Shape zzkO(zzGt zzGt2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzGt2 == null) {
            throw new NullPointerException("stream");
        }
        byte[] byArray = zzZlt.zzXnp(zzGt2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzkO(zzGt.zzXsR(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Shape shape;
        if (imageBytes == null) {
            throw new NullPointerException("imageBytes");
        }
        if (this.zzZBA.getCompatibilityOptions().getMswVersion() > 12 || this.zzZBA.getCompatibilityOptions().getMswVersion() == 0) {
            shape = new Shape((DocumentBase)this.zzZBA, 0);
            zzWBF zzWBF2 = new zzWBF();
            zzWBF2.zzkO(zzZJ2.zzYwG("rect"));
            zzWBF2.zzkO(new zzW4Q());
            zzWrM zzWrM2 = new zzWrM();
            zzWrM2.zzXsR(new zzYk7(this.zzZBA.zzXKy(), ""));
            zzWrM2.zzkO(new zzY0A());
            zzWBF2.zzkO(zzWrM2);
            shape.zzXR0(75);
            shape.zzXnp(zzWBF2);
        } else {
            shape = new Shape((DocumentBase)this.zzZBA, 75);
        }
        shape.zzkO(this.zzX2r());
        if (shape.getImageData().zzYyz(imageBytes)) {
            imageBytes = shape.getImageData().zzkO(imageBytes, new zzkc(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()));
        }
        shape.getImageData().setImageBytes(imageBytes);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        shape.zzZ4v(width, height);
        return shape;
    }

    private Shape zzYT4(BufferedImage bufferedImage) throws Exception {
        byte[] byArray;
        try (zzZ0t zzZ0t2 = new zzZ0t();){
            zzWfe.zzkO(bufferedImage, zzZ0t2);
            byArray = zzZlt.zzXnp(zzZ0t2);
        }
        return this.zzZad(byArray);
    }

    private Shape zzZad(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzZBA, 1);
        shape.zzXR0(75);
        shape.zzkO(this.zzX2r());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzZ4v(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private Shape zzkO(zzGt zzGt2, String string, boolean bl, BufferedImage bufferedImage) throws Exception {
        zzWAX zzWAX2 = zzWAX.zzGt(string);
        Shape shape = this.zzkO(bufferedImage, bl, zzWAX2);
        zzWVd zzWVd2 = zzZcy.zzkO(zzGt2, string, bl);
        return DocumentBuilder.zzkO(null, false, shape, zzWAX2.zzYvs, zzWVd2);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, BufferedImage presentation) throws Exception {
        return this.zzkO(zzGt.zzXsR(stream), progId, asIcon, presentation);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, BufferedImage presentation) throws Exception {
        zzWAX zzWAX2 = zzWAX.zzXv8(zzA8.zzYj4(fileName));
        return this.zzkO(fileName, isLinked, asIcon, presentation, zzWAX2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, BufferedImage presentation) throws Exception {
        zzWAX zzWAX2 = zzWAX.zzGt(progId);
        return this.zzkO(fileName, isLinked, asIcon, presentation, zzWAX2);
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzWAX zzWAX2 = zzWAX.zzXv8(zzA8.zzYj4(fileName));
        zzvE zzvE2 = new zzvE(iconFile, iconCaption, this.getDocument().zzZS1());
        Shape shape = this.zzZad(zzvE2.zzYca());
        zzWVd zzWVd2 = zzZcy.zzkO(fileName, isLinked, true, zzWAX2);
        return DocumentBuilder.zzkO(fileName, isLinked, shape, zzWAX2.zzYvs, zzWVd2);
    }

    final Shape zzkO(zzMD zzMD2, BufferedImage bufferedImage) throws Exception {
        Shape shape = this.zzYT4(bufferedImage);
        shape.zzXR0(201);
        shape.getOleFormat().zzXsR(zzMD2.zzZpc());
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.zzkO(html, null);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        zzZ7V zzZ7V2 = new zzZ7V();
        zzZ7V2.zz3l(useBuilderFormatting);
        zzZ7V2.zzXu8(useBuilderFormatting);
        this.zzkO(html, zzZ7V2);
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        return zzWg0.zzkO(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return zzWg0.zzkO(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzqw zzqw2 = new zzqw();
        return zzqw2.zzkO(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzX5U(this).zzkO(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzX5U(this).zzkO(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzZBA, 75);
        shape.zzkO(this.zzX2r());
        shape.zzZj4(true);
        shape.getSignatureLine().zzkO(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzZ4v(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzXiN(this.zzZBA);
        this.insertNode(shape);
        return shape;
    }

    private void zzkO(String string, zzZ7V zzZ7V2) throws Exception {
        if (this.zzPe()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(string);
            this.write(DocumentBuilder.zzZ8M(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzX34 zzX342 = zzWg0.zzkO(string, zzZ7V2, this);
        zzX342.zzXnh();
    }

    private boolean zzPe() {
        boolean bl = false;
        if (this.zzWFh().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzWFh().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzZ8M(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        if (this.zzXJb() == null) {
            this.startTable();
        }
        if (this.zzXJb().zzYpi() == 1) {
            this.zzXJb().zzZTO();
        }
        if (this.zzXJb().zzYpi() == 3) {
            this.zzXJb().zzXOG();
        }
        return this.zzXJb().zzDl();
    }

    public Table startTable() {
        this.zzZaQ.push(new zzY3v(this));
        return this.zzXJb().startTable();
    }

    public Table endTable() {
        if (this.zzXJb() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzXJb().endTable();
        this.zzZaQ.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzXJb() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzXJb().endRow();
        if (this.zzYSP != null && this.zzYSP.getHidden()) {
            row.zzWv3().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzZBA, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzZBA, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzZBA);
        this.zzZ9I = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzZ9I == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzZBA, this.zzZ9I);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzZBA, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzZlt.zzXsR((Object)importFormatOptions, "ImportFormatOptions");
        return zzeX.zzkO(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Document getDocument() {
        return this.zzZBA;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzZBA) {
            return;
        }
        this.zzZBA = value;
        this.zzYQf(null);
        this.zzQb = new zzZ1v();
        this.zzXh3 = null;
        this.zzYSP = null;
        this.zzZaQ = new zzX0N();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzYSP == null) {
            DocumentBuilder documentBuilder = this;
            this.zzYSP = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzYSP;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        return this.getCurrentParagraph().getParagraphFormat();
    }

    public ListFormat getListFormat() {
        return this.getCurrentParagraph().getListFormat();
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zz2f == null) {
            this.zz2f = new RowFormat(this);
        }
        return this.zz2f;
    }

    public CellFormat getCellFormat() {
        if (this.zzuD == null) {
            this.zzuD = new CellFormat(this);
        }
        return this.zzuD;
    }

    final void zzXh1(Node node) {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() {
        this.zzZWV().push(new zzkO(this.zzX2r(), (zzZ1v)this.getCurrentParagraph().zzwb().zzs2()));
    }

    public void popFont() {
        zzX0N<zzkO> zzX0N2 = this.zzZWV();
        if (zzX0N2.size() > 0) {
            zzkO zzkO2 = (zzkO)this.zzZWV().pop();
            this.zzkO(zzkO2.zzQg(), false);
            this.getCurrentParagraph().zzWBZ(zzkO2.zzWSE());
        }
    }

    final void zz6g() {
        this.zzZ4i().push(this.zzX2r());
    }

    final void zzbs() {
        zzX0N<zzZ1v> zzX0N2 = this.zzZ4i();
        if (zzX0N2.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzkO((zzZ1v)documentBuilder.zzZ4i().pop(), false);
        }
    }

    private zzyp zzXsR(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzZhY(88);
        zzXFe zzXFe2 = new zzXFe();
        zzXFe2.setTarget(string2);
        zzXFe2.setScreenTip(string3);
        if (bl) {
            zzXFe2.setSubAddress(string);
        } else {
            zzXFe2.setAddress(zzXWm.zzYtj(string));
            zzXFe2.setSubAddress(zzXWm.zzSE(string));
        }
        this.zzXAK(zzXFe2.toString());
        FieldSeparator fieldSeparator = this.zzSf(88);
        return new zzyp(fieldStart, fieldSeparator, null);
    }

    final zzyp zzX80(String string, String string2, String string3) {
        boolean bl = zzXWm.zzfL(string);
        String string4 = bl ? zzXWm.zzSE(string) : string;
        return this.zzXsR(string4, bl, string2, string3);
    }

    final FieldEnd zzW5I() {
        return this.zzXj(88, true);
    }

    final zzZ1v zzX2r() {
        return (zzZ1v)this.zzQb.zzs2();
    }

    final zzJi zzrp() {
        return (zzJi)this.getCurrentParagraph().zzkv().zzs2();
    }

    final zzho zz7W() {
        return (zzho)this.zzWv3().zzs2();
    }

    final zzWgg zzXNC() {
        return (zzWgg)this.zzrd().zzs2();
    }

    public boolean isAtStartOfParagraph() {
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzWFh(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzWFh().getNodeType() == 8;
    }

    private void zzVPg(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        String string2 = zzVSQ.zzY5p(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzZ7x(string2.substring(n4, n4 + n2));
                }
                switch (this.zzYAO) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzXie(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzZ7x(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    private Run zzXie(String string) {
        Run run = new Run(this.zzZBA, string, this.zzX2r());
        this.insertNode(run);
        return run;
    }

    public void insertNode(Node node) {
        if (this.zzXJb() != null && this.zzXJb().zzYpi() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        this.zzWFh().getParentNode().insertBefore(node, this.zzWFh());
    }

    final void zzPj(int n) {
        this.zz2s(true);
        this.zzWBq(n);
    }

    private void zzWBq(int n) {
        this.insertParagraph();
        zzYKJ zzYKJ2 = new zzYKJ(this.getDocument());
        try {
            zzZS7 zzZS72 = (zzZS7)this.getCurrentSection().zzJo().zzs2();
            Section section = new Section(this.zzZBA, zzZS72);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzZBA));
            this.zzZBA.insertAfter(section, this.getCurrentSection());
            section.getBody().zzXsR(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzYKJ2.dispose();
        }
    }

    final FieldStart zzZhY(int n) {
        return zzWg0.zzkO(n, this.zzX2r(), this.zzWFh(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final Run zzXAK(String string) {
        return zzWg0.zzXsR(string, this.zzX2r(), this.zzWFh(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final FieldEnd zzXj(int n, boolean bl) {
        return zzWg0.zzXsR(n, bl, this.zzX2r(), this.zzWFh(), this.getCurrentParagraph(), null, true);
    }

    final FieldSeparator zzSf(int n) {
        return zzWg0.zzXsR(n, this.zzX2r(), this.zzWFh(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    private FormField zzW5C(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzZBA, new zzXwE(), this.zzX2r());
        CompositeNode compositeNode = node == null ? this.getCurrentParagraph() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zz2s(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentParagraph().getParentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzXJb() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzZMI(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzZ7x(String string) {
        if (this.zzWQ8(string)) {
            zzGa zzGa2 = new zzGa(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzXnK zzXnK2 : zzGa2.zzWuP(this.getParagraphFormat().getBidi())) {
                zzVPg zzVPg2 = zzVPg.zzWFF(zzXnK2.zzYMc());
                zzZ1v zzZ1v2 = this.zzX2r();
                zzZ1v2.zzDH(265, zzVPg2);
                if (zzXnK2.zzZMN()) {
                    zzZ1v2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzZBA, zzXnK2.getText(), zzZ1v2);
                this.insertNode(run);
            }
            return;
        }
        this.zzXie(string);
    }

    private Shape zzkO(BufferedImage bufferedImage, boolean bl, zzWAX zzWAX2) throws Exception {
        if (bufferedImage != null) {
            return this.zzYT4(bufferedImage);
        }
        return this.zzZad(zzZcy.zzkO(zzWAX2, bl));
    }

    private Shape zzkO(String string, boolean bl, boolean bl2, BufferedImage bufferedImage, zzWAX zzWAX2) throws Exception {
        Shape shape = this.zzkO(bufferedImage, bl2, zzWAX2);
        zzWVd zzWVd2 = zzZcy.zzkO(string, bl, bl2, zzWAX2);
        return DocumentBuilder.zzkO(string, bl, shape, zzWAX2.zzYvs, zzWVd2);
    }

    private static Shape zzkO(String string, boolean bl, Shape shape, String string2, zzWVd zzWVd2) {
        shape.zzXR0(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzXsR(zzWVd2);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private boolean zzWQ8(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzPo.zzW17(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 3 || n == 4;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzkO(zzZ1v zzZ1v2, boolean bl) {
        this.zzQb = bl ? (zzZ1v)zzZ1v2.zzs2() : zzZ1v2;
    }

    final void zzXCu() {
        this.zzQb.clear();
    }

    final void zzW9n() {
        if (this.zzWhj() != null) {
            zzWgg zzWgg2 = this.zzWhj().zzrd();
            this.zzYBh = (zzWgg)zzWgg2.zzs2();
            zzWgg2.zzXsR(this.zzYBh);
        }
    }

    final boolean zzYh6() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final void zzW1v(int n) {
        this.zzYAO = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph()) {
            return null;
        }
        return this.zzWFh();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzWFh();
        }
        return (Paragraph)this.zzWFh().getAncestor(8);
    }

    public Story getCurrentStory() {
        return this.getCurrentParagraph().getParentStory();
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzY3v zzXJb() {
        zzX0N<zzY3v> zzX0N2 = this.zzZaQ;
        if (zzX0N2.size() > 0) {
            return (zzY3v)this.zzZaQ.peek();
        }
        return null;
    }

    private Cell zzWhj() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzXOu();
    }

    private zzX0N<zzZ1v> zzZ4i() {
        if (this.zzXh3 == null) {
            this.zzXh3 = new zzX0N();
        }
        return this.zzXh3;
    }

    private zzX0N<zzkO> zzZWV() {
        if (this.zzWbU == null) {
            this.zzWbU = new zzX0N();
        }
        return this.zzWbU;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzQb.zzWQ8(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzWuP(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzWuP(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzQb.zzDH(fontAttr, value);
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzYwr()) {
            this.getCurrentParagraph().zzwb().zzDH(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzQb.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzQb.clear();
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzYwr()) {
            this.getCurrentParagraph().zzwb().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzWv3().zzWQ8(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzWv3().zzHm(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzWv3().zzWU(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzWv3().zzDH(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzWv3().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzWv3().clear();
        zzho.zzZ3X().zzXsR(this.zzWv3());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzrd().zzWQ8(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzrd().zzHm(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzrd().zzWU(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzZlt.zzkO(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzWhj() != null ? this.zzWhj().getCellFormat() : this.getCellFormat();
            border.zzkO(cellFormat);
        }
        this.zzrd().zzDH(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzrd().clear();
    }

    private Node zzWFh() {
        Node node = this.zzXJu != null && this.zzXJu.getParentNode() == null ? this.zzZ9n : this.zzXJu;
        if (node != null && node.zzWhe() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        return node;
    }

    private void zzYQf(Node node) {
        this.zzXJu = node;
        if (this.zzXJu != null) {
            this.zzZ9n = this.zzXJu.getParentNode();
        }
    }

    private zzho zzWv3() {
        if (this.zzXJb() != null && this.zzXJb().zzYpi() == 1) {
            return this.zzXiM;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzWv3();
        }
        return this.zzXiM;
    }

    private zzWgg zzrd() {
        if (this.zzXJb() != null && this.zzXJb().zzYpi() != 3) {
            return this.zzYBh;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzXOu().zzrd();
        }
        return this.zzYBh;
    }

    static final class zzkO {
        private zzZ1v zzQb;
        private zzZ1v zzVR;

        public zzkO(zzZ1v zzZ1v2, zzZ1v zzZ1v3) {
            this.zzQb = zzZ1v2;
            this.zzVR = zzZ1v3;
        }

        public final zzZ1v zzQg() {
            return this.zzQb;
        }

        public final zzZ1v zzWSE() {
            return this.zzVR;
        }
    }
}

