/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zzGt;
import com.aspose.words.internal.zzYlR;
import com.aspose.words.internal.zzZ09;
import com.aspose.words.internal.zzZII;
import com.aspose.words.internal.zzZlp;
import com.aspose.words.internal.zzZlt;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzX9K;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzWfQ = new HashMap();
    private static HashMap<Integer, Integer> zzWoF = new HashMap();
    private static HashMap<Integer, Integer> zzX4r = new HashMap();
    private static HashMap<Integer, Integer> zzYIO = new HashMap();
    private static HashMap<Integer, Integer> zzXqf = new HashMap();
    private static HashMap<Integer, Integer> zzQI = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzZlt.zzkO(fileName, "fileName");
        try (zzZ09 zzZ092 = zzZlt.zzX80(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzZMP(zzZ092);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzZMP(zzZlp.zzkO(stream));
    }

    static FileFormatInfo zzZMP(zzGt zzGt2) throws Exception {
        if (zzGt2 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zzX9K zzX9K2 = new zzX9K();
            zzGt zzGt3 = zzGt2;
            zzX9K zzX9K3 = zzX9K2;
            return zzX9K2.zzXsR(zzGt3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzkO(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzZrp(zzYlR.zzZPg(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzYE(zzYlR.zzZPg(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzZII.zzZI3(string = zzYlR.zzIT(FileFormatUtil.zzVZ4(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzZrp(FileFormatUtil.zzGz(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzYE(FileFormatUtil.zzVZ4(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzYlR.zzIT(FileFormatUtil.zzGz(saveFormat));
        if (zzZII.zzZI3(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzYE(zzYlR.zzYlw(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzYlR.zzIT(FileFormatUtil.zzVP4(imageType));
    }

    static Exception zzkO(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzWiR(int n) {
        return zzYlR.toString(FileFormatUtil.zzGz(n));
    }

    static int zzYE(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzZlt.zzkO(zzXqf, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzZwi(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzZlt.zzkO(zzQI, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzVOF(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzVZ4(int n) {
        return zzZlt.zzkO(zzWfQ, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzGz(int n) {
        return zzZlt.zzkO(zzWoF, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzVP4(int n) {
        return zzZlt.zzkO(zzX4r, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzZrp(int n) {
        return zzZlt.zzkO(zzYIO, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzW57(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzZlt.zzXsR(zzXqf, Integer.valueOf(n), Integer.valueOf(n2));
            zzZlt.zzXsR(zzWoF, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzYIO.containsKey(n)) {
                zzZlt.zzXsR(zzYIO, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzZlt.zzXsR(zzWfQ, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzZlt.zzXsR(zzQI, Integer.valueOf(n), Integer.valueOf(n4));
            zzZlt.zzXsR(zzX4r, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzW57(11, 10, 10, 1);
        FileFormatUtil.zzW57(11, 0, 0, 1);
        FileFormatUtil.zzW57(12, 11, 11, 1);
        FileFormatUtil.zzW57(13, 20, 20, 1);
        FileFormatUtil.zzW57(13, 0, 254, 1);
        FileFormatUtil.zzW57(14, 21, 21, 1);
        FileFormatUtil.zzW57(15, 22, 22, 1);
        FileFormatUtil.zzW57(16, 23, 23, 1);
        FileFormatUtil.zzW57(18, 24, 24, 1);
        FileFormatUtil.zzW57(19, 25, 25, 1);
        FileFormatUtil.zzW57(20, 26, 26, 1);
        FileFormatUtil.zzW57(21, 27, 27, 1);
        FileFormatUtil.zzW57(24, 30, 30, 1);
        FileFormatUtil.zzW57(17, 31, 31, 1);
        FileFormatUtil.zzW57(25, 50, 50, 1);
        FileFormatUtil.zzW57(26, 45, 255, 1);
        FileFormatUtil.zzW57(27, 51, 51, 1);
        FileFormatUtil.zzW57(28, 0, 52, 1);
        FileFormatUtil.zzW57(22, 60, 60, 1);
        FileFormatUtil.zzW57(23, 61, 61, 1);
        FileFormatUtil.zzW57(32, 40, 255, 1);
        FileFormatUtil.zzW57(39, 47, 255, 1);
        FileFormatUtil.zzW57(40, 48, 255, 1);
        FileFormatUtil.zzW57(33, 41, 255, 1);
        FileFormatUtil.zzW57(34, 46, 255, 1);
        FileFormatUtil.zzW57(36, 42, 255, 1);
        FileFormatUtil.zzW57(35, 44, 255, 1);
        FileFormatUtil.zzW57(29, 52, 255, 1);
        FileFormatUtil.zzW57(30, 70, 62, 1);
        FileFormatUtil.zzW57(31, 73, 63, 1);
        FileFormatUtil.zzW57(37, 71, 255, 1);
        FileFormatUtil.zzW57(8, 100, 255, 1);
        FileFormatUtil.zzW57(9, 105, 255, 1);
        FileFormatUtil.zzW57(6, 101, 255, 6);
        FileFormatUtil.zzW57(7, 102, 255, 7);
        FileFormatUtil.zzW57(5, 104, 255, 5);
        FileFormatUtil.zzW57(4, 0, 255, 4);
        FileFormatUtil.zzW57(3, 0, 255, 3);
        FileFormatUtil.zzW57(38, 72, 255, 1);
        FileFormatUtil.zzW57(2, 103, 255, 2);
    }
}

