/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzX0N;
import com.aspose.words.internal.zzX7n;
import com.aspose.words.internal.zzZlt;
import com.aspose.words.zzWg0;
import com.aspose.words.zzYHa;
import com.aspose.words.zzYaI;
import com.aspose.words.zzYfH;

public abstract class Node
implements Cloneable {
    private Node zzXsy;
    private Node zzX27;
    private Node zzHk;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this.zzXsR(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzXsy == null) {
            return null;
        }
        if (this.zzXsy.getNodeType() == 36) {
            return null;
        }
        return (CompositeNode)this.zzXsy;
    }

    final CompositeNode zzZm4() {
        if (zzWg0.zzZFz(this.getParentNode())) {
            return this.getParentNode().zzZm4();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this.zzXsy != null) {
            return this.zzXsy.getDocument();
        }
        return null;
    }

    final Document zzaE() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzZNr() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zzZlK();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzHk;
    }

    final Node zzXmq() {
        Node node = this;
        while ((node = node.getPreviousSibling()) != null && zzWg0.zzXiN(node)) {
        }
        return node;
    }

    final Node zzWvM() {
        Node node = zzWg0.zzYl7(this.getPreviousSibling(), false);
        if (node == null && zzWg0.zzZFz(this.getParentNode())) {
            node = this.getParentNode().zzWvM();
        }
        return node;
    }

    final Node zzYCa() {
        Node node = zzWg0.zzZNa(this.getNextSibling(), false);
        if (node == null && zzWg0.zzZFz(this.getParentNode())) {
            node = this.getParentNode().zzYCa();
        }
        return node;
    }

    final CompositeNode zzZy8() {
        Node node = this;
        while ((node = node.zzWvM()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzVQk() {
        Node node = this;
        while ((node = node.zzYCa()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzX27;
    }

    final Node zzYnu() {
        Node node = this;
        while ((node = node.getNextSibling()) != null && zzWg0.zzXiN(node)) {
        }
        return node;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzWgv() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getLastChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzWQ3() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getFirstChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzYYv() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzWg0.zzZfm(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzKI() {
        return this.zzX27;
    }

    final void zzeF(Node node) {
        this.zzX27 = node;
    }

    final Node zzX5M() {
        return this.zzHk;
    }

    final void zznC(Node node) {
        this.zzHk = node;
    }

    final Node zzYCS() {
        Node node = this;
        if (node.zzX27 != null) {
            node = this;
            return node.zzX27;
        }
        return this.getParentNode();
    }

    final int zzWhe() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zzWg0.zzXwL(this);
        boolean bl2 = zzWg0.zzWqV(this);
        boolean bl3 = zzWg0.zzWig(this);
        boolean bl4 = zzWg0.zzfI(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzWhe() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 36;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzWhe() != 3 && n2 != 6 && n != 27 && n != 33)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzkO(isCloneChildren, null);
    }

    Node zzkO(boolean bl, zzYHa zzYHa2) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzXsy != null) {
            node.zzXsy = this.getDocument().zzZqI();
        }
        node.zzX27 = null;
        node.zzHk = null;
        if (zzYHa2 != null) {
            zzYHa2.zzqD(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzW57(StringBuilder stringBuilder) {
        zzZlt.zzXsR(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isInstance(compositeNode)) continue;
            return compositeNode;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzZxJ(Node node) {
        this.zzXsy = node != null ? node : this.getDocument().zzZqI();
    }

    final void zzXsR(DocumentBase documentBase) {
        this.zzXsy = documentBase != null ? documentBase.zzZqI() : null;
    }

    final boolean zzON(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzXzN() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzWW3(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzX0n(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzfS(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzZKQ(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    public String toString(int saveFormat) throws Exception {
        zzYfH zzYfH2 = zzWg0.zzYbM(saveFormat);
        return zzYfH2.zzXRR(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzYfH zzYfH2 = zzWg0.zzkO(saveOptions);
        return zzYfH2.zzXRR(this);
    }

    final Node zzJR(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzWg0.zzWIn(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zzYaI zzwF() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zzYaI.zzWAz(node);
        }
        return zzYaI.zzWy4(this.getParentNode());
    }

    final zzYaI zzo7() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zzYaI.zzWy4(node);
        }
        return zzYaI.zzWAz(this.getParentNode());
    }

    final boolean zzZeD(Node node) {
        return Node.zzYEH(this, node);
    }

    final boolean zzXtA() {
        return this.getAncestor(1) == null;
    }

    static Node zzZ0B(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zzX0N<Node> zzX0N2 = Node.zz1z(node);
        zzX0N<Node> zzX0N3 = Node.zz1z(node2);
        return Node.zzkO(zzX0N2, zzX0N3);
    }

    static boolean zzYEH(Node node, Node node2) {
        zzX0N<Node> zzX0N2;
        if (node == null || node2 == null) {
            return false;
        }
        zzX0N<Node> zzX0N3 = Node.zz1z(node);
        Node node3 = Node.zzkO(zzX0N3, zzX0N2 = Node.zz1z(node2));
        if (node3 == null) {
            return false;
        }
        zzX0N<Node> zzX0N4 = zzX0N3;
        if (zzX0N4.size() == 0 || (zzX0N4 = zzX0N2).size() == 0) {
            zzX0N4 = zzX0N2;
            boolean bl = zzX0N4.size() > 0;
            return bl;
        }
        Object e = zzX0N3.peek();
        Object e2 = zzX0N2.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes()) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zzX0N<Node> zz1z(Node node) {
        zzX0N<Node> zzX0N2 = new zzX0N<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzX0N2.push(node2);
        }
        return zzX0N2;
    }

    private static Node zzkO(zzX0N<Node> zzX0N2, zzX0N<Node> zzX0N3) {
        Node node = null;
        while (zzX0N2.peek() == zzX0N3.peek()) {
            node = (Node)zzX0N2.pop();
            zzX0N3.pop();
            zzX0N<Node> zzX0N4 = zzX0N2;
            if (zzX0N4.size() != 0 && (zzX0N4 = zzX0N3).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "GlossaryDocument";
            }
            case 30: {
                return "BuildingBlock";
            }
            case 31: {
                return "CommentRangeStart";
            }
            case 32: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 33: {
                return "OfficeMath";
            }
            case 34: {
                return "SubDocument";
            }
            case 35: {
                return "System";
            }
            case 36: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    private String zzX3X() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node = this; node != null && node.getParentNode() != null; node = node.getParentNode()) {
            int n = 0;
            for (Node node2 = node.getParentNode().getFirstChild(); node2 != null && node2 != node; node2 = node2.getNextSibling()) {
                ++n;
            }
            zzZlt.zzkO(stringBuilder, "{0}{1}", node == this ? "" : ".", n);
        }
        return zzX7n.zzWAP(stringBuilder.toString());
    }

    public String toString() {
        return zzX7n.zzWAP(zzX7n.zzXsR("{0} {1}", Node.nodeTypeToString(this.getNodeType()), this.zzX3X()));
    }

    public void dd() {
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }
}

