/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzZlt;
import com.aspose.words.ref.Ref;
import com.aspose.words.zzVWB;
import com.aspose.words.zzWhW;
import com.aspose.words.zzZ90;
import com.aspose.words.zzZG7;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzWhW,
Iterable<T> {
    private CompositeNode zzW9W;
    private DocumentBase zzXTs;
    private boolean zzXTB;
    private int zzYoz;
    private int zzXKY;
    private Node zzXee;
    private int zzZ4v;
    private zzZG7 zzWuW;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, new zzZ90(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzZ90(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzZG7 matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("container");
        }
        if (matcher == null) {
            throw new NullPointerException("matcher");
        }
        this.zzW9W = container;
        this.zzXTs = container.getDocument();
        this.zzWuW = matcher;
        this.zzXTB = isDeep;
        this.zzWp6();
    }

    public Node get(int index) {
        try {
            this.zzZfN();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzXKY == index) {
                return this.zzXee;
            }
            int n = index - this.zzXKY;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zzWBZ(nodeCollection.zzXee, n);
            if (node != null) {
                this.zzXKY = index;
                this.zzXee = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzXTB) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzW9W.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzXTB) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzW9W.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzXu7();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzVWB(this);
    }

    final <TNode extends Node> zzVWB<TNode> zzoV() {
        return new zzVWB(this);
    }

    final <TValue extends Node> ArrayList<TValue> zzXu7() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzZlt.zzkO(arrayList, node);
        }
        return arrayList;
    }

    private Node zzWBZ(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            Ref<Node> ref = new Ref<Node>(node2);
            this.zzkO(ref, bl);
            node2 = ref.get();
            if (node2 != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Ref<Node> curNode) throws Exception {
        return this.zzkO(curNode, true);
    }

    private Node zzkO(Ref<Node> ref, boolean bl) throws Exception {
        Node node;
        ref.get();
        do {
            node = ref.get();
            ref.set(this.zzXTB ? this.zzkO(bl, ref.get()) : (this.zzWuW.zzYB0() ? this.zzm6(bl, ref.get()) : this.zzXsR(bl, ref.get())));
        } while (ref.get() != null && !this.zzWuW.zzWBZ(ref.get()));
        return node;
    }

    private Node zzkO(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzW9W);
        }
        return node.previousPreOrder(this.zzW9W);
    }

    private Node zzXsR(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzW9W) {
                return this.zzW9W.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzW9W) {
            return this.zzW9W.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zzm6(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzW9W ? this.zzW9W.zzny() : node.zzYCa();
        } else {
            Node node3 = node2 = node == this.zzW9W ? this.zzW9W.zzYhv() : node.zzWvM();
        }
        if (node2 == this.zzW9W.getNextSibling() || node2 == this.zzW9W.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzZfN() {
        if (this.zzYoz != this.zzZsz()) {
            this.zzWp6();
        }
    }

    private void zzWp6() {
        this.zzYoz = this.zzZsz();
        this.zzXKY = -1;
        this.zzXee = this.zzW9W;
        this.zzZ4v = -1;
    }

    private int zzZsz() {
        if (this.zzXTs != null) {
            return this.zzXTs.zzZkC();
        }
        return 0;
    }

    public int getCount() {
        this.zzZfN();
        if (this.zzZ4v == -1) {
            this.zzZ4v = zzVWB.zzkO(this);
        }
        return this.zzZ4v;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzW9W;
    }
}

