/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzX6p;
import com.aspose.words.internal.zzX7V;
import com.aspose.words.internal.zzY4l;
import com.aspose.words.internal.zzYln;
import com.aspose.words.internal.zzYmI;
import com.aspose.words.internal.zzYqb;
import com.aspose.words.internal.zzYt9;
import com.aspose.words.internal.zzZNC;
import com.aspose.words.internal.zzgd;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzXw6
extends CertPathBuilderSpi {
    private final zzY4l zzYmG;
    private zzgd zzWav;

    zzXw6(zzY4l zzY4l2) {
        this.zzYmG = zzY4l2;
    }

    @Override
    public final CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        zzZNC pkixParams;
        if (params instanceof zzZNC) {
            pkixParams = (zzZNC)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new zzZNC.zzkO((PKIXBuilderParameters)params).zzYNf();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + zzZNC.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        zzYln zzYln2 = pkixParams.zzZIp().zzZOB();
        try {
            collection = zzYqb.zzkO(zzYln2, pkixParams.zzZIp().zzZu7());
            collection.addAll(zzYqb.zzkO(zzYln2, pkixParams.zzZIp().zzQY()));
        }
        catch (zzgd zzgd2) {
            throw new CertPathBuilderException("Error finding target certificate.", zzgd2);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.zzkO(x509Certificate, pkixParams, arrayList);
        }
        if (certPathBuilderResult == null && this.zzWav != null) {
            throw new CertPathBuilderException(this.zzWav.getMessage(), this.zzWav.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult zzkO(X509Certificate x509Certificate, zzZNC zzZNC2, List list) throws CertPathBuilderException {
        zzX6p zzX6p2;
        zzX7V zzX7V2;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (zzZNC2.zzXxC().contains(x509Certificate)) {
            return null;
        }
        if (zzZNC2.zzZV8() != -1 && list.size() - 1 > zzZNC2.zzZV8()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            zzX7V2 = new zzX7V(this.zzYmG);
            zzX6p2 = new zzX6p(this.zzYmG);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (zzYqb.zzkO(x509Certificate, zzZNC2.zzZIp().zzH4(), zzZNC2.zzZIp().zzY0u()) != null) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = zzX7V2.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new zzgd("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)zzX6p2.engineValidate(certPath, zzZNC2);
                }
                catch (Exception exception) {
                    throw new zzgd("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<zzYt9> arrayList = new ArrayList<zzYt9>();
            arrayList.addAll(zzZNC2.zzZIp().zzZu7());
            try {
                arrayList.addAll(zzYqb.zzkO(x509Certificate.getExtensionValue(zzYmI.zzYfg.getId()), zzZNC2.zzZIp().zzWoL()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new zzgd("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(zzYqb.zzkO(x509Certificate, zzZNC2.zzZIp().zzQY(), arrayList));
            }
            catch (zzgd zzgd2) {
                throw new zzgd("Cannot find issuer certificate for certificate in certification path.", zzgd2);
            }
            if (hashSet.isEmpty()) {
                throw new zzgd("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.zzkO(x509Certificate2, zzZNC2, list);
            }
        }
        catch (zzgd zzgd3) {
            this.zzWav = zzgd3;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

