/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzX7n;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzYRC = new ArrayList();
    private final Map<String, DataColumn> zzJN = new HashMap<String, DataColumn>();
    private DataTable zzWTz;

    DataColumnCollection(DataTable table) {
        this.zzWTz = table;
    }

    public void add(DataColumn column) {
        if (zzX7n.zzTB(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzWBZ(column.getColumnName());
        if (this.zzJN.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzXsR(this.zzWTz);
        column.setOrdinal(this.zzYRC.size());
        this.zzYRC.add(column);
        this.zzJN.put(string, column);
        this.zzWTz.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzWTz);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzX7n.zzTB(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzWBZ(columnName);
        DataColumn dataColumn = this.zzJN.get(string);
        if (dataColumn != null) {
            int n = this.zzYRC.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzYRC.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzYRC.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzYRC.remove(n);
            this.zzJN.remove(DataColumnCollection.zzWBZ(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzWTz.getRows()) {
                dataRow.remove(n);
            }
            this.zzWTz.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzYRC.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzYRC.iterator();
    }

    public void clear() {
        this.zzJN.clear();
        this.zzYRC.clear();
    }

    final DataColumn[] zzVYh() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzYRC);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzkO(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzYRC.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzYRC.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzWBZ(string);
            String string3 = DataColumnCollection.zzWBZ(dataColumn.getColumnName());
            this.zzJN.remove(string3);
            this.zzJN.put(string2, dataColumn);
            return;
        }
    }

    private static String zzWBZ(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

