/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzM5;
import com.aspose.words.net.System.Data.zzXsR;
import com.aspose.words.net.System.Data.zzm6;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzWsh;
    private final DataColumnCollection zzY3t;
    private final ConstraintCollection zzXvi;
    private final zzM5 zzYpX;
    private ResultSet zzXNT;
    private String zzol;
    private DataSet zzYZ2;
    private String zzAY;
    private UniqueConstraint zzX2Y;
    private boolean zzZiH;
    private final List<DataTableEventListener> zzXE5;
    private final Set<DataRow> zzr1;

    public DataTable() {
        this.zzWsh = new DataRowCollection(this);
        this.zzY3t = new DataColumnCollection(this);
        this.zzXvi = new ConstraintCollection(this);
        this.zzYpX = new zzM5(this);
        this.zzAY = "";
        this.zzZiH = true;
        this.zzXE5 = new ArrayList<DataTableEventListener>();
        this.zzr1 = new HashSet<DataRow>();
    }

    public DataTable(String tableName) {
        this.zzWsh = new DataRowCollection(this);
        this.zzY3t = new DataColumnCollection(this);
        this.zzXvi = new ConstraintCollection(this);
        this.zzYpX = new zzM5(this);
        this.zzAY = "";
        this.zzZiH = true;
        this.zzXE5 = new ArrayList<DataTableEventListener>();
        this.zzr1 = new HashSet<DataRow>();
        this.zzol = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzXsR.zzkO(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzWsh = new DataRowCollection(this);
        this.zzY3t = new DataColumnCollection(this);
        this.zzXvi = new ConstraintCollection(this);
        this.zzYpX = new zzM5(this);
        this.zzAY = "";
        this.zzZiH = true;
        this.zzXE5 = new ArrayList<DataTableEventListener>();
        this.zzr1 = new HashSet<DataRow>();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzXNT = resultSet;
        this.zzol = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzXNT != null) {
            if (this.zzXNT.getStatement() != null) {
                this.zzXNT.getStatement().getConnection().close();
            }
            this.zzXNT = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzol;
    }

    public void setTableName(String tableName) {
        this.zzol = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzY3t.getCount();
    }

    public String getColumnName(int index) {
        return this.zzY3t.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzXNT;
    }

    public DataSet getDataSet() {
        return this.zzYZ2;
    }

    final void zzXsR(DataSet dataSet) {
        this.zzYZ2 = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzYZ2.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzYZ2.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzWsh;
    }

    public DataColumnCollection getColumns() {
        return this.zzY3t;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzXvi;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzX2Y == null) {
            return new DataColumn[0];
        }
        return this.zzX2Y.getColumns();
    }

    final void zzM5(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzX2Y != null) {
                this.zzX2Y.zzZoE(false);
                this.getConstraints().remove(this.zzX2Y);
                this.zzX2Y = null;
            }
            return;
        }
        if (this.zzX2Y != null && DataColumn.areColumnSetsTheSame(value, this.zzX2Y.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzkO(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzX2Y != null) {
            this.zzX2Y.zzZoE(false);
            this.getConstraints().remove(this.zzX2Y);
            this.zzX2Y = null;
        }
        UniqueConstraint.zzkO(this.getConstraints(), uniqueConstraint);
        this.zzX2Y = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzAY;
    }

    public void setNamespace(String namespace) {
        this.zzAY = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzZiH;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzZiH = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzr1.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzXsR.zzkO(this.getResultSet(), this);
            zzXsR.zzXsR(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            sQLException.printStackTrace();
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzXsR.zzm6(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzXE5.contains(listener)) {
            this.zzXE5.add(listener);
        }
    }

    public void removeEventListener(zzm6 listener) {
        if (this.zzXE5.contains(listener)) {
            this.zzXE5.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzXE5.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzr1.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXE5) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzr1.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXE5) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzr1.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXE5) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzXE5) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzXE5) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzM5 zzZYk() {
        return this.zzYpX;
    }

    final Set<DataRow> zz5O() {
        return this.zzr1;
    }
}

