/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zzEE;
import com.aspose.words.internal.zzWA0;
import com.aspose.words.internal.zzWmf;
import com.aspose.words.internal.zzWt9;
import com.aspose.words.internal.zzYkh;
import com.aspose.words.internal.zzYqK;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzqU;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzWLw = new HashMap();
    private static HashMap<Integer, Integer> zzVY8 = new HashMap();
    private static HashMap<Integer, Integer> zz7I = new HashMap();
    private static HashMap<Integer, Integer> zzXuw = new HashMap();
    private static HashMap<Integer, Integer> zzZRC = new HashMap();
    private static HashMap<Integer, Integer> zzZvN = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzYkh.zzzD(fileName, "fileName");
        zzWA0 zzWA02 = zzYkh.zzZO5(fileName);
        try {
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzZoq(zzWA02);
            return fileFormatInfo;
        }
        finally {
            ((zzEE)zzWA02).close();
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzZoq(zzYqK.zzab(stream));
    }

    static FileFormatInfo zzZoq(zzEE zzEE2) throws Exception {
        if (zzEE2 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zzqU zzqU2 = new zzqU();
            zzEE zzEE3 = zzEE2;
            zzqU zzqU3 = zzqU2;
            return zzqU2.zzYCO(zzEE3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzzD(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzXzb(zzWt9.zzXSS(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzYSh(zzWt9.zzXSS(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzWmf.zzZCw(string = zzWt9.zzaW(FileFormatUtil.zzZ9X(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzXzb(FileFormatUtil.zzBW(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzYSh(FileFormatUtil.zzZ9X(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzWt9.zzaW(FileFormatUtil.zzBW(saveFormat));
        if (zzWmf.zzZCw(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzYSh(zzWt9.zzWNs(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzWt9.zzaW(FileFormatUtil.zzYDc(imageType));
    }

    static Exception zzzD(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzGI(int n) {
        return zzWt9.toString(FileFormatUtil.zzBW(n));
    }

    static int zzYSh(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzYkh.zzab(zzZRC, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzWZA(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzYkh.zzab(zzZvN, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzYbt(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzZ9X(int n) {
        return zzYkh.zzab(zzWLw, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzBW(int n) {
        return zzYkh.zzab(zzVY8, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzYDc(int n) {
        return zzYkh.zzab(zz7I, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzXzb(int n) {
        return zzYkh.zzab(zzXuw, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzWl3(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzYkh.zzYCO(zzZRC, Integer.valueOf(n), Integer.valueOf(n2));
            zzYkh.zzYCO(zzVY8, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzXuw.containsKey(n)) {
                zzYkh.zzYCO(zzXuw, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzYkh.zzYCO(zzWLw, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzYkh.zzYCO(zzZvN, Integer.valueOf(n), Integer.valueOf(n4));
            zzYkh.zzYCO(zz7I, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzWl3(11, 10, 10, 1);
        FileFormatUtil.zzWl3(11, 0, 0, 1);
        FileFormatUtil.zzWl3(12, 11, 11, 1);
        FileFormatUtil.zzWl3(13, 20, 20, 1);
        FileFormatUtil.zzWl3(13, 0, 254, 1);
        FileFormatUtil.zzWl3(14, 21, 21, 1);
        FileFormatUtil.zzWl3(15, 22, 22, 1);
        FileFormatUtil.zzWl3(16, 23, 23, 1);
        FileFormatUtil.zzWl3(18, 24, 24, 1);
        FileFormatUtil.zzWl3(19, 25, 25, 1);
        FileFormatUtil.zzWl3(20, 26, 26, 1);
        FileFormatUtil.zzWl3(21, 27, 27, 1);
        FileFormatUtil.zzWl3(24, 30, 30, 1);
        FileFormatUtil.zzWl3(17, 31, 31, 1);
        FileFormatUtil.zzWl3(25, 50, 50, 1);
        FileFormatUtil.zzWl3(26, 45, 255, 1);
        FileFormatUtil.zzWl3(27, 51, 51, 1);
        FileFormatUtil.zzWl3(28, 0, 52, 1);
        FileFormatUtil.zzWl3(29, 0, 53, 1);
        FileFormatUtil.zzWl3(31, 53, 54, 1);
        FileFormatUtil.zzWl3(22, 60, 60, 1);
        FileFormatUtil.zzWl3(23, 61, 61, 1);
        FileFormatUtil.zzWl3(34, 40, 64, 1);
        FileFormatUtil.zzWl3(41, 47, 255, 1);
        FileFormatUtil.zzWl3(42, 48, 255, 1);
        FileFormatUtil.zzWl3(35, 41, 255, 1);
        FileFormatUtil.zzWl3(36, 46, 255, 1);
        FileFormatUtil.zzWl3(38, 42, 255, 1);
        FileFormatUtil.zzWl3(37, 44, 255, 1);
        FileFormatUtil.zzWl3(30, 52, 55, 1);
        FileFormatUtil.zzWl3(32, 70, 62, 1);
        FileFormatUtil.zzWl3(33, 73, 63, 1);
        FileFormatUtil.zzWl3(39, 71, 255, 1);
        FileFormatUtil.zzWl3(8, 100, 255, 1);
        FileFormatUtil.zzWl3(9, 105, 255, 1);
        FileFormatUtil.zzWl3(6, 101, 255, 6);
        FileFormatUtil.zzWl3(7, 102, 255, 7);
        FileFormatUtil.zzWl3(5, 104, 255, 5);
        FileFormatUtil.zzWl3(4, 0, 255, 4);
        FileFormatUtil.zzWl3(3, 0, 255, 3);
        FileFormatUtil.zzWl3(40, 72, 255, 1);
        FileFormatUtil.zzWl3(2, 103, 255, 2);
    }
}

