/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zzW1I;
import com.aspose.words.internal.zzWaf;
import com.aspose.words.internal.zzWmf;
import com.aspose.words.internal.zzYYB;
import com.aspose.words.internal.zzYbu;
import com.aspose.words.internal.zzYkh;
import com.aspose.words.internal.zzYxu;
import com.aspose.words.zzY0r;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzYXQ;
    private zzY0r zzW1D;

    Watermark(Document doc, zzY0r watermarkProvider) {
        this.zzYXQ = doc;
        this.zzW1D = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzWzw(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzab(text, textWatermarkOptions, this.zzYXQ);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzYkh.zzYCO((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzYXQ, 75);
        shape.getImageData().setImage(image);
        this.zzab(shape, options, this.zzYXQ);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzYkh.zzYCO((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzYXQ, 75);
        shape.getImageData().setImage(imagePath);
        this.zzab(shape, options, this.zzYXQ);
    }

    public final int getType() {
        Shape shape = this.zzW1D.get();
        if (shape == null) {
            return 2;
        }
        shape.zzZ3Z();
        if (shape.zz2Q()) {
            return 0;
        }
        if (shape.zzXup()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzW1D.add(shape);
    }

    public final void remove() {
        this.zzW1D.remove();
    }

    private static void zzWzw(String string) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (zzWmf.zzQe(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzYkh.zzab(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzab(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzYCO(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzjS(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzYCO(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzjQ() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzWSp()) / d2) > (double)(f = pageSetup.zzAt())) {
            d = (double)f / d3;
        }
        shape.zzZ9g(zzWaf.zzzD(d2 * d, 2, zzYYB.zzZgH));
        shape.zzYE8(zzWaf.zzzD(d3 * d, 2, zzYYB.zzZgH));
    }

    private Shape zzab(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzab(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzjS(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzab(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzXhn() ? 1.0f : textWatermarkOptions.getFontSize();
        zzYbu zzYbu2 = document.zzXDv().zzzD(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzYbu2.zzZ8l(shape.getTextPath().getText());
        if (textWatermarkOptions.zzXhn()) {
            l = Watermark.zzab(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzZ9g(zzWaf.zzzD(Float.intBitsToFloat(n), 2, zzYYB.zzZgH));
        shape.zzYE8(zzWaf.zzzD(zzYxu.zzY11(l), 2, zzYYB.zzZgH));
    }

    private static long zzab(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzWSp();
        float f2 = pageSetup.zzAt();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzYxu.zzY11(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzYxu.zzZNT(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzYxu.zzY11(l) >= Float.intBitsToFloat(n)) {
            return zzYxu.zzZNT(f2 / f3, f2);
        }
        float f6 = f;
        return zzYxu.zzZNT(f6, f6 * f3);
    }

    private static void zzjS(Shape shape, String string) {
        shape.setName(zzW1I.zzYCO("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
        shape.setBehindText(true);
    }
}

