/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartDataPointCollection;
import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzY7U;
import com.aspose.words.zzBe;
import com.aspose.words.zzW0K;
import com.aspose.words.zzWEl;
import com.aspose.words.zzWIK;
import com.aspose.words.zzWhc;
import com.aspose.words.zzX1J;
import com.aspose.words.zzXBJ;
import com.aspose.words.zzYI5;
import com.aspose.words.zzZ46;
import com.aspose.words.zzZwb;
import com.aspose.words.zzkX;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzW0K zzWjc;

    ChartSeriesCollection(zzW0K chartSpace) {
        this.zzWjc = chartSpace;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzYzy().zzWU9().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzYzy().zzWU9().iterator();
    }

    public void removeAt(int index) {
        this.zzYzy().zzZji(index);
    }

    public void clear() {
        this.zzYzy().zzZFQ();
        for (zzWIK zzWIK2 : this.zzWjc.zzW08()) {
            zzWIK2.zzYaw(false);
        }
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZkx(chartSeriesCollection.zzYzy().zzW2e(), seriesName, categories, values);
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZkx(chartSeriesCollection.zzYzy().zzW2e(), seriesName, xValues, yValues);
    }

    private ChartSeries zzZkx(String string, zzY7U[] zzY7UArray, double[] dArray) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZkx(chartSeriesCollection.zzYzy().zzW2e(), string, zzY7UArray, dArray);
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzZkx(seriesName, zzY7U.zzZkx(dates), values);
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZkx(chartSeriesCollection.zzYzy().zzW2e(), seriesName, xValues, yValues, bubbleSizes);
    }

    final ChartSeries zzZkx(zzWIK zzWIK2, String string, String[] stringArray, double[] dArray) {
        if (stringArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (stringArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (stringArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzZkx(zzWIK2, string, dArray);
        chartSeries.zzXZo().zzLK(ChartSeriesCollection.zzZ7q(stringArray));
        return chartSeries;
    }

    final ChartSeries zzZkx(zzWIK zzWIK2, String string, double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (dArray.length <= 0 || dArray2.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzZkx(zzWIK2, string, dArray2);
        chartSeries.zzXZo().zzLK(ChartSeriesCollection.zzWiY(dArray));
        return chartSeries;
    }

    private ChartSeries zzZkx(zzWIK zzWIK2, String string, zzY7U[] zzY7UArray, double[] dArray) {
        if (zzY7UArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzY7UArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzY7UArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzZkx(zzWIK2, string, dArray);
        chartSeries.zzXZo().zzLK(ChartSeriesCollection.zzZkx(zzY7UArray));
        if (!zzWIK2.zzZoO()) {
            zzWIK2.zzYaw(true);
        }
        return chartSeries;
    }

    final ChartSeries zzZkx(zzWIK zzWIK2, String string, double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray == null || dArray2 == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (dArray.length <= 0 || dArray2.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (zzWIK2.zzcK() != 15) {
            zzWIK2.zzYnZ(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzZkx(zzWIK2, string, dArray2);
        chartSeries.zzdJ().zzXI1().zzZ7q(3, chartSeries.zzXqy().zzWR9());
        chartSeries.zzXZo().zzLK(ChartSeriesCollection.zzWiY(dArray));
        if (dArray3 != null) {
            chartSeries.zzn6().zzLK(ChartSeriesCollection.zzWiY(dArray3));
        }
        return chartSeries;
    }

    private ChartSeries zzZkx(zzWIK zzWIK2, String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(zzWIK2);
        chartSeries.setName(string);
        ChartSeriesCollection.zzZ25(chartSeries);
        chartSeries.zzY4T().zzLK(ChartSeriesCollection.zzWiY(dArray));
        this.zzWjc.zzXjY();
        this.zzYzy().zzjm(chartSeries);
        return chartSeries;
    }

    private static void zzZ25(ChartSeries chartSeries) {
        chartSeries.zzdJ().zzXI1().zzZ7q(5, new zzZ46());
        if (ChartDataPointCollection.zzb3(chartSeries.zzXqy().zzcK())) {
            chartSeries.setInvertIfNegative(false);
        }
        switch (chartSeries.zzXqy().zzcK()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzZkx(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzZkx(chartSeries, 5);
                ChartSeriesCollection.zzX7g(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzZkx(chartSeries, 1);
                ChartSeriesCollection.zzX7g(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzY0W(chartSeries);
            }
        }
    }

    private static void zzY0W(ChartSeries chartSeries) {
        zzZ46 zzZ462 = new zzZ46();
        zzZ462.setOutline(new zzBe());
        zzZwb zzZwb2 = new zzZwb();
        zzZwb2.zzYLm(1);
        zzZ462.getOutline().setFill(new zzYI5(zzZwb2));
        zzZ462.getOutline().zzXOx(19050.0);
        chartSeries.zzdJ().zzXI1().zzZ7q(5, zzZ462);
    }

    private static void zzX7g(ChartSeries chartSeries) {
        zzZ46 zzZ462 = new zzZ46();
        zzZ462.setOutline(new zzBe());
        zzZ462.getOutline().setFill(new zzX1J());
        zzZ462.getOutline().setEndCap(0);
        zzZ462.getOutline().zzXOx(19050.0);
        chartSeries.zzdJ().zzXI1().zzZ7q(5, zzZ462);
    }

    private static void zzZkx(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker(chartSeries.zzXqy());
        chartMarker.zzXwX().zzZ7q(0, n);
        chartSeries.zzdJ().zzXI1().zzZ7q(4, chartMarker);
    }

    private static zzWEl zzWiY(double[] dArray) {
        int n = 0;
        zzWEl zzWEl2 = new zzWEl(2);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzWEl2.zzWvh(new zzWhc(n, d, "General"));
            }
            ++n;
        }
        zzWEl2.zzZ46(dArray.length);
        return zzWEl2;
    }

    private static zzWEl zzZkx(zzY7U[] zzY7UArray) {
        int n = 0;
        zzWEl zzWEl2 = new zzWEl(2);
        zzY7U[] zzY7UArray2 = zzY7UArray;
        int n2 = zzY7UArray.length;
        for (int i = 0; i < n2; ++i) {
            zzY7U zzY7U2 = zzY7UArray2[i];
            zzWEl2.zzWvh(new zzWhc(n++, zzY7U2.zzY6n(), "m/d/yyyy"));
        }
        zzWEl2.zzZ46(zzY7UArray.length);
        return zzWEl2;
    }

    private static zzWEl zzZ7q(String[] stringArray) {
        int n = 0;
        zzWEl zzWEl2 = new zzWEl(1);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzWEl2.zzWvh(new zzXBJ(n++, string));
        }
        zzWEl2.zzZ46(stringArray.length);
        return zzWEl2;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzYzy().zzWU9().size();
    }

    private zzkX zzYzy() {
        return this.zzWjc.zzZ66().zzYzy();
    }
}

