/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zz7j;
import com.aspose.words.zzJr;
import com.aspose.words.zzWip;
import com.aspose.words.zzXe7;
import com.aspose.words.zzYAm;
import com.aspose.words.zzYLq;
import com.aspose.words.zzZbu;
import com.aspose.words.zzZcB;
import com.aspose.words.zzZmq;
import com.aspose.words.zzgI;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzXe7,
Iterable<T> {
    private Node zzVWl;
    private Node zzZI8;
    private Node zzZNp;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        zzYLq zzYLq2 = new zzYLq(this.getDocument());
        try {
            while (this.hasChildNodes()) {
                this.getParentNode().insertAfter(this.getLastChild(), this);
            }
            this.getParentNode().zzAt((Node)this, true);
            return;
        }
        finally {
            zzYLq2.dispose();
        }
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzWX0() {
        return this.zzXM9() != null;
    }

    final boolean zzZ6z() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzWUO() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzZbu) {
                return true;
            }
            CompositeNode compositeNode = zz7j.zzZkx((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzWUO()) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        return this.zzVWl;
    }

    public Node getLastChild() {
        return this.zzZI8;
    }

    final Node zzXM9() {
        return zzYAm.zzVPT(this.getFirstChild(), false);
    }

    final Node zzWfz() {
        return zzYAm.zzWvh(this.getLastChild(), false);
    }

    final CompositeNode zzWJS() {
        return (CompositeNode)zzYAm.zzVPT(this.getFirstChild(), true);
    }

    final CompositeNode zzJb() {
        return (CompositeNode)zzYAm.zzWvh(this.getLastChild(), true);
    }

    final Node zzWHs() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzYAm.zzWgN((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zzZTo() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzYAm.zzWgN((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzZkx(boolean bl, zzgI zzgI2) {
        CompositeNode compositeNode = (CompositeNode)super.zzZkx(bl, zzgI2);
        ((CompositeNode)super.zzZkx(bl, zzgI2)).zzZI8 = null;
        compositeNode.zzVWl = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzWxi(node.zzZkx(true, zzgI2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzZ6A(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzZ6A(StringBuilder stringBuilder) {
        this.zzjm(stringBuilder);
        zz7j.zzAt(stringBuilder, this.zzZiJ());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzAt(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, true);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzYAm.zzWs2(nodeType);
            Node node2 = node = bl ? this.zzXM9() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzcJ() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzZmq.zzZOm(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzZmq.zzYma(this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzWip(this);
    }

    public Node appendChild(Node newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) {
        return this.zzZkx(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.zzZkx(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        return this.zzAt(oldChild, false);
    }

    private Node zzAt(Node node, boolean bl) {
        if (node == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oldChild");
        }
        if (node.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzZkx(node, (Node)this, null, 1);
        if (documentBase.zzZ9d() && zzYAm.zzWwB(node)) {
            return node;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzZkx(nodeChangingArgs);
        }
        if (!bl && zzYAm.zzYKF(node)) {
            zzYAm.zzY0W(node, false);
        }
        Node node2 = this.zzXZv(node);
        if (nodeChangingArgs != null) {
            documentBase.zzAt(nodeChangingArgs);
        }
        return node2;
    }

    public void removeAllChildren() {
        zzJr.zzsc(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzWxi(Node node) {
        node.getParentNode();
        if (this.zzZI8 == null) {
            node.zzZwi(null);
            node.zzWFh(null);
            this.zzVWl = node;
        } else {
            node.zzZwi(this.zzZI8);
            node.zzWFh(null);
            this.zzZI8.zzWFh(node);
        }
        this.zzZI8 = node;
        node.zzWn(this);
        return node;
    }

    final void zzZkx(Node node, Node node2, Node node3) {
        this.zzZkx(node, node2, node3, false);
    }

    final void zzZkx(Node node, Node node2, Node node3, boolean bl) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            if (!bl || this.zzQN(node4)) {
                this.insertBefore(node4, node3);
            }
            node4 = node5;
        }
    }

    final void zzAt(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzZOm(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzYAm.zzWgN(node3.getNodeType())) continue;
            if (zzYAm.zzWiY(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzZiJ().length();
    }

    String zzZiJ() {
        return "";
    }

    final String zzWW1() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzjm(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzjm(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzZ6A(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzZkx(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zzAt(visitor));
    }

    abstract int zzZkx(DocumentVisitor var1) throws Exception;

    abstract int zzAt(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzQN(Node var1);

    final Node zzZkx(Node node, Node node2, boolean bl) {
        Object object;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzZHp(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 37 && !this.zzQN(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = node.getParentNode();
        Node node3 = node.getNextSibling();
        if (compositeNode != null) {
            object = new zzZcB(documentBase);
            try {
                compositeNode.zzAt(node, true);
            }
            finally {
                ((zzZcB)object).dispose();
            }
        }
        if ((object = documentBase.zzZkx(node, null, (Node)this, 0)) != null) {
            documentBase.zzZkx((NodeChangingArgs)object);
        }
        if (this.zzZI8 == null) {
            node.zzZwi(null);
            node.zzWFh(null);
            this.zzVWl = node;
            this.zzZI8 = node;
        } else if (bl) {
            if (node2 != null) {
                this.zzAt(node, node2);
            } else {
                this.zzZOm(node, this.zzVWl);
            }
        } else if (node2 != null) {
            this.zzZOm(node, node2);
        } else {
            this.zzAt(node, this.zzZI8);
        }
        node.zzWn(this);
        if (object != null) {
            documentBase.zzAt((NodeChangingArgs)object);
        }
        if (documentBase.zzZ9d()) {
            zzYAm.zzZkx(node, compositeNode, node3);
        }
        return node;
    }

    private void zzAt(Node node, Node node2) {
        Node node3 = node2.zzH2();
        node.zzZwi(node2);
        node.zzWFh(node3);
        node2.zzWFh(node);
        if (node3 == null) {
            this.zzZI8 = node;
            return;
        }
        node3.zzZwi(node);
    }

    private void zzZOm(Node node, Node node2) {
        Node node3 = node2.zzW0N();
        node.zzZwi(node3);
        node.zzWFh(node2);
        node2.zzZwi(node);
        if (node3 == null) {
            this.zzVWl = node;
            return;
        }
        node3.zzWFh(node);
    }

    private Node zzXZv(Node node) {
        if (node == this.zzVWl) {
            if (this.zzVWl == this.zzZI8) {
                this.zzVWl = null;
                this.zzZI8 = null;
            } else {
                this.zzVWl = node.zzH2();
                this.zzVWl.zzZwi(null);
            }
        } else {
            Node node2 = node.zzW0N();
            Node node3 = node.zzH2();
            node2.zzWFh(node3);
            if (node3 == null) {
                this.zzZI8 = node2;
            } else {
                node3.zzZwi(node2);
            }
        }
        node.zzWFh(null);
        node.zzZwi(null);
        node.zzWn(null);
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzZNp = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzZNp;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

