/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zz7j;
import com.aspose.words.internal.zzVQJ;
import com.aspose.words.internal.zzW81;
import com.aspose.words.internal.zzWP;
import com.aspose.words.internal.zzX4t;
import com.aspose.words.internal.zzX5D;
import com.aspose.words.internal.zzXvD;
import com.aspose.words.internal.zzYJF;
import com.aspose.words.internal.zzYqc;
import com.aspose.words.internal.zzYrt;
import com.aspose.words.internal.zzZ1Z;
import com.aspose.words.internal.zzsu;
import com.aspose.words.zzBj;
import com.aspose.words.zzWIW;
import com.aspose.words.zzWm7;
import com.aspose.words.zzWnB;
import com.aspose.words.zzXAD;
import com.aspose.words.zzXjS;
import com.aspose.words.zzXvP;
import com.aspose.words.zzYqe;
import com.aspose.words.zzZDs;
import com.aspose.words.zzZk6;
import com.aspose.words.zzZva;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzZkx(zzXvD zzXvD2, zzXvD zzXvD3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zz7j.zzAt((Object)zzXvD2, "srcStream");
        zz7j.zzAt((Object)zzXvD3, "dstStream");
        zz7j.zzAt((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzAt(zzXvD2, zzXvD3, certificateHolder, signOptions);
        zzXvD3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzZkx(zzXvD.zzAt(srcStream), (zzXvD)zzXvD.zzZOm(dstStream), certHolder, signOptions);
    }

    private static void zzAt(zzXvD zzXvD2, zzXvD zzXvD3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzZOm(digitalSignature);
        }
        if (zzZDs.zzez(zzXvD2)) {
            DigitalSignatureUtil.zzZkx(zzXvD2, zzXvD3, digitalSignature, true);
            return;
        }
        zzZDs zzZDs2 = new zzZDs();
        zzXvD zzXvD4 = zzXvD2;
        zzZDs zzZDs3 = zzZDs2;
        FileFormatInfo fileFormatInfo = zzZDs2.zzAt(zzXvD4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzZ1Z zzZ1Z2 = new zzZ1Z(zzXvD2);
                int n = fileFormatInfo.zz4S() == 1 ? 1 : 2;
                zzZk6.zzZkx(zzZ1Z2, digitalSignature, n);
                zzXvD3.zzZWw(0L);
                zzZ1Z2.zzZ6A(zzXvD3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzZkx(fileFormatInfo.zzWxD(), zzXvD3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzZkx(zzXvD2, zzXvD3, digitalSignature, false);
                return;
            }
            case 60: {
                DigitalSignatureUtil.zzZkx(zzXvD2, zzXvD3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zz7j.zzZOm(srcFileName, "srcFileName");
        zz7j.zzZOm(dstFileName, "dstFileName");
        try (zzX4t zzX4t2 = zz7j.zzAt(srcFileName, 3, 1);){
            try (zzX4t zzX4t3 = zz7j.zzAt(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzZkx((zzXvD)zzX4t2, (zzXvD)zzX4t3, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzW81 zzW812 = zzXvD.zzZOm(dstStream);
        zzXvD zzXvD2 = zzXvD.zzAt(srcStream);
        DigitalSignatureUtil.zzZkx(zzXvD2, (zzXvD)zzW812, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zzX4t zzX4t2 = zz7j.zzAt(srcFileName, 3, 1);){
            try (zzX4t zzX4t3 = zz7j.zzAt(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzYma(zzX4t2, zzX4t3);
            }
            return;
        }
    }

    private static void zzYma(zzXvD zzXvD2, zzXvD zzXvD3) throws Exception {
        zzZDs zzZDs2 = new zzZDs();
        zzXvD zzXvD4 = zzXvD2;
        Object object = zzZDs2;
        FileFormatInfo fileFormatInfo = zzZDs2.zzAt(zzXvD4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzZ1Z zzZ1Z2 = new zzZ1Z(zzXvD2);
                zzZ1Z2.zzWzC().zzZRw("_xmlsignatures");
                zzZ1Z2.zzWzC().zzZRw("_signatures");
                zzXvD3.zzYRS(0L);
                zzZ1Z2.zzZ6A(zzXvD3);
                zzXvD zzXvD5 = zzXvD3;
                zzXvD5.zzZWw(zzXvD5.zzZSf());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzYJF zzYJF2 = new zzYJF(zzXvD2);
                zzYrt zzYrt2 = zzYJF2.zzZkx(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzYrt2 != null) {
                    for (zzVQJ zzVQJ2 : zzYrt2.zzXNE()) {
                        String string = zzYrt2.zzZkx(zzVQJ2);
                        zzYJF2.zzWPN().remove(string);
                    }
                    zzYJF2.zzWPN().remove(zzYrt2.getName());
                    zzVQJ zzVQJ3 = zzYJF2.zzXNE().zzZfD("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzYJF2.zzXNE().remove(zzVQJ3.getId());
                    zzYJF2.zzZoi();
                }
                zzXvD3.zzYRS(0L);
                zzYJF2.zzZ6A(zzXvD3);
                zzXvD zzXvD6 = zzXvD3;
                zzXvD6.zzZWw(zzXvD6.zzZSf());
                return;
            }
            case 60: {
                zzWIW zzWIW2 = new zzWIW(zzXvD2);
                zzXAD zzXAD2 = zzWIW2.zzdL("/META-INF/documentsignatures.xml");
                if (zzXAD2 != null) {
                    zzWIW2.zzVRI().remove(zzXAD2.getName());
                }
                zzXvD3.zzYRS(0L);
                String string = "application/vnd.oasis.opendocument.text";
                zzXvD4 = zzXvD3;
                object = zzWIW2;
                ((zzWIW)object).zzZkx(zzXvD4, string, null);
                zzXvD zzXvD7 = zzXvD3;
                zzXvD7.zzZWw(zzXvD7.zzZSf());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzYma(zzXvD.zzAt(srcStream), zzXvD.zzZOm(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zzX4t zzX4t2 = zz7j.zzAt(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzXZ0(zzX4t2);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzXZ0(zzXvD zzXvD2) throws Exception {
        if (zzZDs.zzez(zzXvD2)) {
            return DigitalSignatureUtil.zzYZh(zzXvD2);
        }
        zzZDs zzZDs2 = new zzZDs();
        zzXvD zzXvD3 = zzXvD2;
        zzZDs zzZDs3 = zzZDs2;
        FileFormatInfo fileFormatInfo = zzZDs2.zzAt(zzXvD3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzXvD2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzXZ0(zzXvD.zzAt(stream));
    }

    static zzYqc zzZkx(zzZ1Z zzZ1Z2, String string) throws Exception {
        zzYqe zzYqe2 = new zzYqe(zzZ1Z2);
        if (zzYqe2.zzYxS()) {
            zzYqc zzYqc2 = zzYqe2.zzVg(string);
            return zzYqc2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzW42(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzWP.zzAt("Unexpected digest algorithm: {0}.", n));
    }

    static String zzYwg(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzW42(n);
    }

    private static void zzZkx(zzXvD zzXvD2, zzXvD zzXvD3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzYJF zzYJF2 = new zzYJF(zzXvD2);
        zzXjS zzXjS2 = bl ? new zzXvP(zzYJF2) : new zzBj(zzYJF2);
        zzXjS2.zzAt(digitalSignature);
        zzXvD3.zzZWw(0L);
        zzYJF2.zzZ6A(zzXvD3);
    }

    private static void zzZkx(zzXvD zzXvD2, zzXvD zzXvD3, DigitalSignature digitalSignature) throws Exception {
        zzWIW zzWIW2 = new zzWIW(zzXvD2);
        zzWnB zzWnB2 = new zzWnB(zzWIW2);
        zzWnB2.zzAt(digitalSignature);
        zzXvD3.zzZWw(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzXvD zzXvD4 = zzXvD3;
        zzWIW zzWIW3 = zzWIW2;
        zzWIW3.zzZkx(zzXvD4, string, null);
    }

    private static void zzZkx(zzZ1Z zzZ1Z2, zzXvD zzXvD2, DigitalSignature digitalSignature, String string) throws Exception {
        zzYqc zzYqc2 = DigitalSignatureUtil.zzZkx(zzZ1Z2, string);
        zzYqc zzYqc3 = new zzYqc();
        DigitalSignatureUtil.zzZkx((zzXvD)zzYqc2, (zzXvD)zzYqc3, digitalSignature, false);
        zzZ1Z zzZ1Z3 = zzYqe.zzZOm(zzYqc3, string);
        zzZ1Z3.zzZ6A(zzXvD2);
    }

    private static DigitalSignatureCollection zzYZh(zzXvD zzXvD2) throws Exception {
        zzXvD2.zzYRS(0L);
        zzYJF zzYJF2 = new zzYJF(zzXvD2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzYrt zzYrt2 = zzYJF2.zzZkx(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzYrt2 != null) {
            for (zzVQJ zzVQJ2 : zzYrt2.zzXNE()) {
                String string = zzYrt2.zzZkx(zzVQJ2);
                zzYrt zzYrt3 = zzYJF2.zzXGk(string);
                zzYrt zzYrt4 = zzYJF2.zzZkx(zzYrt3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzX5D zzX5D2 = zzsu.zzXmK(zzYrt4.zzgQ().zzZ2x());
                zzWm7.zzZkx(zzYrt3.zzWAq(), zzX5D2, new zzZva(zzYJF2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

