/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompatibilityOptions;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.internal.zz7j;
import com.aspose.words.internal.zzKJ;
import com.aspose.words.internal.zzWP;
import com.aspose.words.internal.zzWY8;
import com.aspose.words.internal.zzWgN;
import com.aspose.words.internal.zzWyA;
import com.aspose.words.internal.zzXEy;
import com.aspose.words.internal.zzXvD;
import com.aspose.words.internal.zzYfD;
import com.aspose.words.internal.zzYi1;
import com.aspose.words.internal.zzYqc;
import com.aspose.words.internal.zzYyw;
import com.aspose.words.internal.zzZ2T;
import com.aspose.words.internal.zzZNl;
import com.aspose.words.internal.zzZnh;
import com.aspose.words.internal.zzZrf;
import com.aspose.words.internal.zzZx9;
import com.aspose.words.internal.zzok;
import com.aspose.words.zzFa;
import com.aspose.words.zzGw;
import com.aspose.words.zzQh;
import com.aspose.words.zzQu;
import com.aspose.words.zzVPb;
import com.aspose.words.zzVPy;
import com.aspose.words.zzVQJ;
import com.aspose.words.zzVRg;
import com.aspose.words.zzVVM;
import com.aspose.words.zzW1d;
import com.aspose.words.zzW2A;
import com.aspose.words.zzW5M;
import com.aspose.words.zzW9u;
import com.aspose.words.zzWGU;
import com.aspose.words.zzWMx;
import com.aspose.words.zzWON;
import com.aspose.words.zzWWM;
import com.aspose.words.zzWZ4;
import com.aspose.words.zzWj8;
import com.aspose.words.zzWkl;
import com.aspose.words.zzWq0;
import com.aspose.words.zzWzc;
import com.aspose.words.zzX0d;
import com.aspose.words.zzXGa;
import com.aspose.words.zzXIY;
import com.aspose.words.zzXJB;
import com.aspose.words.zzXSm;
import com.aspose.words.zzXUI;
import com.aspose.words.zzXXx;
import com.aspose.words.zzXjq;
import com.aspose.words.zzXmu;
import com.aspose.words.zzXxI;
import com.aspose.words.zzYAm;
import com.aspose.words.zzYHx;
import com.aspose.words.zzYLL;
import com.aspose.words.zzYNA;
import com.aspose.words.zzYh0;
import com.aspose.words.zzYhT;
import com.aspose.words.zzYmF;
import com.aspose.words.zzYv;
import com.aspose.words.zzZ0J;
import com.aspose.words.zzZTF;
import com.aspose.words.zzZcB;
import com.aspose.words.zzZcr;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzVVM,
zzW1d,
zzWkl,
zzZ0J {
    private Document zzYGH;
    private Node zzYaa;
    private Node zzW0q;
    private zzWGU zzXwG;
    private Font zzYae;
    private zzok<zzWGU> zzmF;
    private zzok<zzXxI> zzXG1;
    private zzok<zzZkx> zzWFA;
    private zzWq0 zzZZV = zzWq0.zzYZ();
    private zzVPb zzX0o = new zzVPb();
    private zzXxI zzYo9;
    private RowFormat zzYCa;
    private CellFormat zzWSE;
    private ParagraphFormat zzXJv;
    private zzok<zzVRg> zzYIe;
    private int zz0N = 0;
    private int zzmn = -1;
    private int zzWDo;
    private boolean zznh;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzY0W(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzY0W(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzY0W(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzZkx(documentBuilder.getCurrentSection(), zzW5M.zzZ55(headerFooterType), 0, 0);
    }

    private void zzY0W(int n, int n2, int n3, int n4) {
        this.zzYGH.ensureMinimum();
        Section section = (Section)this.zzYGH.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzZkx(section, 1, n3, n4);
    }

    private void zzZkx(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzW5M.zzi5(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzYGH, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzYGH));
            }
        }
        this.zzZkx(story, n2, n3);
    }

    private void zzZkx(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        int n3 = n2;
        Paragraph paragraph2 = paragraph;
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzZkx((CompositeNode)paragraph2, n3);
    }

    final void zzZkx(Paragraph paragraph, int n) {
        this.zzZkx((CompositeNode)paragraph, n);
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: fieldName");
        }
        FieldMergeField fieldMergeField = this.zzRC().zzZAF() ? zzYNA.zzpK(this.zzYGH, fieldName) : zzYNA.zzQN(this.zzRC(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzZkx(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzZkx(field, isAfter, false);
    }

    private boolean zzZkx(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzW9u zzW9u2 = field.getFormat().zzpk();
        Inline inline = zzW9u2.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzZkx(inline.zzWiU(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: bookmarkName");
        }
        Node node = isStart ? zzXmu.zzZkx(this.zzYGH, bookmarkName) : zzXmu.zzAt(this.zzYGH, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzW0f() == 6) {
            this.zzZkx((Paragraph)node.zzZmJ(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzYAm.zzXtd(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzZkx(paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzZkx(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToStructuredDocumentTag(int structuredDocumentTagIndex, int characterIndex) {
        StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.getCurrentStory().getChild(28, structuredDocumentTagIndex, true);
        if (structuredDocumentTag == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: structuredDocumentTagIndex");
        }
        this.moveToStructuredDocumentTag(structuredDocumentTag, characterIndex);
    }

    public void moveToStructuredDocumentTag(StructuredDocumentTag structuredDocumentTag, int characterIndex) {
        if (structuredDocumentTag == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: structuredDocumentTag");
        }
        if (characterIndex >= 0) {
            this.zzAt(structuredDocumentTag, characterIndex);
            return;
        }
        if (++characterIndex == 0) {
            this.zzZkx(structuredDocumentTag);
            return;
        }
        this.zzZOm(structuredDocumentTag, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        Row row = this.zzXGk(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        this.zzZkx(cell, characterIndex);
    }

    private void zzZkx(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(paragraph);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzW0f() == 6) {
            this.zzW2A(node);
        } else {
            Node node2 = node;
            if (zzYAm.zzWgN(node2.getNodeType())) {
                Paragraph paragraph = zzYAm.zzXtd(node);
                if (paragraph == null) {
                    throw new IllegalStateException("There is no paragraph next to the specified node.");
                }
                this.zzW2A(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
            } else if (node.isComposite() && node.zzW0f() == 3) {
                Node node3 = ((CompositeNode)node).getChild(8, 0, true);
                if (node3 == null) {
                    throw new IllegalStateException("The block level node doesn't contain paragraph.");
                }
                this.zzW2A(node3);
            } else {
                throw new IllegalStateException("The node must be a block or an inline.");
            }
        }
        this.zzWDo = 0;
        if (this.isAtEndOfParagraph()) {
            this.zzZJA();
            return;
        }
        if (!this.zzdy()) {
            this.zzZJA();
        }
    }

    private boolean zzdy() {
        Node node = this.zzRC();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
            if (node == null && this.zzRC().getParentNode().getNodeType() == 28) {
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzZkx(((StructuredDocumentTag)documentBuilder.zzRC().getParentNode()).zzWNM(), true);
                return true;
            }
        }
        if (node == null) {
            for (node = this.zzRC(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzZkx(inline.zzWiU(), true);
            return true;
        }
        return false;
    }

    private void zzZJA() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzZkx(documentBuilder.getCurrentParagraph().zzxd(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzXGk(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzWLk() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzRC().zzZHp(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzZQD();
                int n = 0;
                Paragraph paragraph2 = paragraph;
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzZkx((CompositeNode)paragraph2, n);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzZZy(text, false);
    }

    public void writeln(String text) {
        this.zzZZy(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        Paragraph paragraph;
        if (this.zzRC() != null && this.zzRC().zzW0f() == 6 && (this.isAtEndOfStructuredDocumentTag() || this.zzRC().getParentNode() instanceof StructuredDocumentTag)) {
            throw new IllegalStateException("Cannot insert a node of this type at this location.");
        }
        this.zzXus();
        Paragraph paragraph2 = this.getCurrentParagraph();
        zzZcB zzZcB2 = new zzZcB(this.getDocument());
        try {
            paragraph = new Paragraph(this.zzYGH, this.zzEu(), this.zzWLG());
            if (paragraph2 == null && this.isAtEndOfStructuredDocumentTag()) {
                this.getCurrentStructuredDocumentTag().appendChild(paragraph);
            } else {
                this.getCurrentParagraph().getParentNode().insertAfter(paragraph, this.getCurrentParagraph());
            }
            if (this.isAtEndOfParagraph() || paragraph2 == null) {
                this.moveTo(paragraph);
            } else {
                paragraph.zzAt(this.zzRC(), null, paragraph.getLastChild());
            }
        }
        finally {
            zzZcB2.dispose();
        }
        if (this.getDocument().zzZ9d()) {
            zzYAm.zzZOm((zzZcr)(paragraph2 != null ? paragraph2 : paragraph), this.getDocument().zzZln());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzX0g() {
        zzWGU zzWGU2;
        Run run;
        Run run2;
        Cloneable cloneable;
        this.zzXus();
        Node node = this.zzRC();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            cloneable = paragraph;
            run2 = cloneable.zzBT(false);
        } else {
            run2 = run = (Run)node.zzWu7(21);
        }
        if (run2 == null && zz7j.zzsf(node, paragraph.zzWeA())) {
            run = paragraph.zzWeA();
        }
        if (run != null) {
            cloneable = run.zzWiU();
            zzWGU2 = (zzWGU)((zzQu)cloneable).zzZrq();
        } else {
            cloneable = paragraph.zzxd();
            zzWGU2 = (zzWGU)((zzQu)cloneable).zzZrq();
        }
        zzWGU zzWGU3 = zzWGU2;
        Paragraph paragraph2 = new Paragraph(this.zzYGH, this.zzEu(), zzWGU3);
        paragraph.getParentNode().insertBefore(paragraph2, paragraph);
        zzZcB zzZcB2 = new zzZcB(this.zzYGH);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzAt(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzZcB2.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zzYh0.zzpK(this);
    }

    public void insertBreak(int breakType) {
        this.zzW8t(breakType, true);
    }

    final void zzW8t(int n, boolean bl) {
        block11: while (true) {
            switch (n) {
                case 0: {
                    this.insertParagraph();
                    return;
                }
                case 1: {
                    if (!this.zzWEs(bl)) {
                        return;
                    }
                    boolean bl2 = this.isAtStartOfParagraph() && !this.isAtEndOfParagraph();
                    this.zzXec(ControlChar.PAGE_BREAK);
                    CompatibilityOptions compatibilityOptions = this.getDocument().getCompatibilityOptions();
                    if (bl2 && (!compatibilityOptions.getSplitPgBreakAndParaMark() || compatibilityOptions.zzPP())) {
                        n = 0;
                        continue block11;
                    }
                    return;
                }
                case 2: {
                    if (this.zzWEs(bl)) {
                        this.zzXec(ControlChar.COLUMN_BREAK);
                    }
                    return;
                }
                case 4: {
                    if (this.zzWEs(bl)) {
                        this.zzZoh(1);
                    }
                    return;
                }
                case 5: {
                    if (this.zzWEs(bl)) {
                        this.zzZoh(2);
                    }
                    return;
                }
                case 3: {
                    if (this.zzWEs(bl)) {
                        this.zzZoh(0);
                    }
                    return;
                }
                case 6: {
                    if (this.zzWEs(bl)) {
                        this.zzZoh(3);
                    }
                    return;
                }
                case 7: {
                    if (this.zzWEs(bl)) {
                        this.zzZoh(4);
                    }
                    return;
                }
                case 8: {
                    this.zzXec(ControlChar.LINE_BREAK);
                    return;
                }
            }
            break;
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzZrf.zzZLW(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzWP.zzAt("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        this.zzXus();
        return zzYAm.zzZkx(fieldType, updateField, this.zzWLG(), this.zzIp(), this.zzXeH(), this.zzXeH() == null);
    }

    public Field insertField(String fieldCode) throws Exception {
        this.zzXus();
        return zzYAm.zzZkx(fieldCode, this.zzWLG(), this.zzIp(), this.zzXeH(), this.zzXeH() == null);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        this.zzXus();
        return zzYAm.zzZkx(fieldCode, fieldValue, this.zzWLG(), this.zzIp(), this.zzXeH(), this.zzXeH() == null);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zz7j.zzAt((Object)displayText, "displayText");
        zz7j.zzAt((Object)urlOrBookmark, "hrefOrBookmark");
        zzYLL zzYLL2 = this.zzAt(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zzYLL2.zzZOm(documentBuilder.zz11(88, true));
        return zzYAm.zzZkx(zzYLL2.getStart(), zzYLL2.getSeparator(), zzYLL2.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (format == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzYRP(70);
        if (zzZrf.zzZLW(name)) {
            this.startBookmark(name);
        }
        this.zzZYZ(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzXtM(70);
        String string = zzZrf.zzZLW(fieldValue) ? fieldValue : FormField.zzZXc;
        Run run = new Run(this.zzYGH, string, this.zzWLG());
        this.insertNode(run);
        Node node = this.zz11(70, true);
        if (zzZrf.zzZLW(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzX45(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzZkx((Paragraph)node.zzZmJ(), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzYRP(71);
        if (zzZrf.zzZLW(name)) {
            this.startBookmark(name);
        }
        this.zzZYZ(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zz11(71, false);
        if (zzZrf.zzZLW(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzX45(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (items == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzYRP(83);
        if (zzZrf.zzZLW(name)) {
            this.startBookmark(name);
        }
        this.zzZYZ(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zz11(83, false);
        if (zzZrf.zzZLW(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzX45(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote(this.zzYGH, footnoteType, !zzZrf.zzZLW(referenceMark), referenceMark, this.zzWLG());
        Style style = this.getDocument().getStyles().zzWXT(zzYAm.zzW8A(footnoteType));
        footnote.zzWiU().set(50, style.zzZee());
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzYGH);
        Style style2 = this.getDocument().getStyles().zzWXT(zzYAm.zzZox(footnoteType));
        paragraph.zzYC().set(1000, style2.zzZee());
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzYGH, '\u0002', new zzWGU()) : new Run(this.zzYGH, footnote.getReferenceMark(), new zzWGU());
        inline.zzWiU().set(50, style.zzZee());
        paragraph.appendChild(inline);
        if (zzZrf.zzZLW(footnoteText)) {
            Node node = this.zzRC();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzW2A(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zz9k(zzXvD zzXvD2) throws Exception {
        return this.zzZkx(zzXvD2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zz9k(zzXvD.zzAt(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzZkx(zzXvD zzXvD2, double d, double d2) throws Exception {
        return this.zzZkx(zzXvD2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzZkx(zzXvD.zzAt(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: image");
        }
        try (zzYqc zzYqc2 = new zzYqc();){
            zzYi1.zzAt(image, zzYqc2);
            Shape shape = this.zzZkx(zzYqc2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zz7j.zzZOm(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzZ2T.zzYfE(fileName);
        try {
            Shape shape = this.zzZkx((zzXvD)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzXvD)object).close();
            }
        }
    }

    private Shape zzZkx(zzXvD zzXvD2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzXvD2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: stream");
        }
        byte[] byArray = zz7j.zzYnZ(zzXvD2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzZkx(zzXvD.zzAt(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzZkx(imageBytes, horzPos, left, vertPos, top, width, height, wrapType, false);
    }

    final Shape zzZkx(byte[] object, int n, double d, int n2, double d2, double d3, double d4, int n3, boolean bl) throws Exception {
        Object object2;
        Object object3;
        Shape shape;
        Object object4;
        if (object == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: imageBytes");
        }
        boolean bl2 = false;
        if (zzZNl.zzXZ0(object)) {
            object4 = new zzYi1((byte[])object);
            bl2 = true;
            ((zzWY8)object4).dispose();
        }
        object4 = null;
        boolean bl3 = this.zzYGH.getCompatibilityOptions().getMswVersion() > 12 || this.zzYGH.getCompatibilityOptions().getMswVersion() == 0;
        if (bl3) {
            shape = new Shape((DocumentBase)this.zzYGH, 0);
            object3 = new zzXIY();
            ((zzWZ4)object3).zzZkx(zzVQJ.zzTk("rect"));
            ((zzXIY)object3).zzZkx(new zzGw());
            ((zzXIY)object3).zzYC0().zziY().zzZOm(this.zzYGH);
            object2 = new zzXSm();
            ((zzYmF)object2).zzAt(new zzYhT(this.zzYGH.zzWwY(), ""));
            ((zzYmF)object2).zzZkx(new zzWzc());
            ((zzXjq)object3).zzZkx((zzYmF)object2);
            shape.zzYqv(75);
            shape.zzWiY((zzXjq)object3);
        } else {
            shape = new Shape((DocumentBase)this.zzYGH, 75);
        }
        if (zzZNl.zzLv(object)) {
            int n4 = bl3 ? 6 : 2;
            object2 = shape.getImageData().zzZkx((byte[])object, new zzFa(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), new zzFa(d3, d4), n4);
            if (bl3) {
                ImageSize imageSize = new ImageSize(zzZNl.zzXEN((byte[])object2));
                this.zzZkx((zzXIY)shape.zzXqA(), (byte[])object, imageSize);
            }
            object = object2;
        }
        if (bl3 && bl2) {
            ((zzXIY)shape.zzXqA()).zzYC0().zziY().zzXOZ((byte[])object);
            object3 = zzZNl.zzYi1(object);
            object4 = new zzFa(((zzZx9)object3).getWidthPoints(), ((zzZx9)object3).getHeightPoints());
        } else {
            shape.getImageData().setImageBytes((byte[])object);
        }
        shape.zzZkx(this.zzWLG());
        shape.setRelativeHorizontalPosition(n);
        shape.setLeft(d);
        shape.setRelativeVerticalPosition(n2);
        shape.setTop(d2);
        shape.setWrapType(n3);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        double d5 = 0.0;
        if (!bl && bl3 && zzZNl.zzWqc(object)) {
            d5 = DocumentBuilder.zzZkx(shape, object);
        }
        shape.zzZkx(d3, d4, (zzFa)object4, d5);
        if (d5 > 0.0) {
            shape.setRotation(d5);
        }
        return shape;
    }

    private static double zzZkx(Shape shape, byte[] byArray) throws Exception {
        int n = zzZNl.zzYko(byArray);
        if (n == 1) {
            return 0.0;
        }
        int n2 = zzYAm.zzYDz(n);
        if (n2 != 0) {
            shape.setFlipOrientation(n2);
        }
        double d = zzYAm.zzZzY(n);
        return d;
    }

    private void zzZkx(zzXIY zzXIY2, byte[] byArray, ImageSize imageSize) throws Exception {
        byte[] byArray2;
        Object object;
        zzXIY2.zzYC0().zziY().getExtensions();
        try (zzYqc zzYqc2 = new zzYqc(byArray);){
            object = zzYAm.zzZkx(zzYqc2, this.zzYGH);
            ((zzWWM)object).zzsc(imageSize.getWidthPoints(), imageSize.getHeightPoints());
            ((zzWWM)object).zzW7I();
            byArray2 = ((zzWWM)object).zzbG(true);
        }
        zzXIY2.zzYC0().zziY().setExtensions(new zzYfD<zzVPy>());
        object = zzVPy.zzZkx(byArray2, this.zzYGH);
        zzXIY2.zzYC0().zziY().getExtensions().zzLK(((zzVPy)object).getUri(), (zzVPy)object);
    }

    private Shape zzZkx(zzXvD zzXvD2, String string, boolean bl, zzXvD zzXvD3) throws Exception {
        zzXJB zzXJB2 = zzXJB.zzYSM(string);
        Shape shape = this.zzZkx(zzXvD3, bl, zzXJB2, null);
        zzZTF zzZTF2 = zzWj8.zzZkx(zzXvD2, string, bl);
        return DocumentBuilder.zzZkx(null, false, shape, zzXJB2.zzZPv, zzZTF2);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzZkx(zzXvD.zzAt(stream), progId, asIcon, zzXvD.zzAt(presentation));
    }

    private Shape zzZkx(String string, boolean bl, boolean bl2, zzXvD zzXvD2) throws Exception {
        zzXJB zzXJB2 = zzXJB.zzZLb(zzZnh.zztw(string));
        return this.zzZkx(string, bl, bl2, zzXvD2, zzXJB2);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzZkx(fileName, isLinked, asIcon, zzXvD.zzAt(presentation));
    }

    private Shape zzZkx(String string, String string2, boolean bl, boolean bl2, zzXvD zzXvD2) throws Exception {
        zzXJB zzXJB2 = zzXJB.zzYSM(string2);
        return this.zzZkx(string, bl, bl2, zzXvD2, zzXJB2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzZkx(fileName, progId, isLinked, asIcon, zzXvD.zzAt(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzXJB zzXJB2 = zzXJB.zzZLb(zzZnh.zztw(fileName));
        return this.zzZkx(fileName, isLinked, iconFile, iconCaption, zzXJB2);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzXJB zzXJB2 = zzXJB.zzYSM(progId);
        return this.zzZkx(fileName, isLinked, iconFile, iconCaption, zzXJB2);
    }

    private Shape zzZkx(zzXvD zzXvD2, String string, String string2, String string3) throws Exception {
        zzXJB zzXJB2 = zzXJB.zzYSM(string);
        Shape shape = this.zzZkx(string2, string3, zzXJB2);
        zzZTF zzZTF2 = zzWj8.zzZkx(zzXvD2, string, true);
        return DocumentBuilder.zzZkx(null, false, shape, zzXJB2.zzZPv, zzZTF2);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzZkx(zzXvD.zzAt(stream), progId, iconFile, iconCaption);
    }

    final Shape zzZkx(zzXGa zzXGa2, zzXvD zzXvD2) throws Exception {
        Shape shape = this.zzae(zzXvD2);
        shape.zzYqv(201);
        shape.setShapeAttr(4112, zzXGa2);
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.insertHtml(html, 0);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        int n = useBuilderFormatting ? 1 : 0;
        this.insertHtml(html, n);
    }

    public void insertHtml(String html, int options) throws Exception {
        this.zzXus();
        if (this.zzYad()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(html);
            this.write(DocumentBuilder.zzYoH(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzWMx zzWMx2 = zzYAm.zzZkx(html, options, this);
        zzWMx2.zzY0K();
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        this.zzXus();
        return zzYAm.zzZkx(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        this.zzXus();
        return zzYAm.zzZkx(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzQh zzQh2 = new zzQh();
        return zzQh2.zzZkx(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzXXx(this).zzZkx(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzXXx(this).zzZkx(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzYGH, 75);
        shape.zzZkx(this.zzWLG());
        shape.zzkb(true);
        shape.getSignatureLine().zzZkx(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzat(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzVXw(this.zzYGH);
        this.insertNode(shape);
        return shape;
    }

    private boolean zzYad() {
        boolean bl = false;
        if (this.zzRC().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzRC().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzYoH(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        this.zzXus();
        if (this.zzWLk() == null) {
            this.startTable();
        }
        if (this.zzWLk().zzXVo() == 1) {
            this.zzWLk().zzYfa();
        }
        if (this.zzWLk().zzXVo() == 3) {
            this.zzWLk().zzWcT();
        }
        return this.zzWLk().zzZGh();
    }

    public Table startTable() {
        this.zzYIe.push(new zzVRg(this));
        return this.zzWLk().startTable();
    }

    public Table endTable() {
        if (this.zzWLk() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzWLk().endTable();
        this.zzYIe.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzWLk() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzWLk().endRow();
        if (this.zzYae != null && this.zzYae.getHidden()) {
            row.zzZIT().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzYGH, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzYGH, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) {
        Cell cell = this.zzZM0();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        cell2.ensureMinimum();
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzYGH, bookmarkName);
        cell2.getFirstParagraph().insertAfter(bookmarkStart, null);
        int n = cell.zzW8X();
        bookmarkStart.zzsA(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) {
        Cell cell = this.zzZM0();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzW8X();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzYGH, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zzTk(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzYGH);
        this.zzmn = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzmn == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzYGH, this.zzmn);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzYGH, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zz7j.zzAt((Object)importFormatOptions, "ImportFormatOptions");
        this.zzXus();
        return zzYv.zzZkx(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Document getDocument() {
        return this.zzYGH;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzYGH) {
            return;
        }
        this.zzYGH = value;
        this.zzW2A(null);
        this.zzXwG = new zzWGU();
        this.zzmF = null;
        this.zzXG1 = null;
        this.zzYae = null;
        this.zzYIe = new zzok();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzYae == null) {
            DocumentBuilder documentBuilder = this;
            this.zzYae = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzYae;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        if (this.zzXJv == null) {
            DocumentBuilder documentBuilder = this;
            this.zzXJv = new ParagraphFormat(documentBuilder, documentBuilder.getDocument().getStyles());
        }
        return this.zzXJv;
    }

    public ListFormat getListFormat() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().getListFormat();
        }
        return null;
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzYCa == null) {
            this.zzYCa = new RowFormat(this);
        }
        return this.zzYCa;
    }

    public CellFormat getCellFormat() {
        if (this.zzWSE == null) {
            this.zzWSE = new CellFormat(this);
        }
        return this.zzWSE;
    }

    final void zzYcP(Node node) {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() {
        zzWGU zzWGU2;
        if (this.getCurrentParagraph() != null) {
            zzWGU zzWGU3 = this.getCurrentParagraph().zzxd();
            zzWGU2 = (zzWGU)zzWGU3.zzZrq();
        } else {
            zzWGU2 = this.zzWLG();
        }
        zzWGU zzWGU4 = zzWGU2;
        this.zzLM().push(new zzZkx(this.zzWLG(), zzWGU4));
    }

    public void popFont() {
        zzok<zzZkx> zzok2 = this.zzLM();
        if (zzok2.size() > 0) {
            zzZkx zzZkx2 = (zzZkx)this.zzLM().pop();
            this.zzZkx(zzZkx2.zzWiU(), false);
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zzZWw(zzZkx2.zzJL());
            }
        }
    }

    final void zzFb() {
        this.zzZME().push(this.zzWLG());
    }

    final void zzXNU() {
        zzok<zzWGU> zzok2 = this.zzZME();
        if (zzok2.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzZkx((zzWGU)documentBuilder.zzZME().pop(), false);
        }
    }

    final void zzXML() {
        this.zz1U().push(this.zzEu());
    }

    final void zzXLC() {
        zzok<zzXxI> zzok2 = this.zz1U();
        if (zzok2.size() > 0) {
            zzXxI zzXxI2 = (zzXxI)this.zz1U().pop();
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zzZkx(zzXxI2);
            }
        }
    }

    private zzYLL zzAt(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzYRP(88);
        zzYHx zzYHx2 = new zzYHx();
        zzYHx2.setTarget(string2);
        zzYHx2.setScreenTip(string3);
        if (bl) {
            zzYHx2.setSubAddress(string);
        } else {
            zzYHx2.setAddress(zzWgN.zzWrn(string));
            zzYHx2.setSubAddress(zzWgN.zzYcu(string));
        }
        this.zzZYZ(zzYHx2.zz33());
        FieldSeparator fieldSeparator = this.zzXtM(88);
        return new zzYLL(fieldStart, fieldSeparator, null);
    }

    final zzYLL zzY0W(String string, String string2, String string3) {
        boolean bl = zzWgN.zzZ4M(string);
        String string4 = bl ? zzWgN.zzYcu(string) : string;
        return this.zzAt(string4, bl, string2, string3);
    }

    final zzYLL zzZkx(zzYHx zzYHx2) {
        FieldStart fieldStart = this.zzYRP(88);
        this.zzZYZ(zzYHx2.zz33());
        FieldSeparator fieldSeparator = this.zzXtM(88);
        return new zzYLL(fieldStart, fieldSeparator, null);
    }

    final FieldEnd zzW2c() {
        return this.zz11(88, true);
    }

    final zzWGU zzWLG() {
        zzWGU zzWGU2 = this.zzXwG;
        return (zzWGU)zzWGU2.zzZrq();
    }

    final zzXxI zzEu() {
        zzXxI zzXxI2 = this.zzYC();
        return (zzXxI)zzXxI2.zzZrq();
    }

    final zzWq0 zz4F() {
        zzWq0 zzWq02 = this.zzZIT();
        return (zzWq0)zzWq02.zzZrq();
    }

    final zzVPb zzXke() {
        zzVPb zzVPb2 = this.zzBS();
        return (zzVPb)zzVPb2.zzZrq();
    }

    public boolean isAtStartOfParagraph() {
        if (this.getCurrentParagraph() == null) {
            return false;
        }
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzRC(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzRC().getNodeType() == 8;
    }

    public boolean isAtEndOfStructuredDocumentTag() {
        return this.zznh && this.zzRC().getNodeType() == 28;
    }

    private void zzZZy(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: text");
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            switch (((StructuredDocumentTag)this.zzRC()).getLevel()) {
                case 2: {
                    this.insertParagraph();
                    bl = false;
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot insert text at this cursor position.");
                }
            }
        }
        String string2 = zzW5M.zzY6A(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzZHJ(string2.substring(n4, n4 + n2));
                }
                switch (this.zz0N) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzXec(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzZHJ(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    public void insertNode(Node node) {
        this.zzXus();
        if (this.zzWLk() != null && this.zzWLk().zzXVo() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            this.getCurrentStructuredDocumentTag().appendChild(node);
            return;
        }
        this.zzRC().getParentNode().insertBefore(node, this.zzRC());
    }

    final void zzpY(int n) {
        this.zzWEs(true);
        this.zzZoh(n);
    }

    private void zzZoh(int n) {
        this.insertParagraph();
        zzZcB zzZcB2 = new zzZcB(this.getDocument());
        try {
            zzXUI zzXUI2 = this.getCurrentSection().zzYDq();
            zzXUI zzXUI3 = (zzXUI)zzXUI2.zzZrq();
            Section section = new Section(this.zzYGH, zzXUI3);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzYGH));
            this.zzYGH.insertAfter(section, this.getCurrentSection());
            section.getBody().zzAt(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzZcB2.dispose();
        }
    }

    final FieldStart zzYRP(int n) {
        this.zzXus();
        return zzYAm.zzZkx(n, this.zzWLG(), this.zzIp(), this.zzXeH(), this.zzXeH() == null);
    }

    final Run zzZYZ(String string) {
        return zzYAm.zzAt(string, this.zzWLG(), this.zzIp(), this.zzXeH(), this.zzXeH() == null);
    }

    final FieldEnd zz11(int n, boolean bl) {
        return zzYAm.zzAt(n, bl, this.zzWLG(), this.zzIp(), this.zzXeH(), this.zzXeH() == null);
    }

    final FieldSeparator zzXtM(int n) {
        return zzYAm.zzAt(n, this.zzWLG(), this.zzIp(), this.zzXeH(), this.zzXeH() == null);
    }

    private FormField zzX45(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzYGH, new zzX0d(), this.zzWLG());
        CompositeNode compositeNode = node == null ? this.zzIp() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzWEs(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzWLk() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzXGk(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzZHJ(String string) {
        if (this.zzVUx(string)) {
            zzKJ zzKJ2 = new zzKJ(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzWyA zzWyA2 : zzKJ2.zzYOq(this.getParagraphFormat().getBidi())) {
                zzW2A zzW2A2 = zzW2A.zzXvU(zzWyA2.zzZkJ());
                zzWGU zzWGU2 = this.zzWLG();
                zzWGU2.zzZ25(265, zzW2A2);
                if (zzWyA2.zzWqL()) {
                    zzWGU2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzYGH, zzWyA2.getText(), zzWGU2);
                this.insertNode(run);
            }
            return;
        }
        this.zzXec(string);
    }

    private boolean zzVUx(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzYyw.zzY5m(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzZkx(zzWGU zzWGU2, boolean bl) {
        zzWGU zzWGU3;
        if (bl) {
            zzWGU zzWGU4 = zzWGU2;
            zzWGU3 = (zzWGU)zzWGU4.zzZrq();
        } else {
            zzWGU3 = zzWGU2;
        }
        this.zzXwG = zzWGU3;
    }

    final void zzL9() {
        this.zzXwG.clear();
    }

    final void zzpG() {
        if (this.zzZM0() != null) {
            zzVPb zzVPb2;
            zzVPb zzVPb3 = zzVPb2 = this.zzZM0().zzBS();
            this.zzX0o = (zzVPb)zzVPb3.zzZrq();
            zzVPb2.zzAt(this.zzX0o);
        }
    }

    private Shape zzZkx(String string, boolean bl, boolean bl2, zzXvD zzXvD2, zzXJB zzXJB2) throws Exception {
        if (zzXJB2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        Shape shape = this.zzZkx(zzXvD2, bl2, zzXJB2, string);
        zzZTF zzZTF2 = zzWj8.zzZkx(string, bl, bl2, zzXJB2);
        return DocumentBuilder.zzZkx(string, bl, shape, zzXJB2.zzZPv, zzZTF2);
    }

    private Shape zzZkx(String string, boolean bl, String string2, String string3, zzXJB zzXJB2) throws Exception {
        if (zzXJB2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (string3 == null) {
            string3 = zzZnh.zzW3Y(string);
        }
        Shape shape = string2 != null ? this.zzX3B(string2, string3) : this.zzZkx(null, string3, zzXJB2);
        zzZTF zzZTF2 = zzWj8.zzZkx(string, bl, true, zzXJB2);
        return DocumentBuilder.zzZkx(string, bl, shape, zzXJB2.zzZPv, zzZTF2);
    }

    private static Shape zzZkx(String string, boolean bl, Shape shape, String string2, zzZTF zzZTF2) {
        if (shape == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: insertedOleImage");
        }
        shape.zzYqv(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzAt(zzZTF2);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzZkx(zzXvD zzXvD2, boolean bl, zzXJB zzXJB2, String string) throws Exception {
        if (zzXJB2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (zzXvD2 != null) {
            return this.zzae(zzXvD2);
        }
        if (!bl) {
            return this.zzr1(zzWj8.zzZL2().get("normal"));
        }
        String string2 = string != null ? zzZnh.zzW3Y(string) : zzWj8.zzWgb(zzXJB2.zzZ6G);
        return this.zzZkx(zzXJB2, string2);
    }

    private Shape zzZkx(String string, String string2, zzXJB zzXJB2) throws Exception {
        if (zzXJB2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (string2 == null) {
            string2 = zzWj8.zzWgb(zzXJB2.zzZ6G);
        }
        if (string != null) {
            return this.zzX3B(string, string2);
        }
        return this.zzZkx(zzXJB2, string2);
    }

    private Shape zzZkx(zzXJB zzXJB2, String string) throws Exception {
        if (zzXJB2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        byte[] byArray = zzWj8.zzYcR(zzXJB2.zzZ6G);
        zzXEy zzXEy2 = new zzXEy(byArray, null, string, this.getDocument().zzXQe());
        return this.zzr1(zzXEy2.zzZ63());
    }

    private Shape zzX3B(String string, String string2) throws Exception {
        zzXEy zzXEy2 = new zzXEy(string, string2, this.getDocument().zzXQe());
        return this.zzr1(zzXEy2.zzZ63());
    }

    private Shape zzae(zzXvD zzXvD2) throws Exception {
        byte[] byArray = zz7j.zzYnZ(zzXvD2);
        return this.zzr1(byArray);
    }

    private Shape zzr1(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzYGH, 1);
        shape.zzYqv(75);
        shape.zzZkx(this.zzWLG());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzat(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private void zzZkx(CompositeNode compositeNode, int n) {
        if (n >= 0) {
            this.zzAt(compositeNode, n);
            return;
        }
        this.zzZOm(compositeNode, n);
    }

    private void zzAt(CompositeNode compositeNode, int n) {
        zzWON zzWON2 = zzWON.zzWyE(compositeNode);
        Node node = null;
        while (node != compositeNode) {
            int n2;
            int n3;
            zzWON2.zzZkx(null, true, true, true, false, true);
            node = zzWON2.getNode();
            if (zzWON2.zzZ3q() && (!node.isComposite() || node.zzW0f() != 6 || n != 0)) continue;
            int n4 = n3 = node.isComposite() ? ((CompositeNode)node).zzZiJ().length() : node.getTextLength();
            if (!zzWON2.zzZ3q() && n3 == 0 && node.isComposite() && node != compositeNode || (n2 = n) != 0 && (n -= n3) >= 0) continue;
            if (!zzWON2.zzZ3q() && node == compositeNode && compositeNode.getNodeType() == 28) {
                this.zzZkx((StructuredDocumentTag)compositeNode);
                return;
            }
            this.zzZkx(null, node);
            this.zzWDo = n2;
            return;
        }
        throw new IllegalStateException("The character index is too large.");
    }

    private void zzZkx(StructuredDocumentTag structuredDocumentTag) {
        this.zzW2A(structuredDocumentTag);
        this.zznh = true;
        this.zzWDo = 0;
        zzWGU zzWGU2 = structuredDocumentTag.zzWNM();
        switch (structuredDocumentTag.zzW0f()) {
            case 6: {
                Node node;
                for (node = structuredDocumentTag.zzZTo(); node != null && !(node instanceof Inline); node = node.getPreviousSibling()) {
                }
                if (node == null) break;
                zzWGU2 = ((Inline)node).zzWiU();
                break;
            }
            case 3: {
                Paragraph paragraph = (Paragraph)structuredDocumentTag.getChild(8, -1, true);
                if (paragraph == null) break;
                zzWGU2 = paragraph.zzxd();
                break;
            }
            default: {
                return;
            }
        }
        this.zzZkx(zzWGU2, true);
    }

    private void zzZOm(CompositeNode compositeNode, int n) {
        zzWON zzWON2 = zzWON.zzYbD(compositeNode);
        while (zzWON2.getNode() != compositeNode || !zzWON2.zzZ3q()) {
            int n2;
            Node node = zzWON2.getNode();
            int n3 = n2 = node.isComposite() ? ((CompositeNode)node).zzZiJ().length() : node.getTextLength();
            if ((n += n2) >= 0) {
                this.zzZkx(null, node);
                this.zzWDo = n;
                return;
            }
            while (zzWON2.zzZkx(null, false, true, true, false, true) && zzWON2.zzZ3q() && zzWON2.getNode() != compositeNode) {
            }
        }
        throw new IllegalStateException("The character index is too small.");
    }

    private void zzXus() {
        int n = this.zzWDo;
        if (n == 0) {
            return;
        }
        this.zzWDo = 0;
        Run run = zz7j.zzZkx((Object)this.getCurrentNode(), Run.class);
        if (run != null) {
            run.zzZbI(n);
        }
    }

    private Run zzXec(String string) {
        Run run = new Run(this.zzYGH, string, this.zzWLG());
        this.insertNode(run);
        return run;
    }

    final boolean zzVYm() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzZ3O() {
        return this.zz0N;
    }

    final void zzZab(int n) {
        this.zz0N = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zzRC();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzRC();
        }
        return (Paragraph)this.zzRC().getAncestor(8);
    }

    public StructuredDocumentTag getCurrentStructuredDocumentTag() {
        if (this.isAtEndOfStructuredDocumentTag()) {
            return (StructuredDocumentTag)this.zzRC();
        }
        return (StructuredDocumentTag)this.zzRC().getAncestor(28);
    }

    public Story getCurrentStory() {
        return (Story)this.zzRC().getAncestor(Story.class);
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzVRg zzWLk() {
        zzok<zzVRg> zzok2 = this.zzYIe;
        if (zzok2.size() > 0) {
            return (zzVRg)this.zzYIe.peek();
        }
        return null;
    }

    private Cell zzZM0() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zz82();
    }

    private CompositeNode zzIp() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return (CompositeNode)this.zzRC();
        }
        return this.zzRC().getParentNode();
    }

    private Node zzXeH() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zzRC();
    }

    private zzok<zzWGU> zzZME() {
        if (this.zzmF == null) {
            this.zzmF = new zzok();
        }
        return this.zzmF;
    }

    private zzok<zzXxI> zz1U() {
        if (this.zzXG1 == null) {
            this.zzXG1 = new zzok();
        }
        return this.zzXG1;
    }

    private zzok<zzZkx> zzLM() {
        if (this.zzWFA == null) {
            this.zzWFA = new zzok();
        }
        return this.zzWFA;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzXwG.zzXe(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int key, int revisionsView) {
        return this.zzXwG.zzZG3(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzX5D(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzX5D(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzXwG.zzZ25(fontAttr, value);
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzZMG()) {
            this.getCurrentParagraph().zzxd().zzZ25(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzXwG.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzXwG.clear();
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzZMG()) {
            this.getCurrentParagraph().zzxd().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key) {
        return this.zzYC().zzXe(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key, int revisionsView) {
        return this.zzYC().zzZG3(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedParaAttr(int key) {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zzWjp(key, 0);
        }
        return this.getDocument().getStyles().zzsy().zzXrc(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchParaAttr(int key) {
        DocumentBuilder documentBuilder = this;
        Object object = documentBuilder.getDirectParaAttr(key);
        if (object != null) {
            return object;
        }
        return documentBuilder.fetchInheritedParaAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setParaAttr(int key, Object value) {
        if (this.getCurrentParagraph() != null) {
            this.getCurrentParagraph().setParaAttr(key, value);
            return;
        }
        this.zzYC().zzZ25(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeParaAttr(int key) {
        this.zzYC().remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearParaAttrs() {
        this.zzYC().clear();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzZIT().zzXe(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzZIT().zzXrc(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzZIT().zzVPB(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzZIT().zzZ25(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzZIT().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzZIT().clear();
        zzWq0.zzYZ().zzAt(this.zzZIT());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzBS().zzXe(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzBS().zzXrc(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzBS().zzVPB(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zz7j.zzZkx(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzZM0() != null ? this.zzZM0().getCellFormat() : this.getCellFormat();
            border.zzZkx(cellFormat);
        }
        this.zzBS().zzZ25(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzBS().clear();
    }

    private Node zzRC() {
        Node node = this.zzYaa != null && this.zzYaa.getParentNode() == null ? this.zzW0q : this.zzYaa;
        if (node != null && node.zzW0f() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        this.zznh = this.zznh && node != null && node.getNodeType() == 28;
        return node;
    }

    private void zzW2A(Node node) {
        this.zzYaa = node;
        if (this.zzYaa != null) {
            this.zzW0q = this.zzYaa.getParentNode();
        }
        this.zznh = false;
    }

    private zzXxI zzYC() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zzYC();
        }
        if (this.zzYo9 == null) {
            this.zzYo9 = new zzXxI();
        }
        return this.zzYo9;
    }

    private zzWq0 zzZIT() {
        if (this.zzWLk() != null && this.zzWLk().zzXVo() == 1) {
            return this.zzZZV;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzZIT();
        }
        return this.zzZZV;
    }

    private zzVPb zzBS() {
        if (this.zzWLk() != null && this.zzWLk().zzXVo() != 3) {
            return this.zzX0o;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zz82().zzBS();
        }
        return this.zzX0o;
    }

    static final class zzZkx {
        private zzWGU zzXwG;
        private zzWGU zzXxc;

        public zzZkx(zzWGU zzWGU2, zzWGU zzWGU3) {
            this.zzXwG = zzWGU2;
            this.zzXxc = zzWGU3;
        }

        public final zzWGU zzWiU() {
            return this.zzXwG;
        }

        public final zzWGU zzJL() {
            return this.zzXxc;
        }
    }
}

