/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zz5V;
import com.aspose.words.internal.zz7j;
import com.aspose.words.internal.zzX4t;
import com.aspose.words.internal.zzXvD;
import com.aspose.words.internal.zzZ1v;
import com.aspose.words.internal.zzZrf;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzZDs;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzZQC = new HashMap();
    private static HashMap<Integer, Integer> zzWpN = new HashMap();
    private static HashMap<Integer, Integer> zzXUz = new HashMap();
    private static HashMap<Integer, Integer> zzYF0 = new HashMap();
    private static HashMap<Integer, Integer> zzWSX = new HashMap();
    private static HashMap<Integer, Integer> zzDP = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zz7j.zzZOm(fileName, "fileName");
        try (zzX4t zzX4t2 = zz7j.zzQj(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzXSq(zzX4t2);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzXSq(zz5V.zzZkx(stream));
    }

    static FileFormatInfo zzXSq(zzXvD zzXvD2) throws Exception {
        if (zzXvD2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: stream");
        }
        try {
            zzZDs zzZDs2 = new zzZDs();
            zzXvD zzXvD3 = zzXvD2;
            zzZDs zzZDs3 = zzZDs2;
            return zzZDs2.zzAt(zzXvD3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzZOm(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzF(zzZ1v.zzZNS(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzZnu(zzZ1v.zzZNS(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzZrf.zzZLW(string = zzZ1v.zzXN4(FileFormatUtil.zzYZD(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzF(FileFormatUtil.zzXz5(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzZnu(FileFormatUtil.zzYZD(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzZ1v.zzXN4(FileFormatUtil.zzXz5(saveFormat));
        if (zzZrf.zzZLW(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: extension");
        }
        return FileFormatUtil.zzZnu(zzZ1v.zzXEN(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzZ1v.zzXN4(FileFormatUtil.zzW4r(imageType));
    }

    static Exception zzZOm(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zz02(int n) {
        return zzZ1v.toString(FileFormatUtil.zzXz5(n));
    }

    static int zzZnu(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zz7j.zzZkx(zzWSX, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzWWN(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zz7j.zzZkx(zzDP, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzQo(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzYZD(int n) {
        return zz7j.zzZkx(zzZQC, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzXz5(int n) {
        return zz7j.zzZkx(zzWpN, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzW4r(int n) {
        return zz7j.zzZkx(zzXUz, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzF(int n) {
        return zz7j.zzZkx(zzYF0, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zz8k(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zz7j.zzAt(zzWSX, Integer.valueOf(n), Integer.valueOf(n2));
            zz7j.zzAt(zzWpN, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzYF0.containsKey(n)) {
                zz7j.zzAt(zzYF0, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zz7j.zzAt(zzZQC, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zz7j.zzAt(zzDP, Integer.valueOf(n), Integer.valueOf(n4));
            zz7j.zzAt(zzXUz, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zz8k(11, 10, 10, 1);
        FileFormatUtil.zz8k(11, 0, 0, 1);
        FileFormatUtil.zz8k(12, 11, 11, 1);
        FileFormatUtil.zz8k(13, 20, 20, 1);
        FileFormatUtil.zz8k(13, 0, 254, 1);
        FileFormatUtil.zz8k(14, 21, 21, 1);
        FileFormatUtil.zz8k(15, 22, 22, 1);
        FileFormatUtil.zz8k(16, 23, 23, 1);
        FileFormatUtil.zz8k(18, 24, 24, 1);
        FileFormatUtil.zz8k(19, 25, 25, 1);
        FileFormatUtil.zz8k(20, 26, 26, 1);
        FileFormatUtil.zz8k(21, 27, 27, 1);
        FileFormatUtil.zz8k(24, 30, 30, 1);
        FileFormatUtil.zz8k(17, 31, 31, 1);
        FileFormatUtil.zz8k(25, 50, 50, 1);
        FileFormatUtil.zz8k(26, 45, 255, 1);
        FileFormatUtil.zz8k(27, 51, 51, 1);
        FileFormatUtil.zz8k(28, 54, 52, 1);
        FileFormatUtil.zz8k(29, 0, 53, 1);
        FileFormatUtil.zz8k(31, 53, 54, 1);
        FileFormatUtil.zz8k(22, 60, 60, 1);
        FileFormatUtil.zz8k(23, 61, 61, 1);
        FileFormatUtil.zz8k(34, 40, 64, 1);
        FileFormatUtil.zz8k(41, 47, 255, 1);
        FileFormatUtil.zz8k(42, 48, 255, 1);
        FileFormatUtil.zz8k(35, 41, 255, 1);
        FileFormatUtil.zz8k(36, 46, 255, 1);
        FileFormatUtil.zz8k(38, 42, 255, 1);
        FileFormatUtil.zz8k(37, 44, 255, 1);
        FileFormatUtil.zz8k(30, 52, 55, 1);
        FileFormatUtil.zz8k(32, 70, 62, 1);
        FileFormatUtil.zz8k(33, 73, 63, 1);
        FileFormatUtil.zz8k(39, 71, 255, 1);
        FileFormatUtil.zz8k(8, 100, 255, 1);
        FileFormatUtil.zz8k(9, 105, 255, 1);
        FileFormatUtil.zz8k(6, 101, 255, 6);
        FileFormatUtil.zz8k(7, 102, 255, 7);
        FileFormatUtil.zz8k(5, 104, 255, 5);
        FileFormatUtil.zz8k(4, 0, 255, 4);
        FileFormatUtil.zz8k(3, 0, 255, 3);
        FileFormatUtil.zz8k(40, 72, 255, 1);
        FileFormatUtil.zz8k(2, 103, 255, 2);
    }
}

