/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zz7j;
import com.aspose.words.internal.zzok;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzWON;
import com.aspose.words.zzYAm;
import com.aspose.words.zzYWd;
import com.aspose.words.zzYbV;
import com.aspose.words.zzgI;
import java.util.HashMap;

public abstract class Node
implements Cloneable {
    private Node zzKj;
    private Node zzXUG;
    private Node zzYLt;
    private int zzZMd;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this();
        this.zzZOm(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzKj == null) {
            return null;
        }
        if (this.zzKj.getNodeType() == 38) {
            return null;
        }
        return (CompositeNode)this.zzKj;
    }

    final CompositeNode zzZmJ() {
        if (zzYAm.zzYjT(this.getParentNode())) {
            return this.getParentNode().zzZmJ();
        }
        return this.getParentNode();
    }

    final CompositeNode zztg() {
        if (zzYAm.zzYjT(this.getParentNode()) || zzYAm.zzW3w(this.getParentNode())) {
            return this.getParentNode().zztg();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this.zzKj != null) {
            return this.zzKj.getDocument();
        }
        return null;
    }

    final Document zzY3E() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzWP3() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zzWni();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzYLt;
    }

    final Node zzeO() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getPreviousSibling()) != null && zzYAm.zzWgN((node = node2).getNodeType())) {
        }
        return node2;
    }

    final Node zzXuN() {
        Node node = zzYAm.zzWvh(this.getPreviousSibling(), false);
        if (node == null && zzYAm.zzYjT(this.getParentNode())) {
            node = this.getParentNode().zzXuN();
        }
        return node;
    }

    final Node zzcJ() {
        Node node = zzYAm.zzVPT(this.getNextSibling(), false);
        if (node == null && zzYAm.zzYjT(this.getParentNode())) {
            node = this.getParentNode().zzcJ();
        }
        return node;
    }

    final CompositeNode zzZ3S() {
        Node node = this;
        while ((node = node.zzXuN()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzZQD() {
        Node node = this;
        while ((node = node.zzcJ()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzXUG;
    }

    final Node zzZWr() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getNextSibling()) != null && zzYAm.zzWgN((node = node2).getNodeType())) {
        }
        return node2;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzX6() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getLastChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzZXM() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getFirstChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzX3h() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzYAm.zzYKT(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzH2() {
        return this.zzXUG;
    }

    final void zzWFh(Node node) {
        this.zzXUG = node;
    }

    final Node zzW0N() {
        return this.zzYLt;
    }

    final void zzZwi(Node node) {
        this.zzYLt = node;
    }

    final Node zzW9j() {
        Node node = this;
        if (node.zzXUG != null) {
            node = this;
            return node.zzXUG;
        }
        return this.getParentNode();
    }

    final int zzW0f() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zzYAm.zzXmx(this);
        boolean bl2 = zzYAm.zzYsr(this);
        boolean bl3 = zzYAm.zzBx(this);
        boolean bl4 = zzYAm.zzYu6(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzW0f() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 38;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzW0f() != 3 && n2 != 6 && n != 27 && n != 35)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzZkx(isCloneChildren, new zzZkx(this));
    }

    Node zzZkx(boolean bl, zzgI zzgI2) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzKj != null) {
            node.zzKj = this.getDocument().zzZNX();
        }
        node.zzXUG = null;
        node.zzYLt = null;
        if (zzgI2 != null) {
            zzgI2.zzYma(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzZ6A(StringBuilder stringBuilder) {
        zz7j.zzAt(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isInstance(compositeNode)) continue;
            return compositeNode;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzWn(Node node) {
        this.zzKj = node != null ? node : this.getDocument().zzZNX();
    }

    final void zzZOm(DocumentBase documentBase) {
        this.zzKj = documentBase != null ? documentBase.zzZNX() : null;
    }

    final boolean zzZHp(Node node) {
        if (node == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzYbm() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzW9n(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzWu7(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzsf(Node node, int n) {
        for (Node node2 = this.nextPreOrder(node); node2 != null; node2 = node2.nextPreOrder(node)) {
            if (node2.getNodeType() != 8) continue;
            return node2;
        }
        return null;
    }

    final Node zzZ6A(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzWEA(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    public String toString(int saveFormat) throws Exception {
        zzYbV zzYbV2 = zzYAm.zzXgy(saveFormat);
        return zzYbV2.zz0W(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzYbV zzYbV2 = zzYAm.zzAt(saveOptions);
        return zzYbV2.zz0W(this);
    }

    final Node zzXQp(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzYAm.zzZRw(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zzWON zzYsS() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zzWON.zzYbD(node);
        }
        return zzWON.zzWyE(this.getParentNode());
    }

    final zzWON zzZ6u() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zzWON.zzWyE(node);
        }
        return zzWON.zzYbD(this.getParentNode());
    }

    final boolean zzYIx(Node node) {
        return Node.zzX45(this, node);
    }

    final boolean zzZAF() {
        return this.getAncestor(1) == null;
    }

    static Node zzYcP(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zzok<Node> zzok2 = Node.zzZTl(node);
        zzok<Node> zzok3 = Node.zzZTl(node2);
        return Node.zzZkx(zzok2, zzok3);
    }

    static boolean zzX45(Node node, Node node2) {
        zzok<Node> zzok2;
        if (node == null || node2 == null) {
            return false;
        }
        zzok<Node> zzok3 = Node.zzZTl(node);
        Node node3 = Node.zzZkx(zzok3, zzok2 = Node.zzZTl(node2));
        if (node3 == null) {
            return false;
        }
        zzok<Node> zzok4 = zzok3;
        if (zzok4.size() == 0 || (zzok4 = zzok2).size() == 0) {
            zzok4 = zzok2;
            boolean bl = zzok4.size() > 0;
            return bl;
        }
        Object e = zzok3.peek();
        Object e2 = zzok2.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes()) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zzok<Node> zzZTl(Node node) {
        zzok<Node> zzok2 = new zzok<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzok2.push(node2);
        }
        return zzok2;
    }

    private static Node zzZkx(zzok<Node> zzok2, zzok<Node> zzok3) {
        Node node = null;
        while (zzok2.peek() == zzok3.peek()) {
            node = (Node)zzok2.pop();
            zzok3.pop();
            zzok<Node> zzok4 = zzok2;
            if (zzok4.size() != 0 && (zzok4 = zzok3).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "StructuredDocumentTagRangeStart";
            }
            case 30: {
                return "StructuredDocumentTagRangeEnd";
            }
            case 31: {
                return "GlossaryDocument";
            }
            case 32: {
                return "BuildingBlock";
            }
            case 33: {
                return "CommentRangeStart";
            }
            case 34: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 35: {
                return "OfficeMath";
            }
            case 36: {
                return "SubDocument";
            }
            case 37: {
                return "System";
            }
            case 38: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    public int getCustomNodeId() {
        return this.zzZMd;
    }

    public void setCustomNodeId(int value) {
        this.zzZMd = value;
    }

    public String toString() {
        return super.toString();
    }

    public void dd() {
    }

    final Node zzY5m(int ... nArray) {
        Node node;
        for (node = this.getNextSibling(); node != null && !node.zzYsr(nArray); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzZRw(int ... nArray) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && !node.zzYsr(nArray); node = node.getPreviousSibling()) {
        }
        return node;
    }

    private boolean zzYsr(int ... nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.getNodeType() != n2) continue;
            return true;
        }
        return false;
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    static final class zzZkx
    implements zzgI {
        private Node zzZpF;
        private HashMap<Integer, Integer> zzXMS;

        zzZkx(Node node) {
            this.zzZpF = node;
        }

        @Override
        public final void zzYma(Node node, Node node2) {
            if (node == this.zzZpF) {
                return;
            }
            if (node2.getNodeType() != 19 && node2.getNodeType() != 33 && node2.getNodeType() != 34) {
                return;
            }
            zzYWd zzYWd2 = (zzYWd)((Object)node2);
            if (this.zzXMS == null) {
                this.zzXMS = new HashMap();
            }
            RefInt refInt = new RefInt(0);
            boolean bl = !zz7j.zzZkx(this.zzXMS, Integer.valueOf(zzYWd2.getIdInternal()), refInt);
            int n = refInt.get();
            if (bl) {
                n = node2.getDocument().zzkO();
                zz7j.zzAt(this.zzXMS, Integer.valueOf(zzYWd2.getIdInternal()), Integer.valueOf(n));
            }
            zzYWd2.setIdInternal(n);
            RefInt refInt2 = new RefInt(0);
            boolean bl2 = zz7j.zzZkx(this.zzXMS, Integer.valueOf(zzYWd2.getParentIdInternal()), refInt2);
            int n2 = refInt2.get();
            if (bl2) {
                zzYWd2.setParentIdInternal(n2);
            }
        }
    }
}

