/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IDocumentSavingCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzZ1v;
import com.aspose.words.internal.zzZnh;

public abstract class SaveOptions {
    private IDocumentSavingCallback zzYRx;
    private boolean zzYyH;
    boolean zz0G = false;
    boolean zzXKR = true;
    private boolean zzXhV = true;
    private boolean zzYxA = false;
    private boolean zzZMy;
    private boolean zzWZJ = true;
    private boolean zzXrZ;
    private String zzqX;
    private boolean zzYin;
    private boolean zzXqY = false;
    private int zzXj0 = 1;
    private int zzia = 1;
    private int zzYhB = 0;
    private String zzW5s = "";
    private boolean zzYor = true;
    private boolean zzei = true;
    private boolean zzWsI;
    private boolean zzYBS;
    private int zzZ1h = 0;
    private boolean zzZnQ = true;
    private boolean zzXwx = false;

    protected SaveOptions() {
    }

    final boolean zzYWB() {
        return this.zzZMy;
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzZq4() {
        return false;
    }

    boolean zzYyF() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzWZJ;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzWZJ = value;
    }

    public String getTempFolder() {
        return this.zzqX;
    }

    public void setTempFolder(String value) {
        this.zzqX = value;
    }

    public boolean getPrettyFormat() {
        return this.zzXrZ;
    }

    public void setPrettyFormat(boolean value) {
        this.zzXrZ = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzYin;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzYin = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzXqY;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzXqY = value;
    }

    @Deprecated
    public boolean getUpdateSdtContent() {
        return this.zz0G;
    }

    @Deprecated
    public void setUpdateSdtContent(boolean value) {
        this.zz0G = value;
    }

    public int getDmlRenderingMode() {
        return this.zzXj0;
    }

    public void setDmlRenderingMode(int value) {
        this.zzXj0 = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzYhB;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzYhB = value;
    }

    public int getImlRenderingMode() {
        return this.zzia;
    }

    public void setImlRenderingMode(int value) {
        this.zzia = value;
    }

    public String getDefaultTemplate() {
        return this.zzW5s;
    }

    public void setDefaultTemplate(String value) {
        this.zzW5s = value;
    }

    public boolean getUpdateFields() {
        return this.zzYor;
    }

    public void setUpdateFields(boolean value) {
        this.zzYor = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzWsI;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzWsI = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzYBS;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzYBS = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzXwx;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzXwx = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzYxA;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzYxA = value;
    }

    final boolean zzYQC() {
        return this.zzei;
    }

    final boolean zzW7d() {
        return this.zzZnQ;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzZnu(zzZ1v.zzXEN(zzZnh.zztw(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzZ1h;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzZ1h = value;
    }

    public IDocumentSavingCallback getProgressCallback() {
        return this.zzYRx;
    }

    public void setProgressCallback(IDocumentSavingCallback value) {
        this.zzYRx = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzYyH;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzYyH = value;
    }

    final boolean zzYCo() {
        return this.zzXhV;
    }

    final void zzWlW(boolean bl) {
        this.zzXhV = false;
    }
}

