/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zz7j;
import com.aspose.words.internal.zzWP;
import com.aspose.words.zzVRZ;
import com.aspose.words.zzXUI;
import com.aspose.words.zzgI;

public final class Section
extends CompositeNode<Node>
implements zzVRZ {
    private zzXUI zzfB;
    private PageSetup zzXW5;
    private HeaderFooterCollection zzYzu;

    public Section(DocumentBase doc) {
        this(doc, new zzXUI());
    }

    Section(DocumentBase doc, zzXUI sectPr) {
        super(doc);
        this.zzfB = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzYzu == null) {
            this.zzYzu = new HeaderFooterCollection(this);
        }
        return this.zzYzu;
    }

    public final PageSetup getPageSetup() {
        if (this.zzXW5 == null) {
            Section section = this;
            this.zzXW5 = new PageSetup(section, section.getDocument().zz2D(), this.getDocument().getStyles(), new zzZkx(this));
        }
        return this.zzXW5;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzYKw();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zz8M(!value);
    }

    final zzXUI zzYDq() {
        return this.zzfB;
    }

    final void zzZOm(zzXUI zzXUI2) {
        this.zzfB = zzXUI2;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzZkx(boolean bl, zzgI zzgI2) {
        zzXUI zzXUI2;
        Section section = (Section)super.zzZkx(bl, zzgI2);
        zzXUI zzXUI3 = this.zzfB;
        section.zzfB = zzXUI2 = (zzXUI)zzXUI3.zzZrq();
        section.zzXW5 = null;
        section.zzYzu = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzZkx(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionStart(this);
    }

    @Override
    final int zzAt(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzYma(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzYma(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzZv5(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzQN(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzZv5(n) == null;
            }
        }
        return false;
    }

    final void zzZOm(Shape shape, boolean bl) throws Exception {
        this.zzZkx(shape, 4, bl);
        this.zzZkx(shape, 0, bl);
        this.zzZkx(shape, 1, bl);
    }

    private void zzZkx(Shape shape, int n, boolean bl) throws Exception {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        Shape shape2 = (Shape)shape.deepClone(true);
        shape2.setId(shape2.getDocument().zzWwY());
        shape2.setName(zzWP.zzAt("{0}{1}", shape2.hasImage() ? "WordPictureWatermark" : "PowerPlusWaterMarkObject", shape2.getId()));
        headerFooter.getFirstParagraph().appendChild(shape2);
    }

    final boolean zzXeY() {
        boolean bl = false;
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzYay()) {
                if (!shape.zzWht()) continue;
                shape.remove();
                bl = true;
            }
        }
        return bl;
    }

    private void zzYma(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzAt(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzfB.zzXe(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zz2D().zzZ8d.zzXrc(key);
        }
        return zzXUI.zzZHJ(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzfB.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zz2D().zzZ8d.zzZ25(key, value);
            return;
        }
        this.zzfB.zzZ25(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzfB.clear();
    }

    final boolean zzYQb() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzXvn() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        return super.toString();
    }

    static final class zzZkx
    implements zzVRZ {
        private Section zzYsb;

        zzZkx(Section section) {
            this.zzYsb = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzZ0D().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzZ0D().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzZ0D().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzVRZ zzZ0D() {
            Document document = zz7j.zzZkx((Object)this.zzYsb.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzYsb;
        }
    }
}

