/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zz1u;
import com.aspose.words.internal.zz7j;
import com.aspose.words.internal.zzWP;
import com.aspose.words.internal.zzWs0;
import com.aspose.words.internal.zzYI9;
import com.aspose.words.internal.zzZrf;
import com.aspose.words.zzl0;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzYGH;
    private zzl0 zziT;

    Watermark(Document doc, zzl0 watermarkProvider) {
        this.zzYGH = doc;
        this.zziT = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzWOy(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzZkx(text, textWatermarkOptions, this.zzYGH);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zz7j.zzAt((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzYGH, 75);
        shape.getImageData().setImage(image);
        this.zzZkx(shape, options, this.zzYGH);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zz7j.zzAt((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzYGH, 75);
        shape.getImageData().setImage(imagePath);
        this.zzZkx(shape, options, this.zzYGH);
    }

    public final int getType() {
        Shape shape = this.zziT.get();
        if (shape == null) {
            return 2;
        }
        shape.zzWht();
        if (shape.zzZqz()) {
            return 0;
        }
        if (shape.zzKl()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zziT.add(shape);
    }

    public final void remove() {
        this.zziT.remove();
    }

    private static void zzWOy(String string) {
        if (string == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: text");
        }
        if (zzZrf.zzX3O(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zz7j.zzZkx(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzZkx(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzAt(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzLK(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzAt(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzXnf() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzXLA()) / d2) > (double)(f = pageSetup.zzWxZ())) {
            d = (double)f / d3;
        }
        shape.zzW3C(zzYI9.zzZOm(d2 * d, 2, 1));
        shape.zzsu(zzYI9.zzZOm(d3 * d, 2, 1));
    }

    private Shape zzZkx(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzZkx(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzLK(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzZkx(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzAG() ? 1.0f : textWatermarkOptions.getFontSize();
        zzWs0 zzWs02 = document.zzXQe().zzZOm(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzWs02.zzXmx(shape.getTextPath().getText());
        if (textWatermarkOptions.zzAG()) {
            l = Watermark.zzZkx(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzW3C(zzYI9.zzZOm(Float.intBitsToFloat(n), 2, 1));
        shape.zzsu(zzYI9.zzZOm(zz1u.zzZeQ(l), 2, 1));
    }

    private static long zzZkx(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzXLA();
        float f2 = pageSetup.zzWxZ();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zz1u.zzZeQ(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zz1u.zzX1E(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zz1u.zzZeQ(l) >= Float.intBitsToFloat(n)) {
            return zz1u.zzX1E(f2 / f3, f2);
        }
        float f6 = f;
        return zz1u.zzX1E(f6, f6 * f3);
    }

    private static void zzLK(Shape shape, String string) {
        shape.setName(zzWP.zzAt("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
        shape.setBehindText(true);
    }
}

