/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzWP;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzie = new ArrayList();
    private final Map<String, DataColumn> zzXOn = new HashMap<String, DataColumn>();
    private DataTable zzYBo;

    DataColumnCollection(DataTable table) {
        this.zzYBo = table;
    }

    public void add(DataColumn column) {
        if (zzWP.zzVZi(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzYNJ(column.getColumnName());
        if (this.zzXOn.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzYma(this.zzYBo);
        column.setOrdinal(this.zzie.size());
        this.zzie.add(column);
        this.zzXOn.put(string, column);
        this.zzYBo.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzYBo);
        this.add(dataColumn);
        return dataColumn;
    }

    public DataColumn add(String columnName, Class type, int columnMapping, boolean allowAutoIncrement, boolean allowDBNull) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzYBo);
        dataColumn.setColumnMapping(columnMapping);
        dataColumn.setAutoIncrement(allowAutoIncrement);
        dataColumn.setAllowDBNull(allowDBNull);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzWP.zzVZi(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzYNJ(columnName);
        DataColumn dataColumn = this.zzXOn.get(string);
        if (dataColumn != null) {
            int n = this.zzie.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzie.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzie.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzie.remove(n);
            this.zzXOn.remove(DataColumnCollection.zzYNJ(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzYBo.getRows()) {
                dataRow.remove(n);
            }
            this.zzYBo.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzie.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzie.iterator();
    }

    public void clear() {
        this.zzXOn.clear();
        this.zzie.clear();
    }

    final DataColumn[] zzVQz() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzie);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzZkx(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzie.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzie.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzYNJ(string);
            String string3 = DataColumnCollection.zzYNJ(dataColumn.getColumnName());
            this.zzXOn.remove(string3);
            this.zzXOn.put(string2, dataColumn);
            return;
        }
    }

    private static String zzYNJ(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

