/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzZE1;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzAt;
import com.aspose.words.net.System.Data.zzWiY;
import com.aspose.words.net.System.Data.zzYnZ;
import com.aspose.words.net.System.Data.zzZOm;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzZlA;
    private final DataColumnCollection zzX2r;
    private final ConstraintCollection zz4H;
    private final zzYnZ zzYSW;
    private ResultSet zzXq6;
    private String zzZ12;
    private DataSet zzZ4h;
    private String zzY2Y;
    private UniqueConstraint zzYvv;
    private boolean zzZG0;
    private final List<DataTableEventListener> zzWL3;
    private final Set<DataRow> zzYST;
    private DataRelationCollection zzWbB;

    public DataTable() {
        this.zzZlA = new DataRowCollection(this);
        this.zzX2r = new DataColumnCollection(this);
        this.zz4H = new ConstraintCollection(this);
        this.zzYSW = new zzYnZ(this);
        this.zzY2Y = "";
        this.zzZG0 = true;
        this.zzWL3 = new ArrayList<DataTableEventListener>();
        this.zzYST = new HashSet<DataRow>();
        this.zzWbB = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzZlA = new DataRowCollection(this);
        this.zzX2r = new DataColumnCollection(this);
        this.zz4H = new ConstraintCollection(this);
        this.zzYSW = new zzYnZ(this);
        this.zzY2Y = "";
        this.zzZG0 = true;
        this.zzWL3 = new ArrayList<DataTableEventListener>();
        this.zzYST = new HashSet<DataRow>();
        this.zzWbB = new DataRelationCollection();
        this.zzZ12 = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzAt.zzZkx(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzZlA = new DataRowCollection(this);
        this.zzX2r = new DataColumnCollection(this);
        this.zz4H = new ConstraintCollection(this);
        this.zzYSW = new zzYnZ(this);
        this.zzY2Y = "";
        this.zzZG0 = true;
        this.zzWL3 = new ArrayList<DataTableEventListener>();
        this.zzYST = new HashSet<DataRow>();
        this.zzWbB = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzXq6 = resultSet;
        this.zzZ12 = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzXq6 != null) {
            if (this.zzXq6.getStatement() != null) {
                this.zzXq6.getStatement().getConnection().close();
            }
            this.zzXq6 = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzZ12;
    }

    public void setTableName(String tableName) {
        this.zzZ12 = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzX2r.getCount();
    }

    public String getColumnName(int index) {
        return this.zzX2r.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzXq6;
    }

    public DataSet getDataSet() {
        return this.zzZ4h;
    }

    final void zzYma(DataSet dataSet) {
        this.zzZ4h = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzZ4h.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zzWbB.add(dataRelation);
        }
        return this.zzWbB;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzZ4h.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzZlA;
    }

    public DataColumnCollection getColumns() {
        return this.zzX2r;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zz4H;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzYvv == null) {
            return new DataColumn[0];
        }
        return this.zzYvv.getColumns();
    }

    final void zzYnZ(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzYvv != null) {
                this.zzYvv.zzZPA(false);
                this.getConstraints().remove(this.zzYvv);
                this.zzYvv = null;
            }
            return;
        }
        if (this.zzYvv != null && DataColumn.areColumnSetsTheSame(value, this.zzYvv.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzZkx(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzYvv != null) {
            this.zzYvv.zzZPA(false);
            this.getConstraints().remove(this.zzYvv);
            this.zzYvv = null;
        }
        UniqueConstraint.zzZkx(this.getConstraints(), uniqueConstraint);
        this.zzYvv = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzY2Y;
    }

    public void setNamespace(String namespace) {
        this.zzY2Y = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzZG0;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzZG0 = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzYST.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzAt.zzZkx(this.getResultSet(), this);
            zzAt.zzAt(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzZE1.zzYma(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzAt.zzLK(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzWL3.contains(listener)) {
            this.zzWL3.add(listener);
        }
    }

    public void removeEventListener(zzZOm listener) {
        if (this.zzWL3.contains(listener)) {
            this.zzWL3.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzWL3.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzYST.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzWL3) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzYST.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzWL3) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzYST.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzWL3) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzWL3) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzWL3) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzWiY zzZkx(zzAt[] zzAtArray) {
        DataColumn[] dataColumnArray = new DataColumn[zzAtArray.length];
        for (int i = 0; i < zzAtArray.length; ++i) {
            dataColumnArray[i] = zzAtArray[i].zzWIc();
        }
        DataTable dataTable = this;
        zzWiY zzWiY2 = dataTable.zzYSW.zzYma(dataColumnArray);
        if (zzWiY2 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzWiY2;
    }

    final zzYnZ zzWkW() {
        return this.zzYSW;
    }

    final Set<DataRow> zzYUw() {
        return this.zzYST;
    }
}

