/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphCollection;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.TableCollection;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzW9B;
import com.aspose.words.zzBt;
import com.aspose.words.zzWSb;
import com.aspose.words.zzXDz;
import com.aspose.words.zzYZC;
import com.aspose.words.zzYu2;
import com.aspose.words.zzYxQ;
import com.aspose.words.zzZDX;
import com.aspose.words.zzZNm;
import com.aspose.words.zzZg7;
import com.aspose.words.zzfd;

public class Cell
extends CompositeNode<Node>
implements zzXDz,
zzZDX {
    private zzYZC zzd9;
    private CellFormat zzXZc;
    private ParagraphCollection zzXWf;
    private TableCollection zzXU;

    public Cell(DocumentBase doc) {
        this(doc, new zzYZC());
    }

    Cell(DocumentBase doc, zzYZC cellPr) {
        super(doc);
        this.zzd9 = cellPr;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    public Cell getNextCell() {
        return (Cell)this.zzWLY();
    }

    public Cell getPreviousCell() {
        return (Cell)this.zzWD3();
    }

    public Row getParentRow() {
        return (Row)this.zzWNf();
    }

    public Paragraph getFirstParagraph() {
        return (Paragraph)this.getChild(8, 0, false);
    }

    public Paragraph getLastParagraph() {
        return (Paragraph)this.getChild(8, -1, false);
    }

    public boolean isFirstCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getFirstCell()) {
                return true;
            }
        }
        return false;
    }

    public boolean isLastCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getLastCell()) {
                return true;
            }
        }
        return false;
    }

    final int zzXSQ() {
        Row row = this.getParentRow();
        if (row != null) {
            return row.zzYV0(this, true);
        }
        return -1;
    }

    final int zzYIM() {
        if (this.getParentRow() != null) {
            return this.getParentRow().zzYIM();
        }
        return -1;
    }

    public CellFormat getCellFormat() {
        if (this.zzXZc == null) {
            this.zzXZc = new CellFormat(this);
        }
        return this.zzXZc;
    }

    public ParagraphCollection getParagraphs() {
        if (this.zzXWf == null) {
            this.zzXWf = new ParagraphCollection(this);
        }
        return this.zzXWf;
    }

    public TableCollection getTables() {
        if (this.zzXU == null) {
            this.zzXU = new TableCollection(this);
        }
        return this.zzXU;
    }

    final zzYZC zzke() {
        return this.zzd9;
    }

    final void zzZy(zzYZC zzYZC2) {
        this.zzd9 = zzYZC2;
    }

    @Override
    final Node zzZy(boolean bl, zzZg7 zzZg72) {
        zzYZC zzYZC2;
        Cell cell = (Cell)super.zzZy(bl, zzZg72);
        zzYZC zzYZC3 = this.zzd9;
        cell.zzd9 = zzYZC2 = (zzYZC)zzYZC3.zzWEt();
        cell.zzXZc = null;
        cell.zzXWf = null;
        cell.zzXU = null;
        return cell;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    public int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitCellStart(this);
    }

    @Override
    public int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitCellEnd(this);
    }

    public void ensureMinimum() {
        zzYu2.zzX3u(this);
    }

    @Override
    final boolean zzZbU(Node node) {
        return zzBt.zzs1(node);
    }

    final int zzYX8() {
        Row row = this.getParentRow();
        if (row == null) {
            return -1;
        }
        int n = -1;
        for (Cell cell = row.getFirstCell(); cell != null; cell = cell.getNextCell()) {
            if (cell.getCellFormat().getHorizontalMerge() != 2) {
                ++n;
            }
            if (cell != this) continue;
            return n;
        }
        return -1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzd9.zzYOL(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        Object object = this.zzd9.zzYOL(key);
        if (object == null) {
            return this.fetchInheritedCellAttr(key);
        }
        zzWSb zzWSb2 = zzW9B.zzZy(object, zzWSb.class);
        if (zzWSb2 != null && zzWSb2.isInheritedComplexAttr()) {
            return this.fetchInheritedCellAttr(key);
        }
        return object;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        Object object = this.zzYXu(key);
        if (object != null) {
            return object;
        }
        if (this.getParentRow() != null) {
            Row row = this.getParentRow();
            switch (key) {
                case 3070: {
                    return row.fetchRowAttr(4300);
                }
                case 3090: {
                    return row.fetchRowAttr(4020);
                }
                case 3080: {
                    return row.fetchRowAttr(4310);
                }
                case 3100: {
                    return row.fetchRowAttr(4320);
                }
                case 3110: {
                    return row.fetchRowAttr(this.getParentRow().isFirstRow() ? 4050 : 4090);
                }
                case 3120: {
                    return row.fetchRowAttr(this.isFirstCell() ? 4060 : 4100);
                }
                case 3130: {
                    return row.fetchRowAttr(this.getParentRow().isLastRow() ? 4070 : 4090);
                }
                case 3140: {
                    return row.fetchRowAttr(this.isLastCell() ? 4080 : 4100);
                }
            }
        }
        return zzYZC.zzfX(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        this.zzd9.zzZtV(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzd9.clear();
    }

    private Object zzYXu(int n) {
        Cell cell;
        if (this.getParentRow() == null || (cell = this).getParentRow().getParentTable() == null) {
            return null;
        }
        cell = this;
        TableStyle tableStyle = zzW9B.zzZy((Object)cell.getParentRow().getParentTable().getStyle(), TableStyle.class);
        if (tableStyle != null) {
            return tableStyle.zzZy(n, this);
        }
        return null;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzZNm getInsertRevision() {
        Cell cell = this;
        return cell.zzd9.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzZNm value) {
        Cloneable cloneable = this;
        zzZNm zzZNm2 = value;
        cloneable = cloneable.zzd9;
        ((zzYxQ)cloneable).zzZtV(14, zzZNm2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzZNm getDeleteRevision() {
        Cell cell = this;
        return cell.zzd9.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzZNm value) {
        Cloneable cloneable = this;
        zzZNm zzZNm2 = value;
        cloneable = cloneable.zzd9;
        ((zzYxQ)cloneable).zzZtV(12, zzZNm2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzfd getMoveFromRevision() {
        Cell cell = this;
        return cell.zzd9.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzfd value) {
        Cloneable cloneable = this;
        zzfd zzfd2 = value;
        cloneable = cloneable.zzd9;
        ((zzYxQ)cloneable).zzZtV(13, zzfd2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzfd getMoveToRevision() {
        Cell cell = this;
        return cell.zzd9.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzfd value) {
        Cloneable cloneable = this;
        zzfd zzfd2 = value;
        cloneable = cloneable.zzd9;
        ((zzYxQ)cloneable).zzZtV(15, zzfd2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Cell cell = this;
        cell.zzd9.remove(13);
        cell = this;
        cell.zzd9.remove(15);
    }

    final zzYZC zzXak(boolean bl) {
        Cell cell;
        TableStyle tableStyle;
        zzYZC zzYZC2 = new zzYZC();
        this.zzZy(3120, zzYZC2);
        this.zzZy(3140, zzYZC2);
        this.zzZy(3110, zzYZC2);
        this.zzZy(3130, zzYZC2);
        this.zzZy(3090, zzYZC2);
        this.zzZy(3100, zzYZC2);
        this.zzZy(3070, zzYZC2);
        this.zzZy(3080, zzYZC2);
        if (bl && (tableStyle = zzW9B.zzZy((Object)(cell = this).getParentRow().getParentTable().getStyle(), TableStyle.class)) != null) {
            tableStyle.zzYQ9(this, zzYZC2);
        }
        this.zzd9.zzYQ9((zzYxQ)zzYZC2);
        return zzYZC2;
    }

    private void zzZy(int n, zzYZC zzYZC2) {
        zzYZC2.zzZtV(n, this.fetchInheritedCellAttr(n));
    }
}

