/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.List;
import com.aspose.words.ListCollection;
import com.aspose.words.ListLevel;
import com.aspose.words.Paragraph;
import com.aspose.words.internal.zzW9B;
import com.aspose.words.zzBt;
import com.aspose.words.zzWfT;
import com.aspose.words.zzmr;

public class ListFormat {
    private zzmr zzZL9;
    private zzWfT zzZE9;
    private ListCollection zzKW;
    private ListLevel zzYgN;
    private ListLevel zzWSI;

    ListFormat(zzmr parentParaAttrs, zzWfT parentRunAttrs, ListCollection lists) {
        this.zzZL9 = parentParaAttrs;
        this.zzZE9 = parentRunAttrs;
        this.zzKW = lists;
    }

    public void applyBulletDefault() {
        if (this.zzKW.getCount() > 2046) {
            zzBt.zzYQ9(this.zzKW.getDocument().getWarningCallback(), 17, "List count exceed maximum allowed, document can have problem while opened in MS Word.", new Object[0]);
        }
        ListFormat listFormat = this;
        listFormat.zzZyW(listFormat.zzKW.add(0).getListId());
        this.setListLevelNumber(0);
        ListFormat listFormat2 = this;
        this.zzYgN = null;
    }

    public void applyNumberDefault() {
        if (this.zzKW.getCount() > 2046) {
            zzBt.zzYQ9(this.zzKW.getDocument().getWarningCallback(), 17, "List count exceed maximum allowed, document can have problem while opened in MS Word.", new Object[0]);
        }
        ListFormat listFormat = this;
        listFormat.zzZyW(listFormat.zzKW.add(6).getListId());
        this.setListLevelNumber(0);
        ListFormat listFormat2 = this;
        this.zzYgN = null;
    }

    public void removeNumbers() {
        this.setList(null);
        ListFormat listFormat = this;
        this.zzYgN = null;
    }

    public void listIndent() throws Exception {
        if (this.zzYB() < 8) {
            ListFormat listFormat = this;
            listFormat.setListLevelNumber(listFormat.zzYB() + 1);
            ListFormat listFormat2 = this;
            this.zzYgN = null;
        }
    }

    public void listOutdent() throws Exception {
        if (this.zzYB() > 0) {
            ListFormat listFormat = this;
            listFormat.setListLevelNumber(listFormat.zzYB() - 1);
            ListFormat listFormat2 = this;
            this.zzYgN = null;
        }
    }

    public int getListLevelNumber() {
        Document document = zzW9B.zzZy((Object)this.zzKW.getDocument(), Document.class);
        if (document != null && document.getRevisionsView() == 1) {
            return this.zzZz4();
        }
        return this.zzYB();
    }

    public void setListLevelNumber(int value) {
        this.zzZL9.setParaAttr(1110, value);
        ListFormat listFormat = this;
        this.zzYgN = null;
    }

    final int zzYB() {
        return (Integer)this.zzZL9.fetchParaAttr(1110);
    }

    final int zzZz4() {
        Paragraph paragraph = zzW9B.zzZy((Object)this.zzZL9, Paragraph.class);
        if (paragraph != null) {
            return (Integer)paragraph.zzZvh(1110, 1);
        }
        return this.zzYB();
    }

    public boolean isListItem() {
        return this.getListId() != 0;
    }

    public List getList() {
        int n = this.getListId();
        if (n != 0) {
            return this.zzKW.zzp6(n);
        }
        return null;
    }

    public void setList(List value) {
        if (value == null) {
            this.zzZyW(0);
            this.setListLevelNumber(0);
        } else {
            if (value.getDocument() != this.zzKW.getDocument()) {
                throw new IllegalArgumentException("The list belongs to a different document.");
            }
            if (value.isListStyleDefinition()) {
                throw new IllegalArgumentException("The list is a definition of a list style.");
            }
            this.zzZyW(value.getListId());
        }
        ListFormat listFormat = this;
        this.zzYgN = null;
    }

    final List zz0() {
        int n = this.zzYaF();
        if (n != 0) {
            return this.zzKW.zzp6(n);
        }
        return null;
    }

    public ListLevel getListLevel() {
        try {
            Document document = zzW9B.zzZy((Object)this.zzKW.getDocument(), Document.class);
            if (document != null && document.getRevisionsView() == 1) {
                return this.zzKV();
            }
            return this.zzXh1();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private ListLevel zzXh1() {
        try {
            if (this.zzYgN == null) {
                List list = this.getList();
                ListLevel listLevel = list != null ? list.zzW88(this.zzYB()) : null;
                this.zzYgN = listLevel != null ? new ListLevel(listLevel, this.zzZE9) : null;
            }
            return this.zzYgN;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    final ListLevel zzKV() {
        if (this.zzWSI == null) {
            List list = this.zz0();
            ListLevel listLevel = list != null ? list.zzW88(this.zzZz4()) : null;
            this.zzWSI = listLevel != null ? new ListLevel(listLevel, this.zzZE9) : null;
        }
        return this.zzWSI;
    }

    final int getListId() {
        return (Integer)this.zzZL9.fetchParaAttr(1120);
    }

    private void zzZyW(int n) {
        Object object = this.zzZL9.getDirectParaAttr(1160);
        int n2 = object != null ? (Integer)object : 0;
        int n3 = 0;
        if (n2 != 0 && n != 0 && this.getListLevel() != null && n2 < (n3 = this.getListLevel().zzYUv().zzW0k() + this.getListLevel().zzYUv().zzWY4())) {
            n3 = 0;
        }
        this.zzZL9.setParaAttr(1120, n);
        ListFormat listFormat = this;
        this.zzYgN = null;
        if (n == 0 || object == null || this.getListLevel() == null) {
            return;
        }
        if (n2 == 0) {
            this.zzZL9.removeParaAttr(1160);
            return;
        }
        int n4 = n2 - n3 + this.getListLevel().zzYUv().zzW0k() + this.getListLevel().zzYUv().zzWY4();
        this.zzZL9.setParaAttr(1160, n4);
    }

    private int zzYaF() {
        Paragraph paragraph = zzW9B.zzZy((Object)this.zzZL9, Paragraph.class);
        if (paragraph != null) {
            return (Integer)paragraph.zzZvh(1120, 1);
        }
        return this.getListId();
    }
}

