/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzW9B;
import com.aspose.words.internal.zzXCX;
import com.aspose.words.internal.zzYC0;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzBP;
import com.aspose.words.zzBt;
import com.aspose.words.zzXNX;
import com.aspose.words.zzYOI;
import com.aspose.words.zzZPt;
import com.aspose.words.zzZg7;
import java.util.HashMap;

public abstract class Node
implements Cloneable {
    private Node zzZDH;
    private Node zzwG;
    private Node zzXzg;
    private int zzZKy;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this();
        this.zzWhh(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzZDH == null) {
            return null;
        }
        if (this.zzZDH.getNodeType() == 38) {
            return null;
        }
        return (CompositeNode)this.zzZDH;
    }

    final CompositeNode zzWNf() {
        if (zzBt.zzYpZ(this.getParentNode())) {
            return this.getParentNode().zzWNf();
        }
        return this.getParentNode();
    }

    final CompositeNode zzXJF() {
        if (zzBt.zzYpZ(this.getParentNode()) || zzBt.zzYQM(this.getParentNode())) {
            return this.getParentNode().zzXJF();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this.zzZDH != null) {
            return this.zzZDH.getDocument();
        }
        return null;
    }

    final Document zzXXB() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzX4r() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zzZp6();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzXzg;
    }

    final Node zzYfS() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getPreviousSibling()) != null && zzBt.zzW28((node = node2).getNodeType())) {
        }
        return node2;
    }

    final Node zzW1T() {
        Node node = zzBt.zzZtV(this.getPreviousSibling(), false);
        if (node == null && zzBt.zzYpZ(this.getParentNode())) {
            node = this.getParentNode().zzW1T();
        }
        return node;
    }

    final Node zzYwZ() {
        Node node = zzBt.zzX2X(this.getNextSibling(), false);
        if (node == null && zzBt.zzYpZ(this.getParentNode())) {
            node = this.getParentNode().zzYwZ();
        }
        return node;
    }

    final CompositeNode zzWD3() {
        Node node = this;
        while ((node = node.zzW1T()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzWLY() {
        Node node = this;
        while ((node = node.zzYwZ()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzwG;
    }

    final Node zzcm() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getNextSibling()) != null && zzBt.zzW28((node = node2).getNodeType())) {
        }
        return node2;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzXgQ() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getLastChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzZ0G() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getFirstChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzZjh() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzBt.zzZf6(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzYRf() {
        return this.zzwG;
    }

    final void zzht(Node node) {
        this.zzwG = node;
    }

    final Node zzZCd() {
        return this.zzXzg;
    }

    final void zz5y(Node node) {
        this.zzXzg = node;
    }

    final Node zzYfn() {
        Node node = this;
        if (node.zzwG != null) {
            node = this;
            return node.zzwG;
        }
        return this.getParentNode();
    }

    final int zzRW() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zzBt.zzW8Q(this);
        boolean bl2 = zzBt.zzs1(this);
        boolean bl3 = zzBt.zzYdh(this);
        boolean bl4 = zzBt.zzYyE(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzRW() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 38;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzRW() != 3 && n2 != 6 && n != 27 && n != 35)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzZy(isCloneChildren, new zzZy(this));
    }

    Node zzZy(boolean bl, zzZg7 zzZg72) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzZDH != null) {
            node.zzZDH = this.getDocument().zzYFN();
        }
        node.zzwG = null;
        node.zzXzg = null;
        if (zzZg72 != null) {
            zzZg72.zzXOu(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzZpG(StringBuilder stringBuilder) {
        zzW9B.zzYQ9(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isInstance(compositeNode)) continue;
            return compositeNode;
        }
        return null;
    }

    final zzZPt zzXCL() {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            zzZPt zzZPt2 = zzW9B.zzZy((Object)compositeNode, zzZPt.class);
            if (zzZPt2 == null) continue;
            return zzZPt2;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzYSC(Node node) {
        this.zzZDH = node != null ? node : this.getDocument().zzYFN();
    }

    final void zzWhh(DocumentBase documentBase) {
        this.zzZDH = documentBase != null ? documentBase.zzYFN() : null;
    }

    final boolean zzWQn(Node node) {
        if (node == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzWFZ() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzWvb(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzYc1(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzYlP(Node node, int n) {
        for (Node node2 = this.nextPreOrder(node); node2 != null; node2 = node2.nextPreOrder(node)) {
            if (node2.getNodeType() != 8) continue;
            return node2;
        }
        return null;
    }

    final Node zzZpG(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzVWf(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    final Node zzfJ(Node node) {
        return this.getParentNode().insertAfter(node, this);
    }

    final void zzZ9(Node node, Node node2) {
        this.getParentNode().zzYQ9(node, node2, this);
    }

    final Node zzVZ8(Node node) {
        return this.getParentNode().insertBefore(node, this);
    }

    final void zzXMC(Node node, Node node2) {
        this.getParentNode().zzZy(node, node2, this);
    }

    public String toString(int saveFormat) throws Exception {
        zzYOI zzYOI2 = zzBt.zzW6T(saveFormat);
        return zzYOI2.zzWIR(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzYOI zzYOI2 = zzBt.zzYQ9(saveOptions);
        return zzYOI2.zzWIR(this);
    }

    final Node zzIB(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzBt.zzXPW(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zzBP zzKj() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zzBP.zzZ1V(node);
        }
        return zzBP.zzYxQ(this.getParentNode());
    }

    final zzBP zzXKL() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zzBP.zzYxQ(node);
        }
        return zzBP.zzZ1V(this.getParentNode());
    }

    final boolean zzKX(Node node) {
        return Node.zzYxQ(this, node);
    }

    final boolean zzZe7() {
        return this.getAncestor(1) == null;
    }

    static Node zz91(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zzXCX<Node> zzXCX2 = Node.zzYEr(node);
        zzXCX<Node> zzXCX3 = Node.zzYEr(node2);
        return Node.zzZy(zzXCX2, zzXCX3);
    }

    static boolean zzYxQ(Node node, Node node2) {
        zzXCX<Node> zzXCX2;
        if (node == null || node2 == null) {
            return false;
        }
        zzXCX<Node> zzXCX3 = Node.zzYEr(node);
        Node node3 = Node.zzZy(zzXCX3, zzXCX2 = Node.zzYEr(node2));
        if (node3 == null) {
            return false;
        }
        zzXCX<Node> zzXCX4 = zzXCX3;
        if (zzXCX4.size() == 0 || (zzXCX4 = zzXCX2).size() == 0) {
            zzXCX4 = zzXCX2;
            boolean bl = zzXCX4.size() > 0;
            return bl;
        }
        Object e = zzXCX3.peek();
        Object e2 = zzXCX2.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes(0, false)) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zzXCX<Node> zzYEr(Node node) {
        zzXCX<Node> zzXCX2 = new zzXCX<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzXCX2.push(node2);
        }
        return zzXCX2;
    }

    private static Node zzZy(zzXCX<Node> zzXCX2, zzXCX<Node> zzXCX3) {
        Node node = null;
        while (zzXCX2.peek() == zzXCX3.peek()) {
            node = (Node)zzXCX2.pop();
            zzXCX3.pop();
            zzXCX<Node> zzXCX4 = zzXCX2;
            if (zzXCX4.size() != 0 && (zzXCX4 = zzXCX3).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "StructuredDocumentTagRangeStart";
            }
            case 30: {
                return "StructuredDocumentTagRangeEnd";
            }
            case 31: {
                return "GlossaryDocument";
            }
            case 32: {
                return "BuildingBlock";
            }
            case 33: {
                return "CommentRangeStart";
            }
            case 34: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 35: {
                return "OfficeMath";
            }
            case 36: {
                return "SubDocument";
            }
            case 37: {
                return "System";
            }
            case 38: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    public int getCustomNodeId() {
        return this.zzZKy;
    }

    public void setCustomNodeId(int value) {
        this.zzZKy = value;
    }

    private String zzYZj() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node = this; node != null && node.getParentNode() != null; node = node.getParentNode()) {
            int n = 0;
            for (Node node2 = node.getParentNode().getFirstChild(); node2 != null && node2 != node; node2 = node2.getNextSibling()) {
                ++n;
            }
            zzW9B.zzZy(stringBuilder, "{0}{1}", node == this ? "" : ".", n);
        }
        return zzYC0.zzX17(stringBuilder.toString());
    }

    public String toString() {
        return zzYC0.zzX17(zzYC0.zzYQ9("{0} {1}", Node.nodeTypeToString(this.getNodeType()), this.zzYZj()));
    }

    public void dd() {
    }

    final Node zzXMU(int ... nArray) {
        Node node;
        for (node = this.getNextSibling(); node != null && !node.zzWUL(nArray); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzZJd(int ... nArray) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && !node.zzWUL(nArray); node = node.getPreviousSibling()) {
        }
        return node;
    }

    private boolean zzWUL(int ... nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.getNodeType() != n2) continue;
            return true;
        }
        return false;
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    static final class zzZy
    implements zzZg7 {
        private Node zzXHF;
        private HashMap<Integer, Integer> zzXt6;

        zzZy(Node node) {
            this.zzXHF = node;
        }

        @Override
        public final void zzXOu(Node node, Node node2) {
            if (node == this.zzXHF) {
                return;
            }
            if (node2.getNodeType() != 19 && node2.getNodeType() != 33 && node2.getNodeType() != 34) {
                return;
            }
            zzXNX zzXNX2 = (zzXNX)((Object)node2);
            if (this.zzXt6 == null) {
                this.zzXt6 = new HashMap();
            }
            RefInt refInt = new RefInt(0);
            boolean bl = !zzW9B.zzZy(this.zzXt6, Integer.valueOf(zzXNX2.getIdInternal()), refInt);
            int n = refInt.get();
            if (bl) {
                n = node2.getDocument().zzYVh();
                zzW9B.zzYQ9(this.zzXt6, Integer.valueOf(zzXNX2.getIdInternal()), Integer.valueOf(n));
            }
            zzXNX2.setIdInternal(n);
            RefInt refInt2 = new RefInt(0);
            boolean bl2 = zzW9B.zzZy(this.zzXt6, Integer.valueOf(zzXNX2.getParentIdInternal()), refInt2);
            int n2 = refInt2.get();
            if (bl2) {
                zzXNX2.setParentIdInternal(n2);
            }
        }
    }
}

