/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IDocumentSavingCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XlsxSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzY9R;
import com.aspose.words.internal.zzYB5;

public abstract class SaveOptions {
    private IDocumentSavingCallback zzY5Q;
    private boolean zzZ1F;
    boolean zzZHr = true;
    private boolean zzWn4 = true;
    private boolean zz7k = false;
    private boolean zzkJ;
    private boolean zzXE2 = true;
    private boolean zzCT;
    private String zzWZ1;
    private boolean zzYlm;
    private boolean zzZL2 = false;
    private int zzWKv = 1;
    private int zzXzt = 1;
    private int zzWNX = 0;
    private String zzZti = "";
    private boolean zzVQ3 = true;
    private boolean zzZZT = true;
    private boolean zzBL;
    private boolean zzVUK;
    private int zzXeF = 0;
    private boolean zzXP3 = true;
    private boolean zzYeH = false;

    protected SaveOptions() {
    }

    final boolean zzYqO() {
        return this.zzkJ;
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzZ3y() {
        return false;
    }

    boolean zz2E() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzXE2;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzXE2 = value;
    }

    public String getTempFolder() {
        return this.zzWZ1;
    }

    public void setTempFolder(String value) {
        this.zzWZ1 = value;
    }

    public boolean getPrettyFormat() {
        return this.zzCT;
    }

    public void setPrettyFormat(boolean value) {
        this.zzCT = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzYlm;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzYlm = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzZL2;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzZL2 = value;
    }

    public int getDmlRenderingMode() {
        return this.zzWKv;
    }

    public void setDmlRenderingMode(int value) {
        this.zzWKv = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzWNX;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzWNX = value;
    }

    public int getImlRenderingMode() {
        return this.zzXzt;
    }

    public void setImlRenderingMode(int value) {
        this.zzXzt = value;
    }

    public String getDefaultTemplate() {
        return this.zzZti;
    }

    public void setDefaultTemplate(String value) {
        this.zzZti = value;
    }

    public boolean getUpdateFields() {
        return this.zzVQ3;
    }

    public void setUpdateFields(boolean value) {
        this.zzVQ3 = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzBL;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzBL = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzVUK;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzVUK = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzYeH;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzYeH = value;
    }

    public boolean getMemoryOptimization() {
        return this.zz7k;
    }

    public void setMemoryOptimization(boolean value) {
        this.zz7k = value;
    }

    final boolean zzYli() {
        return this.zzZZT;
    }

    final boolean zzZWZ() {
        return this.zzXP3;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                return new ImageSaveOptions(saveFormat);
            }
            case 80: {
                return new XlsxSaveOptions();
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zz4E(zzYB5.zzW8Q(zzY9R.zzYJe(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzXeF;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzXeF = value;
    }

    public IDocumentSavingCallback getProgressCallback() {
        return this.zzY5Q;
    }

    public void setProgressCallback(IDocumentSavingCallback value) {
        this.zzY5Q = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzZ1F;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzZ1F = value;
    }

    final boolean zzZv2() {
        return this.zzWn4;
    }

    final void zzZZ3(boolean bl) {
        this.zzWn4 = false;
    }
}

