/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen;

import com.atlassian.plugins.codegen.ClassId;
import com.atlassian.plugins.codegen.PluginProjectChange;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class ComponentDeclaration
implements PluginProjectChange {
    private final ClassId classId;
    private final String key;
    private final Visibility visibility;
    private final Optional<String> name;
    private final Optional<String> nameI18nKey;
    private final Optional<String> description;
    private final Optional<String> descriptionI18nKey;
    private final Optional<ClassId> interfaceId;
    private final Optional<String> alias;
    private final Optional<String> application;
    private final ImmutableMap<String, String> serviceProperties;

    public static Builder builder(ClassId classId, String key) {
        return new Builder(classId, key);
    }

    public static ComponentDeclaration componentDeclaration(ClassId classId, String key) {
        return ComponentDeclaration.builder(classId, key).build();
    }

    private ComponentDeclaration(Builder builder) {
        this.classId = builder.classId;
        this.visibility = builder.visibility;
        this.key = builder.key;
        this.name = builder.name;
        this.nameI18nKey = builder.nameI18nKey;
        this.description = builder.description;
        this.descriptionI18nKey = builder.descriptionI18nKey;
        this.interfaceId = builder.interfaceId;
        this.alias = builder.alias;
        this.application = builder.application;
        this.serviceProperties = ImmutableMap.copyOf((Map)builder.serviceProperties);
    }

    public ClassId getClassId() {
        return this.classId;
    }

    public String getKey() {
        return this.key;
    }

    public Optional<ClassId> getInterfaceId() {
        return this.interfaceId;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<String> getNameI18nKey() {
        return this.nameI18nKey;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public Optional<String> getDescriptionI18nKey() {
        return this.descriptionI18nKey;
    }

    public Optional<String> getAlias() {
        return this.alias;
    }

    public Optional<String> getApplication() {
        return this.application;
    }

    public ImmutableMap<String, String> getServiceProperties() {
        return this.serviceProperties;
    }

    public String toString() {
        return "[component: " + this.classId + "]";
    }

    public static class Builder {
        private final ClassId classId;
        private final String key;
        private Visibility visibility = Visibility.PRIVATE;
        private Optional<String> name = Optional.empty();
        private Optional<String> nameI18nKey = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> descriptionI18nKey = Optional.empty();
        private Optional<ClassId> interfaceId = Optional.empty();
        private Optional<String> alias = Optional.empty();
        private Optional<String> application = Optional.empty();
        private Map<String, String> serviceProperties = new HashMap<String, String>();

        public Builder(ClassId classId, String key) {
            this.classId = (ClassId)Preconditions.checkNotNull((Object)classId, (Object)"classId");
            this.key = (String)Preconditions.checkNotNull((Object)key, (Object)"key");
        }

        public ComponentDeclaration build() {
            return new ComponentDeclaration(this);
        }

        public Builder interfaceId(Optional<ClassId> interfaceId) {
            this.interfaceId = (Optional)Preconditions.checkNotNull(interfaceId, (Object)"interfaceId");
            return this;
        }

        public Builder visibility(Visibility visibility) {
            this.visibility = (Visibility)((Object)Preconditions.checkNotNull((Object)((Object)visibility), (Object)"visibility"));
            return this;
        }

        public Builder name(Optional<String> name) {
            this.name = (Optional)Preconditions.checkNotNull(name, (Object)"name");
            return this;
        }

        public Builder nameI18nKey(Optional<String> nameI18nKey) {
            this.nameI18nKey = (Optional)Preconditions.checkNotNull(nameI18nKey, (Object)"nameI18nKey");
            return this;
        }

        public Builder description(Optional<String> description) {
            this.description = (Optional)Preconditions.checkNotNull(description, (Object)"description");
            return this;
        }

        public Builder descriptionI18nKey(Optional<String> descriptionI18nKey) {
            this.descriptionI18nKey = (Optional)Preconditions.checkNotNull(descriptionI18nKey, (Object)"descriptionI18nKey");
            return this;
        }

        public Builder alias(Optional<String> alias) {
            this.alias = (Optional)Preconditions.checkNotNull(alias, (Object)"alias");
            return this;
        }

        public Builder application(Optional<String> application) {
            this.application = (Optional)Preconditions.checkNotNull(application, (Object)"application");
            return this;
        }

        public Builder serviceProperties(Map<String, String> serviceProperties) {
            this.serviceProperties.putAll((Map)Preconditions.checkNotNull(serviceProperties, (Object)"serviceProperties"));
            return this;
        }
    }

    public static enum Visibility {
        PUBLIC,
        PRIVATE;

    }
}

