/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen;

import com.atlassian.plugins.codegen.ClassId;
import com.atlassian.plugins.codegen.PluginProjectChange;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Optional;

public final class ComponentImport
implements PluginProjectChange {
    private final ClassId interfaceClass;
    private final Optional<String> key;
    private final Optional<String> filter;
    private final ImmutableList<ClassId> alternateInterfaces;

    public static ComponentImport componentImport(ClassId interfaceClass) {
        return new ComponentImport(interfaceClass, Optional.empty(), Optional.empty(), (ImmutableList<ClassId>)ImmutableList.of());
    }

    public static ComponentImport componentImport(String fullyQualifiedInterfaceName) {
        return new ComponentImport(ClassId.fullyQualified(fullyQualifiedInterfaceName), Optional.empty(), Optional.empty(), (ImmutableList<ClassId>)ImmutableList.of());
    }

    private ComponentImport(ClassId interfaceClass, Optional<String> key, Optional<String> filter, ImmutableList<ClassId> alternateInterfaces) {
        this.interfaceClass = (ClassId)Preconditions.checkNotNull((Object)interfaceClass, (Object)"interfaceClass");
        this.key = (Optional)Preconditions.checkNotNull(key, (Object)"key");
        this.filter = (Optional)Preconditions.checkNotNull(filter, (Object)"filter");
        this.alternateInterfaces = (ImmutableList)Preconditions.checkNotNull(alternateInterfaces, (Object)"alternateInterfaces");
    }

    public ComponentImport key(Optional<String> key) {
        return new ComponentImport(this.interfaceClass, key, this.filter, this.alternateInterfaces);
    }

    public ComponentImport filter(Optional<String> filter) {
        return new ComponentImport(this.interfaceClass, this.key, filter, this.alternateInterfaces);
    }

    public ComponentImport alternateInterfaces(ClassId ... interfaceClasses) {
        return new ComponentImport(this.interfaceClass, this.key, this.filter, (ImmutableList<ClassId>)ImmutableList.copyOf((Object[])interfaceClasses));
    }

    public ClassId getInterfaceClass() {
        return this.interfaceClass;
    }

    public Optional<String> getKey() {
        return this.key;
    }

    public Optional<String> getFilter() {
        return this.filter;
    }

    public Iterable<ClassId> getAlternateInterfaces() {
        return this.alternateInterfaces;
    }

    public String toString() {
        return "[component-import: " + this.interfaceClass + "]";
    }
}

