/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen;

import com.atlassian.plugins.codegen.modules.PluginModuleCreator;
import com.atlassian.plugins.codegen.modules.PluginModuleCreatorRegistry;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class PluginModuleCreatorRegistryImpl
implements PluginModuleCreatorRegistry {
    private final Map<String, SortedMap<Class, PluginModuleCreator>> creatorRegistry;

    public PluginModuleCreatorRegistryImpl() {
        ModuleNameComparator comparator = new ModuleNameComparator();
        this.creatorRegistry = new HashMap<String, SortedMap<Class, PluginModuleCreator>>();
        this.creatorRegistry.put("jira", new TreeMap(comparator));
        this.creatorRegistry.put("bamboo", new TreeMap(comparator));
        this.creatorRegistry.put("confluence", new TreeMap(comparator));
        this.creatorRegistry.put("crowd", new TreeMap(comparator));
        this.creatorRegistry.put("fecru", new TreeMap(comparator));
        this.creatorRegistry.put("stash", new TreeMap(comparator));
        this.creatorRegistry.put("refapp", new TreeMap(comparator));
    }

    public void registerModuleCreator(String productId, PluginModuleCreator moduleCreator) {
        Map moduleMap = this.creatorRegistry.get(productId);
        if (null != moduleMap) {
            moduleMap.put(moduleCreator.getClass(), moduleCreator);
        }
    }

    public <T extends PluginModuleCreator> T getModuleCreator(String productId, Class<T> creatorClass) {
        Map moduleMap = this.creatorRegistry.get(productId);
        PluginModuleCreator creator = null;
        if (null != moduleMap) {
            creator = (PluginModuleCreator)creatorClass.cast(moduleMap.get(creatorClass));
        }
        return (T)creator;
    }

    public Map<Class, PluginModuleCreator> getModuleCreatorsForProduct(String productId) {
        SortedMap<Class, PluginModuleCreator> moduleMap = this.creatorRegistry.get(productId);
        if (null != moduleMap) {
            moduleMap = Collections.unmodifiableSortedMap(moduleMap);
        }
        return moduleMap;
    }

    private class ModuleNameComparator
    implements Comparator<Class> {
        private ModuleNameComparator() {
        }

        @Override
        public int compare(Class class1, Class class2) {
            return class1.getSimpleName().compareTo(class2.getSimpleName());
        }
    }
}

