/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.modules.bitbucket.hook;

import com.atlassian.plugins.codegen.PluginProjectChange;
import com.atlassian.plugins.codegen.PluginProjectChangeset;
import com.atlassian.plugins.codegen.ResourceFile;
import com.atlassian.plugins.codegen.annotations.BitbucketPluginModuleCreator;
import com.atlassian.plugins.codegen.modules.AbstractPluginModuleCreator;
import com.atlassian.plugins.codegen.modules.Dependencies;
import com.atlassian.plugins.codegen.modules.bitbucket.hook.BitbucketRepositoryHookProperties;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

@BitbucketPluginModuleCreator
public class BitbucketRepositoryHookModuleCreator
extends AbstractPluginModuleCreator<BitbucketRepositoryHookProperties> {
    public static final String MODULE_NAME = "Repository Hook";
    public static final String TYPE_PRE = "pre";
    public static final String TYPE_POST = "post";
    public static final String TYPE_MERGE_CHECK = "merge";
    public static final String TYPE_DEFAULT = "post";
    public static final Map<String, String> DEFAULT_CLASS_NAME_BY_TYPE = ImmutableMap.of((Object)"pre", (Object)"MyPreReceiveRepositoryHook", (Object)"post", (Object)"MyPostReceiveRepositoryHook", (Object)"merge", (Object)"MyMergeCheckHook");
    public static final List<String> TYPES = ImmutableList.copyOf(DEFAULT_CLASS_NAME_BY_TYPE.keySet());
    private static final String TEMPLATE_PREFIX = "templates/bitbucket/repository-hook/";
    private static final String PRE_RECEIVE_TEMPLATE = "templates/bitbucket/repository-hook/PreReceiveRepositoryHook.java.vtl";
    private static final String ASYNC_POST_RECEIVE_TEMPLATE = "templates/bitbucket/repository-hook/AsyncPostReceiveRepositoryHook.java.vtl";
    private static final String MERGE_CHECK_TEMPLATE = "templates/bitbucket/repository-hook/MergeCheckRepositoryHook.java.vtl";
    private static final String PLUGIN_MODULE_TEMPLATE = "templates/bitbucket/repository-hook/repository-hook-plugin.xml.vtl";
    private static final String SOY_TEMPLATE = "templates/bitbucket/repository-hook/repository-hook.soy.vtl";

    @Override
    public PluginProjectChangeset createModule(BitbucketRepositoryHookProperties props) throws Exception {
        PluginProjectChangeset hookClass = this.createClass(props, props.getClassId(), this.getTemplate(props.getType()));
        PluginProjectChangeset changeset = new PluginProjectChangeset().with(new PluginProjectChange[]{Dependencies.MOCKITO_TEST}).with(this.createModule(props, PLUGIN_MODULE_TEMPLATE)).with(hookClass);
        if (props.getIcon() != null) {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(TEMPLATE_PREFIX + props.getIcon());
            changeset = changeset.with(PluginProjectChangeset.changeset().with(new PluginProjectChange[]{ResourceFile.resourceFile((String)"", (String)props.getIcon(), (byte[])IOUtils.toByteArray((InputStream)in))}));
        }
        if (props.ifConfigured()) {
            changeset = changeset.with(this.createResource(props, "static", props.getSoyFile(), SOY_TEMPLATE));
        }
        return changeset;
    }

    private String getTemplate(String type) {
        String template;
        if (TYPE_PRE.equals(type)) {
            template = PRE_RECEIVE_TEMPLATE;
        } else if ("post".equals(type)) {
            template = ASYNC_POST_RECEIVE_TEMPLATE;
        } else if (TYPE_MERGE_CHECK.equals(type)) {
            template = MERGE_CHECK_TEMPLATE;
        } else {
            throw new RuntimeException("Unsupported type: " + type);
        }
        return template;
    }

    public String getModuleName() {
        return MODULE_NAME;
    }
}

