/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.modules.jira;

import com.atlassian.plugins.codegen.modules.BasicClassModuleProperties;
import com.atlassian.plugins.codegen.modules.common.Label;
import com.atlassian.plugins.codegen.util.ClassnameUtil;
import org.apache.commons.lang3.StringUtils;

public class TabPanelProperties
extends BasicClassModuleProperties {
    public static final String ORDER = "ORDER";
    public static final String LABEL = "LABEL";
    private boolean useCustomClass;

    public TabPanelProperties() {
        this("MyTabPanel");
    }

    public TabPanelProperties(String fqClassName) {
        super(fqClassName);
        this.setOrder(10);
        this.useCustomClass = false;
    }

    @Override
    public void setModuleNameAndKey(String moduleName) {
        if (StringUtils.isNotBlank((CharSequence)moduleName)) {
            this.setModuleName(moduleName);
            this.setModuleKey(ClassnameUtil.camelCaseOrSpaceToDashed(moduleName).toLowerCase());
            this.setDescription("The " + this.getProperty("MODULE_NAME") + " Plugin");
            this.setNameI18nKey(this.getProperty("MODULE_KEY") + ".name");
            this.setDescriptionI18nKey(this.getProperty("MODULE_KEY") + ".description");
        }
    }

    public void setLabel(Label label) {
        this.put(LABEL, label);
        this.addI18nProperty(label.getKey(), label.getValue());
    }

    public Label getLabel() {
        Label label = null;
        if (this.keySet().contains(LABEL)) {
            label = (Label)this.get(LABEL);
        }
        return label;
    }

    public void setOrder(int order) {
        this.setProperty(ORDER, Integer.toString(order));
    }

    public String getOrder() {
        return this.getProperty(ORDER);
    }

    public int getOrderAsInt() {
        return Integer.parseInt(this.getProperty(ORDER));
    }

    public boolean isUseCustomClass() {
        return this.useCustomClass;
    }

    public void setUseCustomClass(boolean useCustomClass) {
        this.useCustomClass = useCustomClass;
    }
}

