/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.codegen.prompter.common.web;

import com.atlassian.maven.plugins.amps.codegen.ConditionFactory;
import com.atlassian.maven.plugins.amps.codegen.ContextProviderFactory;
import com.atlassian.maven.plugins.amps.codegen.prompter.common.AbstractResourcePrompter;
import com.atlassian.plugins.codegen.modules.NameBasedModuleProperties;
import com.atlassian.plugins.codegen.modules.common.Condition;
import com.atlassian.plugins.codegen.modules.common.Conditional;
import com.atlassian.plugins.codegen.modules.common.Conditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

public abstract class AbstractWebFragmentPrompter<T extends NameBasedModuleProperties>
extends AbstractResourcePrompter<T> {
    public static final String CUSTOM_CONDITION = "Custom Condition";
    public static final String CUSTOM_PROVIDER = "Custom Context Provider";

    public AbstractWebFragmentPrompter(Prompter prompter) {
        super(prompter);
    }

    protected String promptForContextProvider() throws PrompterException {
        String fqProvider = "";
        if (this.promptForBoolean("Add Velocity Context Provider", "N")) {
            Map<String, String> productProviders = ContextProviderFactory.getAvailableContextProviders();
            if (productProviders.isEmpty()) {
                fqProvider = this.promptFullyQualifiedJavaClass("Enter Fully Qualified Context Provider Class", this.getDefaultBasePackage() + ".web.contextproviders.MyContextProvider");
            } else {
                String strIndex;
                StringBuilder contextQuery = new StringBuilder("Choose A Context Provider\n");
                ArrayList<String> indexChoices = new ArrayList<String>(productProviders.size());
                HashMap<String, String> indexedValues = new HashMap<String, String>();
                int index = 1;
                for (Map.Entry<String, String> entry : productProviders.entrySet()) {
                    strIndex = Integer.toString(index);
                    contextQuery.append(strIndex + ": " + entry.getKey() + "\n");
                    indexChoices.add(strIndex);
                    indexedValues.put(strIndex, entry.getValue());
                    ++index;
                }
                strIndex = Integer.toString(index);
                contextQuery.append(strIndex + ": " + CUSTOM_PROVIDER + "\n");
                indexChoices.add(strIndex);
                indexedValues.put(strIndex, CUSTOM_PROVIDER);
                contextQuery.append("Choose a number: ");
                String contextAnswer = this.prompt(contextQuery.toString(), indexChoices, "");
                int answerInt = Integer.parseInt(contextAnswer) - 1;
                fqProvider = answerInt < productProviders.size() ? (String)indexedValues.get(contextAnswer) : this.promptFullyQualifiedJavaClass("Enter Fully Qualified Context Provider Class", this.getDefaultBasePackage() + ".web.contextproviders.MyContextProvider");
            }
        }
        return fqProvider;
    }

    protected List<Conditional> promptForConditions() throws PrompterException {
        ArrayList<Conditional> conditionList = new ArrayList<Conditional>();
        if (this.promptForBoolean("Add Conditions?", "N")) {
            Conditions conditions = this.promptForConditionsContainer();
            conditionList.add((Conditional)conditions);
            conditions.addCondition((Conditional)this.promptForCondition());
            this.promptForCondition(conditions);
        }
        return conditionList;
    }

    protected Conditions promptForConditionsContainer() throws PrompterException {
        String conditionType = this.prompt("Condition Type", ANDOR_ANSWERS, "AND");
        return new Conditions(conditionType);
    }

    private void promptForCondition(Conditions conditions) throws PrompterException {
        if (this.promptForBoolean("Add Condition?", "N")) {
            conditions.addCondition((Conditional)this.promptForCondition());
            this.promptForCondition(conditions);
        }
    }

    protected Condition promptForCondition() throws PrompterException {
        String fqCondition;
        Map<String, String> productConditions = ConditionFactory.getAvailableConditions();
        if (productConditions.isEmpty()) {
            fqCondition = this.promptFullyQualifiedJavaClass("Enter Fully Qualified Condition Class", this.getDefaultBasePackage() + ".web.condition.MyCondition");
        } else {
            String strIndex;
            StringBuilder conditionQuery = new StringBuilder("Choose A Condition\n");
            ArrayList<String> indexChoices = new ArrayList<String>(productConditions.size());
            HashMap<String, String> indexedValues = new HashMap<String, String>();
            int index = 1;
            for (Map.Entry<String, String> entry : productConditions.entrySet()) {
                strIndex = Integer.toString(index);
                conditionQuery.append(strIndex + ": " + entry.getKey() + "\n");
                indexChoices.add(strIndex);
                indexedValues.put(strIndex, entry.getValue());
                ++index;
            }
            strIndex = Integer.toString(index);
            conditionQuery.append(strIndex + ": " + CUSTOM_CONDITION + "\n");
            indexedValues.put(strIndex, CUSTOM_CONDITION);
            indexChoices.add(strIndex);
            conditionQuery.append("Choose a number: ");
            String conditionAnswer = this.prompt(conditionQuery.toString(), indexChoices, "");
            int answerInt = Integer.parseInt(conditionAnswer) - 1;
            fqCondition = answerInt < productConditions.size() ? (String)indexedValues.get(conditionAnswer) : this.promptFullyQualifiedJavaClass("Enter Fully Qualified Condition Class", this.getDefaultBasePackage() + ".web.condition.MyCondition");
        }
        Condition condition = new Condition(fqCondition);
        Map<String, String> params = this.promptForParams("Add Condition Parameter?");
        condition.setParams(params);
        condition.setInvert(this.promptForBoolean("Invert Condition?", "N"));
        return condition;
    }
}

