/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.codegen.prompter.jira;

import com.atlassian.maven.plugins.amps.codegen.annotations.ModuleCreatorClass;
import com.atlassian.maven.plugins.amps.codegen.prompter.AbstractModulePrompter;
import com.atlassian.plugins.codegen.modules.PluginModuleLocation;
import com.atlassian.plugins.codegen.modules.common.Label;
import com.atlassian.plugins.codegen.modules.jira.ComponentTabPanelModuleCreator;
import com.atlassian.plugins.codegen.modules.jira.TabPanelProperties;
import com.atlassian.plugins.codegen.util.ClassnameUtil;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

@ModuleCreatorClass(value=ComponentTabPanelModuleCreator.class)
public class ComponentTabPanelPrompter
extends AbstractModulePrompter<TabPanelProperties> {
    public ComponentTabPanelPrompter(Prompter prompter) {
        super(prompter);
    }

    @Override
    public TabPanelProperties promptForBasicProperties(PluginModuleLocation moduleLocation) throws PrompterException {
        TabPanelProperties props;
        boolean useGenericClass = this.promptForBoolean("Use GenericTabPanel?", "Y");
        if (useGenericClass) {
            props = new TabPanelProperties("com.atlassian.jira.plugin.componentpanel.impl.GenericTabPanel");
            props.setModuleNameAndKey(this.promptNotBlank("Enter Plugin Module Name", "My Component Tab Panel"));
            this.suppressAdvancedNamePrompt();
        } else {
            String className = this.promptJavaClassname("Enter New Classname", "MyComponentTabPanel");
            String packageName = this.promptJavaPackagename("Enter Package Name", this.getDefaultBasePackage() + ".jira.tabpanels");
            String fqClass = ClassnameUtil.fullyQualifiedName((String)packageName, (String)className);
            props = new TabPanelProperties(fqClass);
        }
        Label label = new Label(props.getModuleKey() + ".label", props.getModuleName());
        props.setLabel(label);
        props.setUseCustomClass(!useGenericClass);
        return props;
    }

    @Override
    public void promptForAdvancedProperties(TabPanelProperties props, PluginModuleLocation moduleLocation) throws PrompterException {
        props.setOrder(this.promptForInt("Order", 10));
        Label label = props.getLabel();
        String labelKey = this.promptNotBlank("Enter Label Key", props.getLabel().getKey());
        String labelValue = this.promptNotBlank("Enter Label Value", props.getLabel().getValue());
        label.setKey(labelKey);
        label.setValue(labelValue);
        props.addI18nProperty(labelKey, labelValue);
    }
}

