/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.codegen.annotations.asm;

import com.atlassian.maven.plugins.amps.codegen.annotations.ModuleCreatorClass;
import com.atlassian.maven.plugins.amps.codegen.prompter.AbstractModulePrompter;
import com.atlassian.maven.plugins.amps.codegen.prompter.PluginModulePrompter;
import com.atlassian.maven.plugins.amps.codegen.prompter.PluginModulePrompterRegistry;
import com.atlassian.plugins.codegen.annotations.asm.AbstractAnnotationParser;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;

public class ModulePrompterAnnotationParser
extends AbstractAnnotationParser {
    public static final String PROMPTER_PACKAGE = "com.atlassian.maven.plugins.amps.codegen.prompter";
    private Log log;
    private PluginModulePrompterRegistry pluginModulePrompterRegistry;
    private Prompter mavenPrompter;

    public ModulePrompterAnnotationParser(PluginModulePrompterRegistry pluginModulePrompterRegistry) {
        this.pluginModulePrompterRegistry = pluginModulePrompterRegistry;
    }

    public void parse() throws Exception {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        this.parse(PROMPTER_PACKAGE, (ClassVisitor)new PropmpterClassVisitor());
        Thread.currentThread().setContextClassLoader(oldLoader);
    }

    public void parse(String basePackage) throws Exception {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        this.parse(basePackage, (ClassVisitor)new PropmpterClassVisitor());
        Thread.currentThread().setContextClassLoader(oldLoader);
    }

    public Prompter getMavenPrompter() {
        return this.mavenPrompter;
    }

    public void setMavenPrompter(Prompter mavenPrompter) {
        this.mavenPrompter = mavenPrompter;
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public class PropmpterClassVisitor
    extends EmptyVisitor {
        private String visitedClassname;
        private boolean isModulePrompter;

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.visitedClassname = ModulePrompterAnnotationParser.normalize((String)name);
            String iface = PluginModulePrompter.class.getName().replace('.', '/');
            this.isModulePrompter = ArrayUtils.contains((Object[])interfaces, (Object)iface);
            if (!this.isModulePrompter) {
                this.isModulePrompter = this.superHasInterface(superName, iface);
            }
            Class<?> modulePrompterClass = null;
            try {
                modulePrompterClass = Class.forName(this.visitedClassname);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (this.isModulePrompter && !AbstractModulePrompter.class.isAssignableFrom(modulePrompterClass)) {
                this.isModulePrompter = false;
                if (null != ModulePrompterAnnotationParser.this.log) {
                    ModulePrompterAnnotationParser.this.log.warn((CharSequence)(this.visitedClassname + " MUST extend " + AbstractModulePrompter.class.getName() + ". NOT REGISTERED"));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private boolean superHasInterface(String superName, String interfaceName) {
            InputStream is;
            boolean hasInterface;
            block5: {
                hasInterface = false;
                if (ModulePrompterAnnotationParser.normalize((String)superName).equals("java.lang.Object")) {
                    return hasInterface;
                }
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                String path = superName.replace('.', '/');
                is = null;
                try {
                    ClassReader classReader;
                    is = classLoader.getResourceAsStream(path + ".class");
                    if (null == is || (hasInterface = ArrayUtils.contains((Object[])(classReader = new ClassReader(is)).getInterfaces(), (Object)interfaceName))) break block5;
                    hasInterface = this.superHasInterface(classReader.getSuperName(), interfaceName);
                }
                catch (Exception e) {
                    IOUtils.closeQuietly(is);
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                }
            }
            IOUtils.closeQuietly((InputStream)is);
            return hasInterface;
        }

        public AnnotationVisitor visitAnnotation(String annotationName, boolean isVisible) {
            String normalizedName = ModulePrompterAnnotationParser.normalize((String)annotationName);
            if (this.isModulePrompter && ModuleCreatorClass.class.getName().equals(normalizedName)) {
                return new ModuleCreatorClassAnnotationVisitor(normalizedName);
            }
            return null;
        }

        public MethodVisitor visitMethod(int i, String s, String s1, String s2, String[] strings) {
            return null;
        }

        public FieldVisitor visitField(int i, String s, String s1, String s2, Object o) {
            return null;
        }

        private class ModuleCreatorClassAnnotationVisitor
        extends EmptyVisitor {
            private String annotationName;

            private ModuleCreatorClassAnnotationVisitor(String annotationName) {
                this.annotationName = annotationName;
            }

            public void visit(String name, Object value) {
                super.visit(name, value);
                Type creatorType = (Type)value;
                String normalizedCreatorName = ModulePrompterAnnotationParser.normalize((String)creatorType.getClassName());
                try {
                    Class<?> creatorClass = Class.forName(normalizedCreatorName);
                    Class<?> modulePrompterClass = Class.forName(PropmpterClassVisitor.this.visitedClassname);
                    Class[] argTypes = new Class[]{Prompter.class};
                    Object[] args = new Object[]{ModulePrompterAnnotationParser.this.mavenPrompter};
                    Constructor<?> prompterConstructor = modulePrompterClass.getConstructor(argTypes);
                    if (null != prompterConstructor) {
                        PluginModulePrompter modulePrompter = (PluginModulePrompter)prompterConstructor.newInstance(args);
                        ModulePrompterAnnotationParser.this.pluginModulePrompterRegistry.registerModulePrompter(creatorClass, modulePrompter);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void visitEnd() {
                super.visitEnd();
            }
        }
    }
}

