/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.codegen.prompter;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.components.interactivity.InputHandler;
import org.codehaus.plexus.components.interactivity.OutputHandler;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.util.StringUtils;

public class PrettyPrompter
implements Prompter {
    private OutputHandler outputHandler;
    private InputHandler inputHandler;

    public String prompt(String message) throws PrompterException {
        try {
            this.writePrompt(message);
        }
        catch (IOException e) {
            throw new PrompterException("Failed to present prompt", (Throwable)e);
        }
        try {
            return this.inputHandler.readLine();
        }
        catch (IOException e) {
            throw new PrompterException("Failed to read user response", (Throwable)e);
        }
    }

    public String prompt(String message, String defaultReply) throws PrompterException {
        try {
            this.writePrompt(this.formatMessage(message, null, defaultReply));
        }
        catch (IOException e) {
            throw new PrompterException("Failed to present prompt", (Throwable)e);
        }
        try {
            String line = this.inputHandler.readLine();
            if (StringUtils.isEmpty((String)line)) {
                line = defaultReply;
            }
            return line;
        }
        catch (IOException e) {
            throw new PrompterException("Failed to read user response", (Throwable)e);
        }
    }

    public String prompt(String message, List possibleValues, String defaultReply) throws PrompterException {
        String line;
        String formattedMessage = this.formatMessage(message, possibleValues, defaultReply);
        do {
            try {
                this.writePrompt(formattedMessage);
            }
            catch (IOException e) {
                throw new PrompterException("Failed to present prompt", (Throwable)e);
            }
            try {
                line = this.inputHandler.readLine();
            }
            catch (IOException e) {
                throw new PrompterException("Failed to read user response", (Throwable)e);
            }
            if (StringUtils.isEmpty((String)line)) {
                line = defaultReply;
            }
            if (line == null || possibleValues.contains(line)) continue;
            try {
                String invalid = MessageUtils.buffer().failure((Object)"Invalid selection.").toString();
                this.outputHandler.writeLine(invalid);
            }
            catch (IOException e) {
                throw new PrompterException("Failed to present feedback", (Throwable)e);
            }
        } while (line == null || !possibleValues.contains(line));
        return line;
    }

    public String prompt(String message, List possibleValues) throws PrompterException {
        return this.prompt(message, possibleValues, null);
    }

    public String promptForPassword(String message) throws PrompterException {
        try {
            this.writePrompt(message);
        }
        catch (IOException e) {
            throw new PrompterException("Failed to present prompt", (Throwable)e);
        }
        try {
            return this.inputHandler.readPassword();
        }
        catch (IOException e) {
            throw new PrompterException("Failed to read user response", (Throwable)e);
        }
    }

    protected String formatMessage(String message, List possibleValues, String defaultReply) {
        MessageBuilder builder = MessageUtils.buffer().a((CharSequence)message);
        if (possibleValues != null && !possibleValues.isEmpty()) {
            builder.a((CharSequence)" (");
            Iterator it = possibleValues.iterator();
            while (it.hasNext()) {
                String possibleValue = (String)it.next();
                builder.strong((Object)possibleValue);
                if (!it.hasNext()) continue;
                builder.a((CharSequence)"/");
            }
            builder.a((CharSequence)")");
        }
        if (defaultReply != null) {
            builder.success((Object)" [").success((Object)defaultReply).success((Object)"]");
        }
        return builder.toString();
    }

    private void writePrompt(String message) throws IOException {
        this.outputHandler.write(message + ": ");
    }

    public void showMessage(String message) throws PrompterException {
        try {
            this.writePrompt(message);
        }
        catch (IOException e) {
            throw new PrompterException("Failed to present prompt", (Throwable)e);
        }
    }
}

