/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.codegen.annotations.asm;

import com.atlassian.maven.plugins.amps.codegen.annotations.ModuleCreatorClass;
import com.atlassian.maven.plugins.amps.codegen.prompter.AbstractModulePrompter;
import com.atlassian.maven.plugins.amps.codegen.prompter.PluginModulePrompter;
import com.atlassian.maven.plugins.amps.codegen.prompter.PluginModulePrompterRegistry;
import com.atlassian.plugins.codegen.AsmUtil;
import com.atlassian.plugins.codegen.annotations.asm.AbstractAnnotationParser;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ModulePrompterAnnotationParser
extends AbstractAnnotationParser {
    private static final String PROMPTER_PACKAGE = "com.atlassian.maven.plugins.amps.codegen.prompter";
    private final PluginModulePrompterRegistry pluginModulePrompterRegistry;
    private Log log;
    private Prompter mavenPrompter;

    public ModulePrompterAnnotationParser(PluginModulePrompterRegistry pluginModulePrompterRegistry) {
        this.pluginModulePrompterRegistry = pluginModulePrompterRegistry;
    }

    public void parse() throws Exception {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        this.parse(PROMPTER_PACKAGE, new PrompterClassVisitor());
        Thread.currentThread().setContextClassLoader(oldLoader);
    }

    public void parse(String basePackage) throws Exception {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        this.parse(basePackage, new PrompterClassVisitor());
        Thread.currentThread().setContextClassLoader(oldLoader);
    }

    public void setMavenPrompter(Prompter mavenPrompter) {
        this.mavenPrompter = mavenPrompter;
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public class PrompterClassVisitor
    extends ClassVisitor {
        private String visitedClassname;
        private boolean isModulePrompter;

        PrompterClassVisitor() {
            super(AsmUtil.asmOpCode());
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            Class<?> modulePrompterClass;
            this.visitedClassname = ModulePrompterAnnotationParser.normalize((String)name);
            String iface = PluginModulePrompter.class.getName().replace('.', '/');
            this.isModulePrompter = ArrayUtils.contains((Object[])interfaces, (Object)iface);
            if (!this.isModulePrompter) {
                this.isModulePrompter = this.superHasInterface(superName, iface);
            }
            try {
                modulePrompterClass = Class.forName(this.visitedClassname);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(this.visitedClassname + " could not be loaded", e);
            }
            if (this.isModulePrompter && !AbstractModulePrompter.class.isAssignableFrom(modulePrompterClass)) {
                this.isModulePrompter = false;
                if (null != ModulePrompterAnnotationParser.this.log) {
                    ModulePrompterAnnotationParser.this.log.warn((CharSequence)(this.visitedClassname + " MUST extend " + AbstractModulePrompter.class.getName() + ". NOT REGISTERED"));
                }
            }
        }

        private boolean superHasInterface(String superName, String interfaceName) {
            boolean hasInterface = false;
            if (ModulePrompterAnnotationParser.normalize((String)superName).equals("java.lang.Object")) {
                return false;
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            String path = superName.replace('.', '/');
            try (InputStream is = classLoader.getResourceAsStream(path + ".class");){
                ClassReader classReader;
                if (null != is && !(hasInterface = ArrayUtils.contains((Object[])(classReader = new ClassReader(is)).getInterfaces(), (Object)interfaceName))) {
                    hasInterface = this.superHasInterface(classReader.getSuperName(), interfaceName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return hasInterface;
        }

        public AnnotationVisitor visitAnnotation(String annotationName, boolean isVisible) {
            String normalizedName = ModulePrompterAnnotationParser.normalize((String)annotationName);
            if (this.isModulePrompter && ModuleCreatorClass.class.getName().equals(normalizedName)) {
                return new ModuleCreatorClassAnnotationVisitor();
            }
            return null;
        }

        public MethodVisitor visitMethod(int i, String s, String s1, String s2, String[] strings) {
            return null;
        }

        public FieldVisitor visitField(int i, String s, String s1, String s2, Object o) {
            return null;
        }

        private class ModuleCreatorClassAnnotationVisitor
        extends AnnotationVisitor {
            private ModuleCreatorClassAnnotationVisitor() {
                super(AsmUtil.asmOpCode());
            }

            public void visit(String name, Object value) {
                super.visit(name, value);
                Type creatorType = (Type)value;
                String normalizedCreatorName = ModulePrompterAnnotationParser.normalize((String)creatorType.getClassName());
                try {
                    Class<?> creatorClass = Class.forName(normalizedCreatorName);
                    Class<?> modulePrompterClass = Class.forName(PrompterClassVisitor.this.visitedClassname);
                    Class[] argTypes = new Class[]{Prompter.class};
                    Object[] args = new Object[]{ModulePrompterAnnotationParser.this.mavenPrompter};
                    Constructor<?> prompterConstructor = modulePrompterClass.getConstructor(argTypes);
                    PluginModulePrompter modulePrompter = (PluginModulePrompter)prompterConstructor.newInstance(args);
                    ModulePrompterAnnotationParser.this.pluginModulePrompterRegistry.registerModulePrompter(creatorClass, modulePrompter);
                }
                catch (Exception e) {
                    ModulePrompterAnnotationParser.this.log.warn((Throwable)e);
                }
            }
        }
    }
}

