package com.atlassian.annotations;


import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * <p>
 * Indicates that program elements that this annotation is applied to is considered usable by external developers but
 * its contracts have not stabilized.
 * </p>
 * <p>
 * Experimental SPIs may be changed at any time before being marked {@link Internal} or {@link PublicSpi}
 * </p>
 */
@Documented
@Retention(RetentionPolicy.CLASS)
public @interface ExperimentalSpi {
}
