package com.atlassian.logging.log4j.layout.json;

public class JsonContextData
{
    private final String requestId;
    private final String sessionId;
    private final String userKey;

    private JsonContextData(final Builder builder)
    {
        requestId = builder.requestId;
        sessionId = builder.sessionId;
        userKey = builder.userKey;
    }

    public String getRequestId()
    {
        return requestId;
    }

    public String getSessionId()
    {
        return sessionId;
    }

    public String getUserKey()
    {
        return userKey;
    }

    public boolean isEmpty()
    {
        return (requestId == null && sessionId == null && userKey == null);
    }

    public static Builder builder()
    {
        return new Builder();
    }

    public static class Builder
    {
        private String requestId;
        private String sessionId;
        private String userKey;

        public Builder setRequestId(final String requestId)
        {
            this.requestId = requestId;
            return this;
        }

        public Builder setSessionId(final String sessionId)
        {
            this.sessionId = sessionId;
            return this;
        }

        public Builder setUserKey(final String userKey)
        {
            this.userKey = userKey;
            return this;
        }

        public JsonContextData build()
        {
            return new JsonContextData(this);
        }
    }
}
