package com.atlassian.logging.log4j.layout.json;

import java.util.Map;

import org.apache.log4j.spi.LoggingEvent;

/**
 * Provides data necessary to construct a json log.
 */
public interface JsonDataProvider
{
    /**
     * Gets Unicorn fields, environment and hostname.  Result will be memoized by JsonLayout - so this will only called once.
     */
    public JsonStaticData getStaticData();

    /**
     * Gets request context data
     */
    public JsonContextData getContextData(LoggingEvent event);

    /**
     * Data to be injected into the json string, under "ext".  Use periods in key to create objects - for example
     * "a.b" will generate {..., ext: {a: {b: value}}} json.
     */
    public Map<String, String> getExtraData(LoggingEvent event);

    /**
     * @return fully-qualified domain name (FQDN) of this host
     */
    public String getHostName();
}
