/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.logging.log4j.layout;

import com.atlassian.json.marshal.Jsonable;
import com.atlassian.logging.log4j.StackTraceCompressor;
import com.atlassian.logging.log4j.layout.json.DefaultJsonDataProvider;
import com.atlassian.logging.log4j.layout.json.JsonContextData;
import com.atlassian.logging.log4j.layout.json.JsonDataProvider;
import com.atlassian.logging.log4j.layout.json.JsonStaticData;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;

public class JsonLayout
extends Layout {
    private static final String TIME_ZONE = "UTC";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss,S'Z'");
    private static final Joiner STACK_TRACE_JOINER = Joiner.on((String)"\n");
    private JsonDataProvider dataProvider;
    private final JsonFactory jsonFactory = new JsonFactory();
    private JsonStaticData staticData;
    private StackTraceCompressor stackTraceCompressor;
    private boolean filteringApplied = true;
    private int minimumLines = 6;
    private boolean showEludedSummary = false;
    private String filteredFrames;

    public String format(LoggingEvent event) {
        StringWriter stringWriter = new StringWriter();
        try {
            JsonGenerator g = this.jsonFactory.createJsonGenerator((Writer)stringWriter);
            g.writeStartObject();
            this.writeFields(event, g);
            g.writeEndObject();
            g.close();
        }
        catch (IOException e) {
            throw new RuntimeException("JsonLayout - Failed to format", e);
        }
        stringWriter.append("\n");
        return stringWriter.toString();
    }

    public void setDataProvider(JsonDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public void setDataProvider(String dataProviderClazz) {
        try {
            this.dataProvider = (JsonDataProvider)Class.forName(dataProviderClazz).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("JsonDataProvider implementation not found", e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Failed to instantiate JsonDataProvider implementation", e);
        }
    }

    public void setFilteringApplied(boolean filteringApplied) {
        this.filteringApplied = filteringApplied;
    }

    public void setMinimumLines(int minimumLines) {
        this.minimumLines = minimumLines;
    }

    public void setShowEludedSummary(boolean showEludedSummary) {
        this.showEludedSummary = showEludedSummary;
    }

    public void setFilteredFrames(String filteredFrames) {
        this.filteredFrames = filteredFrames;
    }

    private void writeFields(LoggingEvent event, JsonGenerator g) throws IOException {
        this.writeBasicFields(event, g);
        this.writeThrowableFields(event, g);
        this.writeContextFields(event, g);
        this.writeLocationFields(event, g);
        this.writeUnicornFields(g);
        this.writeExtFields(event, g);
    }

    private void writeBasicFields(LoggingEvent event, JsonGenerator g) throws IOException {
        Date date = new Date(event.timeStamp);
        g.writeStringField("timestamp", DATE_FORMAT.format(date));
        g.writeStringField("level", event.getLevel().toString());
        g.writeStringField("serviceId", this.staticData.getServiceId());
        g.writeStringField("product", this.staticData.getProductName());
        g.writeStringField("hostname", this.dataProvider.getHostName());
        g.writeStringField("env", this.staticData.getEnvironment());
        g.writeNumberField("pid", this.staticData.getProcessId());
        g.writeStringField("thread", event.getThreadName());
        g.writeStringField("logger", event.getLoggerName());
        g.writeStringField("message", event.getMessage() == null ? "" : event.getMessage().toString());
    }

    private void writeThrowableFields(LoggingEvent event, JsonGenerator g) throws IOException {
        Object[] throwableStrRep = event.getThrowableStrRep();
        if (throwableStrRep == null || throwableStrRep.length == 0) {
            return;
        }
        g.writeObjectFieldStart("err");
        g.writeStringField("msg", event.getThrowableInformation().getThrowable().getMessage());
        if (this.filteringApplied) {
            StringBuffer stackTrace = new StringBuffer();
            this.stackTraceCompressor.filterStackTrace(stackTrace, (String[])throwableStrRep);
            g.writeStringField("stack", stackTrace.toString());
        } else {
            g.writeStringField("stack", STACK_TRACE_JOINER.join(throwableStrRep));
        }
        g.writeEndObject();
    }

    private void writeContextFields(LoggingEvent event, JsonGenerator g) throws IOException {
        JsonContextData contextData = this.dataProvider.getContextData(event);
        if (!contextData.isEmpty()) {
            g.writeObjectFieldStart("ctx");
            this.writeFieldIfSet(g, "requestId", contextData.getRequestId());
            this.writeFieldIfSet(g, "sessionId", contextData.getSessionId());
            this.writeFieldIfSet(g, "userKey", contextData.getUserKey());
            g.writeEndObject();
        }
    }

    private void writeFieldIfSet(JsonGenerator g, String key, String value) throws IOException {
        if (value != null) {
            g.writeStringField(key, value);
        }
    }

    private void writeLocationFields(LoggingEvent event, JsonGenerator g) throws IOException {
        LocationInfo location = event.getLocationInformation();
        g.writeObjectFieldStart("location");
        this.writeFieldIfSet(g, "class", location.getClassName());
        this.writeFieldIfSet(g, "method", location.getMethodName());
        this.writeFieldIfSet(g, "line", location.getLineNumber());
        g.writeEndObject();
    }

    private void writeUnicornFields(JsonGenerator g) throws IOException {
        if (this.staticData.getDataCenter() == null && this.staticData.getRack() == null) {
            return;
        }
        g.writeObjectFieldStart("unicorn");
        g.writeStringField("dc", this.staticData.getDataCenter());
        g.writeStringField("rack", this.staticData.getRack());
        g.writeEndObject();
    }

    private void writeExtFields(LoggingEvent event, JsonGenerator g) throws IOException {
        Map<String, String> dataTable = this.dataProvider.getExtraData(event);
        HashMap<String, MapOrVal> map = new HashMap<String, MapOrVal>();
        Iterator<Map.Entry<String, String>> i$ = dataTable.entrySet().iterator();
        block0: while (i$.hasNext()) {
            Map.Entry<String, String> entryObj;
            Map.Entry<String, String> entry = entryObj = i$.next();
            String[] keySequence = entry.getKey().split("\\.");
            String value = entry.getValue();
            Map<String, MapOrVal> currentMap = map;
            for (int i = 0; i < keySequence.length; ++i) {
                String key = keySequence[i];
                if (currentMap.containsKey(key)) {
                    if (i == keySequence.length - 1) {
                        LogLog.debug((String)("Collision in MDC for key " + keySequence));
                        continue;
                    }
                    MapOrVal mapOrVal = (MapOrVal)currentMap.get(key);
                    if (mapOrVal.isMap()) {
                        currentMap = mapOrVal.map;
                        continue;
                    }
                    LogLog.debug((String)("Collision in MDC for key " + keySequence));
                    continue block0;
                }
                if (i == keySequence.length - 1) {
                    currentMap.put(key, MapOrVal.newVal(value));
                    currentMap = map;
                    continue;
                }
                MapOrVal newMapOrVal = MapOrVal.newMap();
                currentMap.put(key, newMapOrVal);
                currentMap = newMapOrVal.map;
            }
        }
        if (map.size() == 0) {
            return;
        }
        g.writeObjectFieldStart("ext");
        this.writeExtFieldsFromMap(g, map);
        g.writeEndObject();
    }

    private void writeExtFieldsFromMap(JsonGenerator g, Map<String, MapOrVal> map) throws IOException {
        for (Map.Entry<String, MapOrVal> entry : map.entrySet()) {
            if (entry.getValue().isMap()) {
                g.writeObjectFieldStart(entry.getKey());
                this.writeExtFieldsFromMap(g, entry.getValue().map);
                g.writeEndObject();
                continue;
            }
            Object object = entry.getValue().val;
            if (object instanceof Jsonable) {
                Jsonable jsonobject = (Jsonable)object;
                g.writeFieldName(entry.getKey());
                StringWriter w = new StringWriter();
                jsonobject.write((Writer)w);
                g.writeRawValue(w.toString());
                continue;
            }
            g.writeObjectField(entry.getKey(), object);
        }
    }

    public boolean ignoresThrowable() {
        return false;
    }

    public void activateOptions() {
        if (this.dataProvider == null) {
            this.dataProvider = new DefaultJsonDataProvider();
        }
        this.stackTraceCompressor = StackTraceCompressor.defaultBuilder(this.minimumLines, this.showEludedSummary).filteredFrames(this.filteredFrames).build();
        this.staticData = this.dataProvider.getStaticData();
    }

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone(TIME_ZONE));
    }

    private static class MapOrVal {
        public final Object val;
        public final Map<String, MapOrVal> map;

        private MapOrVal(Object val, Map<String, MapOrVal> map) {
            this.val = val;
            this.map = map;
        }

        public static MapOrVal newMap() {
            return new MapOrVal(null, new TreeMap<String, MapOrVal>());
        }

        public static MapOrVal newVal(Object val) {
            return new MapOrVal(val, null);
        }

        public boolean isMap() {
            return this.map != null;
        }
    }

    private static final class JSON_KEYS {
        private static final String TIMESTAMP = "timestamp";
        private static final String LEVEL = "level";
        private static final String SERVICE_ID = "serviceId";
        private static final String PRODUCT = "product";
        private static final String HOST_NAME = "hostname";
        private static final String ENVIRONMENT = "env";
        private static final String PROCESS_ID = "pid";
        private static final String THREAD = "thread";
        private static final String LOGGER = "logger";
        private static final String MESSAGE = "message";
        private static final String ERROR = "err";
        private static final String ERROR_MESSAGE = "msg";
        private static final String STACK_TRACE = "stack";
        private static final String CONTEXT = "ctx";
        private static final String REQUEST_ID = "requestId";
        private static final String SESSION_ID = "sessionId";
        private static final String USER_KEY = "userKey";
        private static final String UNICORN = "unicorn";
        private static final String DATA_CENTER = "dc";
        private static final String RACK = "rack";
        private static final String LOCATION = "location";
        private static final String CLASS = "class";
        private static final String METHOD = "method";
        private static final String LINE_NUMBER = "line";
        private static final String EXTRA = "ext";

        private JSON_KEYS() {
        }
    }
}

